/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CcsRepoPortfPosition;
import cms.tmx.entity.trade.CcsRepoPosition;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.models.CcsRepoPositionHisServiceImpl;
import cms.tmx.utils.MarketUtils;
import java.io.File;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class CcsRepoPositionHisQueryPart
extends MxPart {
    @FXML
    private TableView<CcsRepoPosition> repoTablePosition;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoSecId;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoTradingDay;
    @FXML
    private TableColumn<CcsRepoPosition, MxNode> repoSide;
    @FXML
    private TableColumn<CcsRepoPosition, Number> repoQty;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoUnit;
    @FXML
    private TableColumn<CcsRepoPosition, Number> repoAmount;
    @FXML
    private TableColumn<CcsRepoPosition, Number> repoRetAmount;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoExpireDeliveryDay;
    @FXML
    private TableColumn<CcsRepoPosition, Number> RepoAvgInterestRate;
    @FXML
    private TableColumn<CcsRepoPosition, Number> repoInterest;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoFirstDeliveryDay;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoLegalRepurchaseDay;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoActualRepurchaseDay;
    @FXML
    private TableColumn<CcsRepoPosition, String> index;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoColAcc;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoColSecAcc;
    @FXML
    private TableColumn<CcsRepoPosition, String> repoColPort;
    @FXML
    private CheckComboBox<Account> ccmbAccnt;
    @FXML
    private TextField secIdSearch;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<MxNode> pageSize;
    @FXML
    private Pagination pagination;
    @FXML
    private Label lbAccnt;
    @FXML
    private Label totalCount;
    @FXML
    protected CheckComboBox<Portfolio> ccmbPort;
    @Inject
    private PortfolioAccountModel subAccMng;
    @FXML
    private GridPane gridDimen;
    @FXML
    private GridPane gridAcct;
    @FXML
    private GridPane gridPort;
    @FXML
    private Label lbPort;
    @FXML
    private TextField jumpPage;
    @FXML
    private Button btnSearch;
    @FXML
    private Tab ccsRepoTab;
    @FXML
    private TabPane tabPane;
    @Inject
    private MxAlert alert;
    @Inject
    private IFundAccountService fundAccntService;
    @Inject
    private IAccountService accntService;
    @Inject
    private MObjFactory of;
    @Inject
    private IBaseApi iba;
    @Inject
    private CcsRepoPositionHisServiceImpl CcsRepoPositionHisService;
    @FXML
    protected ComboBox<MxNode> btnDimension;
    @Inject
    private ExecutorService exe;
    private HisQueryPage<CcsRepoPosition> orderPage;
    protected ObservableList<CcsRepoPosition> repoList = FxUtils.newList();
    private Boolean reBuildCcsPagiCount = true;
    private static final Logger logger = LogManager.getLogger(CcsRepoPositionHisQueryPart.class);
    protected static final String FORMAT = "yyyy-MM-dd";
    protected ObservableList<CcsOrder> orderList = FxUtils.newList();
    private Map<String, String> reactMap = new HashMap<String, String>();
    @FXML
    private MenuItem ccsExcel;

    @FXML
    private void initialize() {
        this.initValue();
        this.initPage();
        this.initCheckBoxPort();
        this.bind();
        this.createTable();
        this.query();
        this.focusRefresh(this.repoTablePosition);
    }

    @FXML
    private void query() {
        this.repoQuery();
    }

    private void repoReset() {
        this.repoList.clear();
        this.pagination.setPageCount(1);
        this.totalCount.setText("0");
    }

    protected void focusRefresh(TableView<? extends Object> tableOrder) {
        tableOrder.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> tableOrder.refresh());
            }
        });
    }

    private void repoQuery() {
        this.checkPortfolio(this.repoTablePosition, this.repoColPort);
        this.repoList.clear();
        this.rebuildPagi(this.orderPage, this.pagination, this.pageSize, "CCS");
        if (this.orderPage.getExtAccntIdList().isEmpty() && this.orderPage.getSubAccntIdList().isEmpty()) {
            this.repoReset();
            return;
        }
        try {
            this.CcsRepoPositionHisService.query(this.orderPage);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.repoList.addAll((Collection)this.orderPage.getDataList());
        if (this.reBuildCcsPagiCount.booleanValue()) {
            this.pagination.setPageCount(this.orderPage.getTotalCount() % this.orderPage.getPageSize() == 0 ? (this.orderPage.getTotalCount() / this.orderPage.getPageSize() == 0 ? 1 : this.orderPage.getTotalCount() / this.orderPage.getPageSize()) : this.orderPage.getTotalCount() / this.orderPage.getPageSize() + 1);
        }
        this.reBuildCcsPagiCount = true;
        this.totalCount.setText(String.valueOf(this.orderPage.totalCountProperty().get()));
        this.repoTablePosition.scrollTo(0);
        if (this.repoTablePosition.getItems() != null && this.repoTablePosition.getItems().size() == 0) {
            this.repoTablePosition.scrollToColumnIndex(0);
        }
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.subAccMng.getPortfolios();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        this.ccmbPort.getItems().add((Object)portfolio);
        this.ccmbPort.getItems().addAll(listPort);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPort);
        checkComboBoxModel.init();
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
            ObservableList listPortId = FxUtils.newList();
            for (Portfolio port : checkedItems) {
                if (port.getId().isEmpty()) continue;
                listPortId.add(port.getName());
            }
            String portStr = listPortId.toString();
            this.lbPort.setText(portStr.substring(1, portStr.length() - 1));
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    private void rebuildPagi(HisQueryPage orderPage, Pagination pagination, ComboBox<MxNode> pageSize, String marketGrp) {
        String raw = ((MxNode)this.btnDimension.getValue()).getRaw();
        orderPage.setDimension(raw);
        orderPage.setCurrentPage(Integer.valueOf(pagination.getCurrentPageIndex()));
        orderPage.setPageSize(Integer.valueOf(((MxNode)pageSize.getValue()).getRaw()));
        orderPage.setMarketGrp(marketGrp);
        orderPage.setPositionType("REPO");
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        ObservableList listAcc = FxUtils.newList();
        LinkedList<String> list = new LinkedList<String>();
        String dimension = orderPage.getDimension();
        if (dimension.equals("1")) {
            this.fundAccntService.getFundAccountList().forEach(arg_0 -> this.lambda$2(marketGrp, (List)listAcc, arg_0));
            orderPage.setExtAccntIdList((List)listAcc);
        } else {
            for (Portfolio portfolio : this.ccmbPort.getCheckModel().getCheckedItems()) {
                if (portfolio.getId().isEmpty()) continue;
                for (CcsFundAccount fundAccnt : this.subAccMng.getMap(portfolio).keySet()) {
                    if (!(fundAccnt instanceof CcsSubFundAccount)) continue;
                    CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                    list.add(subFundAccnt.getSubAccntId());
                }
            }
            orderPage.setSubAccntIdList(list);
        }
    }

    private void initPage() {
        this.pagination.setPageCount(1);
        this.pagination.currentPageIndexProperty().addListener(e -> {
            this.reBuildCcsPagiCount = false;
            this.repoQuery();
        });
    }

    private void bind() {
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.orderPage.securityIdProperty().bind((ObservableValue)this.secIdSearch.textProperty());
        this.pageSize.valueProperty().addListener(e -> this.repoQuery());
        this.jumpPage.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.repoTablePosition.requestFocus();
            }
        });
        this.jumpPage.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && !"".equals(this.jumpPage.getText())) {
                this.pagination.setCurrentPageIndex(Integer.valueOf(this.jumpPage.getText()) - 1);
            }
        });
        this.jumpPage.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
    }

    protected <E> void checkPortfolio(TableView<E> tableBase, TableColumn<E, ?> portfolio) {
        String dimension = ((MxNode)this.btnDimension.getValue()).getRaw();
        ObservableList columns = tableBase.getColumns();
        if (dimension.equals("1")) {
            if (columns.contains(portfolio)) {
                columns.remove(portfolio);
            }
        } else if (!columns.contains(portfolio)) {
            columns.add(portfolio);
        }
    }

    private void initValue() {
        MxNode diNode = MxNodeFactory.create((String)"query_dimension", (String)"1");
        this.btnDimension.setItems(diNode.getNodes());
        this.gridDimen.getChildren().clear();
        this.btnDimension.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now.getRaw().equals("1")) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAcct});
            } else {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPort});
            }
        });
        this.btnDimension.setValue((Object)diNode);
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
        this.orderPage = (HisQueryPage)this.of.create(HisQueryPage.class);
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"100");
        ObservableList nodes = node.getNodes();
        Collections.sort(nodes, new Comparator<MxNode>(){

            @Override
            public int compare(MxNode c1, MxNode c2) {
                int i = Integer.valueOf(c1.getRaw()) - Integer.valueOf(c2.getRaw());
                return i;
            }
        });
        this.pageSize.setItems(nodes);
        this.pageSize.setValue((Object)node.getNode("100"));
        try {
            ObservableList accountList = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            this.tabHide((ObservableList<Account>)accountList);
            for (Account acc : accountList) {
                if (acc.isExternalAsset()) continue;
                this.ccmbAccnt.getItems().add((Object)acc);
            }
            this.ccmbAccnt.setConverter((StringConverter)new StringConverter<Account>(){

                public String toString(Account accnt) {
                    if (accnt.getInvestorId().isEmpty()) {
                        return accnt.getName();
                    }
                    return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
                }

                public Account fromString(String string) {
                    return null;
                }
            });
        }
        catch (MException e2) {
            this.alert.alert(Alert.AlertType.ERROR, e2.getMessage());
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAccStr = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAccStr.add(account.getInvestorId());
            }
            this.lbAccnt.setText(listAccStr.toString().substring(1, listAccStr.toString().length() - 1));
        });
        this.lbAccnt.textProperty().addListener(e -> this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText())));
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void tabHide(ObservableList<Account> accountList) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : accountList) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsRepoTab);
        }
    }

    private void createTable() {
        this.repoTablePosition.setPlaceholder((Node)new Label());
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.index.setSortable(false);
        this.repoTradingDay.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).tradingDayProperty());
        this.repoSecId.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).secIdProperty());
        this.repoSide.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).sideProperty());
        this.repoQty.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).qtyProperty());
        this.repoUnit.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).repoUnitProperty());
        this.repoAmount.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).amountProperty());
        this.repoAmount.setCellFactory(cell -> new DoubleTableCell());
        this.repoRetAmount.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).retAmountProperty());
        this.repoRetAmount.setCellFactory(cell -> new DoubleTableCell());
        this.RepoAvgInterestRate.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).avgInterestRateProperty());
        this.RepoAvgInterestRate.setCellFactory(cell -> new DoubleTableCell());
        this.repoInterest.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).interestProperty());
        this.repoInterest.setCellFactory(cell -> new DoubleTableCell());
        this.repoFirstDeliveryDay.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).firstDeliveryDayProperty());
        this.repoLegalRepurchaseDay.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).legalRepurchaseDayProperty());
        this.repoActualRepurchaseDay.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).actualRepurchaseDayProperty());
        this.repoExpireDeliveryDay.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).expireDeliveryDayProperty());
        this.repoColAcc.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).investorIdProperty());
        this.repoColSecAcc.setCellValueFactory(data -> ((CcsRepoPosition)data.getValue()).inverstorSecIdProperty());
        this.repoColPort.setCellValueFactory(data -> {
            SimpleStringProperty portName = new SimpleStringProperty("");
            CcsRepoPosition posi = (CcsRepoPosition)data.getValue();
            if (posi instanceof CcsRepoPortfPosition) {
                CcsRepoPortfPosition port = (CcsRepoPortfPosition)CcsRepoPortfPosition.class.cast(posi);
                portName.set((Object)port.getPortfolioName());
            }
            return portName;
        });
        this.repoTablePosition.setPlaceholder((Node)new Label());
        this.repoTablePosition.setItems(this.repoList);
        this.reactMap.put(this.repoTradingDay.getId(), "TradingDay");
        this.reactMap.put(this.repoSecId.getId(), "SecId");
        this.reactMap.put(this.repoSide.getId(), "Side");
        this.reactMap.put(this.repoQty.getId(), "Qty");
        this.reactMap.put(this.repoUnit.getId(), "RepoUnit");
        this.reactMap.put(this.repoAmount.getId(), "Amount");
        this.reactMap.put(this.RepoAvgInterestRate.getId(), "AvgInterestRate");
        this.reactMap.put(this.repoInterest.getId(), "Interest");
        this.reactMap.put(this.repoFirstDeliveryDay.getId(), "FirstDeliveryDay");
        this.reactMap.put(this.repoRetAmount.getId(), "RetAmount");
        this.reactMap.put(this.repoLegalRepurchaseDay.getId(), "LegalRepurchaseDay");
        this.reactMap.put(this.repoActualRepurchaseDay.getId(), "ActualRepurchaseDay");
        this.reactMap.put(this.repoExpireDeliveryDay.getId(), "ExpireDeliveryDay");
        this.reactMap.put(this.repoColAcc.getId(), "InvestorId");
        this.reactMap.put(this.repoColSecAcc.getId(), "InverstorSecId");
        this.reactMap.put(this.repoColPort.getId(), "PortfolioName");
    }

    @FXML
    public void ccsCopy() {
        TableUtils.copyContentWithHead(this.repoTablePosition);
    }

    @FXML
    public void ccsRefresh() {
        this.query();
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u56de\u8d2d\u6301\u4ed3\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<CcsRepoPosition> page = this.CcsRepoPositionHisService.getAllCcsRepoData(this.orderPage);
                    ExcelUtils.writeExcel(this.repoTablePosition, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$2(String string, List list, FundAccount item) {
        if (this.lbAccnt.getText().contains(item.getInvestId()) && string.equals(item.getMarketGrp())) {
            list.add(item.getExtAccntId());
        }
    }

    private class DoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.000");

        private DoubleTableCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    this.setText(this.sDFPrice.format(item));
                }
            } else {
                this.setText(null);
            }
        }
    }
}

