/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.BusinessRef;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.history.IBusinessRefService;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Pagination;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BusinessRefDialog
extends DialogObj {
    @FXML
    private TextField txtBusinessCode;
    @FXML
    private TextField txtBusinessName;
    @FXML
    private ComboBox<MxNode> cmbSourceFlag;
    @FXML
    private ComboBox<MxNode> cmbSide;
    @FXML
    private Button btnAdd;
    @FXML
    private ComboBox<MxNode> ccsPageSize;
    @FXML
    private Pagination ccsPagination;
    @FXML
    private Label ccsTotalCount;
    @FXML
    private TextField ccsJumpPage;
    private HisQueryPage<BusinessRef> pageBusi = new HisQueryPage();
    @FXML
    private TableView<BusinessRef> tableBusinessRef;
    @FXML
    private TableColumn<BusinessRef, String> colBusinessCode;
    @FXML
    private TableColumn<BusinessRef, String> colBusinessName;
    @FXML
    private TableColumn<BusinessRef, MxNode> colSourceFlag;
    @FXML
    private TableColumn<BusinessRef, MxNode> colSide;
    @FXML
    private TableColumn<BusinessRef, HBox> colOperate;
    @FXML
    private TableColumn<BusinessRef, String> colCreateDate;
    private static final Logger logger = LogManager.getLogger(BusinessRefDialog.class);
    @Inject
    private IBusinessRefService busiService;
    @Inject
    private MxAlert alert;
    private MxList<BusinessRef> mxList = new MxList();
    private List<BusinessRef> busiList = new LinkedList<BusinessRef>();
    @Inject
    private ExecutorService exe;
    private String businessCode = "";
    private String businessName = "";
    private String side = "";
    private String sourceFlag = "";

    @FXML
    public void initialize() {
        this.pageBusi.changedProperty().addListener(ob -> this.queryAll());
        this.initValues();
        this.createTableView();
        this.exe.execute(() -> this.queryAll());
    }

    private void initValues() {
        this.txtBusinessCode.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 4));
        this.txtBusinessName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        MxNode node = MxNodeFactory.create((String)"business_source_flag", (String)"1");
        this.cmbSourceFlag.setItems(node.getNodes());
        this.cmbSourceFlag.setValue((Object)node);
        MxNode nodeHD = MxNodeFactory.create((String)"business_side", (String)"1");
        this.cmbSide.setItems(nodeHD.getNodes());
        this.cmbSide.setValue((Object)nodeHD);
    }

    private void queryAll() {
        try {
            this.busiList.clear();
            this.busiList = this.busiService.query();
            this.mxList.update(this.busiList);
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> {
                logger.error("\u67e5\u8be2\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
    }

    @FXML
    private boolean addBusiRef() {
        this.businessCode = this.txtBusinessCode.getText();
        this.businessName = this.txtBusinessName.getText();
        this.sourceFlag = ((MxNode)this.cmbSourceFlag.getSelectionModel().getSelectedItem()).getRaw();
        if ("".equals(this.businessCode)) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e1a\u52a1\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", "\u63d0\u793a");
            return false;
        }
        if ("".equals(this.businessName)) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", "\u63d0\u793a");
            return false;
        }
        for (BusinessRef busi : this.busiList) {
            if (!this.businessCode.equals(busi.getBusinessCode()) || !this.sourceFlag.equals(busi.getSourceFlag().getRaw())) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u8be5\u6240\u5c5e\u7684\u4e1a\u52a1\u4ee3\u7801\u914d\u7f6e\u5df2\u5b58\u5728\uff01", "\u63d0\u793a");
            return false;
        }
        this.side = ((MxNode)this.cmbSide.getSelectionModel().getSelectedItem()).getRaw();
        if ("3".equals(this.side)) {
            this.side = "";
        }
        BusinessRef ref = new BusinessRef();
        MxNode node = MxNodeFactory.create((String)"business_source_flag", (String)"");
        ref.setSourceFlag(node);
        node = MxNodeFactory.create((String)"business_side", (String)"");
        ref.setSide(node);
        ref.setBusinessCode(this.businessCode);
        ref.setBusinessName(this.businessName);
        ref.getSourceFlag().setRaw(this.sourceFlag);
        ref.getSide().setRaw(this.side);
        try {
            this.busiService.addBusinessRef(ref);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u6dfb\u52a0\u6210\u529f", "\u63d0\u793a");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u65b0\u589e\u4e1a\u52a1\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        this.refresh();
        return true;
    }

    private void refresh() {
        this.mxList.clear();
        this.queryAll();
        this.tableBusinessRef.scrollTo(0);
    }

    private void deleteRef(BusinessRef ref) {
        try {
            this.busiService.delBusinessRef(ref);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5220\u9664\u6210\u529f", "\u63d0\u793a");
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u5220\u9664\u4e1a\u52a1\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        this.refresh();
    }

    private void createTableView() {
        this.colBusinessCode.setCellValueFactory(data -> ((BusinessRef)data.getValue()).businessCodeProperty());
        this.colBusinessName.setCellValueFactory(data -> ((BusinessRef)data.getValue()).businessNameProperty());
        this.colSourceFlag.setCellValueFactory(data -> ((BusinessRef)data.getValue()).sourceFlagProperty());
        this.colSide.setCellValueFactory(data -> ((BusinessRef)data.getValue()).sideProperty());
        this.colCreateDate.setCellValueFactory(data -> ((BusinessRef)data.getValue()).lastUpdateTimeProperty());
        this.colOperate.setCellValueFactory(data -> this.setOperate((BusinessRef)data.getValue()));
        this.tableBusinessRef.setPlaceholder((Node)new Label());
        this.tableBusinessRef.setItems(this.mxList.getList());
    }

    private ReadOnlyObjectWrapper<HBox> setOperate(BusinessRef ref) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbDel = new Label("\u5220\u9664");
        lbDel.getStyleClass().add((Object)"btnOperation");
        lbDel.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbDel.setOnMouseClicked(event -> {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664?")) {
                this.deleteRef(ref);
                this.queryAll();
            }
        });
        hBox.getChildren().add(0, (Object)lbDel);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }
}

