/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.query.history.ICcsBasketHisService;
import cms.tmx.query.history.views.HisQueryPart;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasketHisQueryPart
extends HisQueryPart<BasketCcsOrder, Object, Object> {
    private static final Logger logger = LogManager.getLogger(BasketHisQueryPart.class);
    @FXML
    protected TableView<BasketCcsOrder> ccsHisTableBasketTask;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsColBatchSNo;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsColBasketName;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsColFundAccntId;
    @FXML
    protected TableColumn<BasketCcsOrder, Number> ccsColEntrustAmt;
    @FXML
    protected TableColumn<BasketCcsOrder, Number> ccsColWthAmt;
    @FXML
    protected TableColumn<BasketCcsOrder, Number> ccsColDonePct;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsColEntrustTime;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsColEntrustDate;
    @FXML
    protected TableColumn<BasketCcsOrder, MxNode> ccsColEntrustStatus;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsColPortfolioName;
    @FXML
    protected TableView<BasketCcsOrder> ccsBasketTaskDetail;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsDtColSecCode;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsDtColSecName;
    @FXML
    protected TableColumn<BasketCcsOrder, MxNode> ccsDtColBs;
    @FXML
    protected TableColumn<BasketCcsOrder, Number> ccsDtColQuantity;
    @FXML
    protected TableColumn<BasketCcsOrder, Number> ccsDtColPrice;
    @FXML
    protected TableColumn<BasketCcsOrder, Number> ccsDtColPriceAvg;
    @FXML
    protected TableColumn<BasketCcsOrder, Number> ccsDtColEntrustAmt;
    @FXML
    protected TableColumn<BasketCcsOrder, Number> ccsDtColDonePct;
    @FXML
    protected TableColumn<BasketCcsOrder, Number> ccsDtDoneQuantity;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsDtColEntrustTime;
    @FXML
    protected TableColumn<BasketCcsOrder, MxNode> ccsDtColMarket;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsDtColOrderId;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsDtColSecAccntId;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsDtColUserId;
    @FXML
    protected TableColumn<BasketCcsOrder, MxNode> ccsDtColEntrustStatus;
    @FXML
    protected TableColumn<BasketCcsOrder, String> ccsDtColRemark;
    @Inject
    private MxAlert alert;
    @Inject
    private ICcsBasketHisService ccsBasketHisService;
    @Inject
    protected IRefDataMng refMng;
    private BasketCcsOrder selectedItem;
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    private Map<String, String> reactMap = new HashMap<String, String>();

    @Override
    @FXML
    protected void initialize() {
        super.initialize();
        this.initListener();
        this.creatTableCcs();
        this.creatTableCcsDetail();
        this.creatTableCtp();
        this.query();
        this.focusRefresh(this.ccsHisTableBasketTask);
    }

    private void initListener() {
        this.ccsHisTableBasketTask.getSelectionModel().selectedItemProperty().addListener(event -> {
            this.selectedItem = (BasketCcsOrder)this.ccsHisTableBasketTask.getSelectionModel().getSelectedItem();
            if (this.selectedItem != null) {
                this.pageCcs.setQuery((Object)this.selectedItem);
                this.ccsQueryDetail();
            } else {
                this.pageCcs.getDetailList().clear();
            }
        });
    }

    private void ccsQueryDetail() {
        try {
            this.ccsBasketHisService.queryDetail((HisQueryPage<BasketCcsOrder>)this.pageCcs);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void creatTableCcs() {
        TableUtils.initValueFactory(this.ccsHisTableBasketTask);
        this.ccsColBatchSNo.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).batchIdProperty());
        this.reactMap.put(this.ccsColBatchSNo.getId(), "BatchId");
        this.ccsColEntrustDate.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).ordDateProperty());
        this.reactMap.put(this.ccsColEntrustDate.getId(), "OrdDate");
        this.ccsColBasketName.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).basketNameProperty());
        this.reactMap.put(this.ccsColBasketName.getId(), "BasketName");
        this.ccsColFundAccntId.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).investorIdProperty());
        this.reactMap.put(this.ccsColFundAccntId.getId(), "InvestorId");
        this.ccsColWthAmt.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).cxlAmountProperty());
        this.reactMap.put(this.ccsColWthAmt.getId(), "CxlAmount");
        this.ccsColWthAmt.setCellFactory(data -> new DoubleTableCell());
        this.ccsColEntrustAmt.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).orderAmountProperty());
        this.reactMap.put(this.ccsColEntrustAmt.getId(), "OrderAmount");
        this.ccsColEntrustAmt.setCellFactory(data -> new DoubleTableCell());
        this.ccsColDonePct.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).donePercentProperty());
        this.reactMap.put(this.ccsColDonePct.getId(), "DonePercent");
        this.ccsColDonePct.setCellFactory(data -> new DoubleTableCell());
        this.ccsColEntrustTime.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).ordTimeProperty());
        this.reactMap.put(this.ccsColEntrustTime.getId(), "OrdTime");
        this.ccsColEntrustStatus.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).batchStatusProperty());
        this.reactMap.put(this.ccsColEntrustStatus.getId(), "BatchStatus");
        this.ccsColPortfolioName.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).portfolioNameProperty());
        this.reactMap.put(this.ccsColPortfolioName.getId(), "PortfolioName");
        this.ccsHisTableBasketTask.setItems(this.pageCcs.getDataList());
        this.ccsHisTableBasketTask.setPlaceholder((Node)new Label());
    }

    private void creatTableCcsDetail() {
        TableUtils.initValueFactory(this.ccsBasketTaskDetail);
        this.ccsDtColSecCode.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).getInstrument().secIdProperty());
        this.ccsDtColSecName.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).getInstrument().symbolProperty());
        this.ccsDtColEntrustAmt.setCellValueFactory(data -> ((BasketCcsOrder)data.getValue()).orderAmountProperty());
        this.reactMap.put(this.ccsDtColEntrustAmt.getId(), "OrderAmount");
        this.ccsDtColEntrustAmt.setCellFactory(data -> new DoubleTableCell());
        this.ccsDtColBs.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).sideProperty());
        this.ccsDtColBs.setCellFactory(cell -> new SideCell());
        this.ccsDtColQuantity.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).orderQtyProperty());
        this.ccsDtColQuantity.setCellFactory(cell -> new NumberTableCell());
        this.ccsDtColPrice.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).priceProperty());
        this.ccsDtColPrice.setCellFactory(p -> new HisQueryPart.PriceCell(this));
        this.ccsDtColPriceAvg.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).avgPxProperty());
        this.ccsDtColPriceAvg.setCellFactory(data -> new DoubleTableCell());
        this.ccsDtColDonePct.setCellValueFactory(data -> ((BasketCcsOrder)data.getValue()).donePercentProperty());
        this.ccsDtColDonePct.setCellFactory(data -> new DoubleTableCell());
        this.ccsDtColEntrustTime.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).ordTimeProperty());
        this.ccsDtColEntrustStatus.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).ordStatusProperty());
        this.ccsDtDoneQuantity.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).cumQtyProperty());
        this.ccsDtDoneQuantity.setCellFactory(cell -> new NumberTableCell());
        this.ccsDtColMarket.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).getInstrument().marketProperty());
        this.ccsDtColRemark.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).errorInfoProperty());
        this.ccsDtColRemark.setCellFactory(p -> new AutoTableCell());
        this.ccsDtColOrderId.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).extOrderIdProperty());
        this.ccsDtColSecAccntId.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).inverstorSecIdProperty());
        this.ccsDtColUserId.setCellValueFactory(p -> ((BasketCcsOrder)p.getValue()).userIdProperty());
        this.ccsBasketTaskDetail.setItems(this.pageCcs.getDetailList());
        this.ccsBasketTaskDetail.setPlaceholder((Node)new Label());
    }

    private void creatTableCtp() {
    }

    @Override
    protected void ccsQuery() {
        this.checkPortfolio(this.ccsHisTableBasketTask, this.ccsColPortfolioName);
        if (!this.rebuildPagi(this.pageCcs, this.ccsChangeExtAcc)) {
            this.ccsReset();
            return;
        }
        try {
            this.ccsChangeExtAcc = false;
            this.ccsBasketHisService.query((HisQueryPage<BasketCcsOrder>)this.pageCcs);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.ccsHisTableBasketTask.scrollTo(0);
        if (this.pageCcs.getDataList().size() == 0) {
            this.ccsHisTableBasketTask.scrollToColumnIndex(0);
        }
        Platform.runLater(() -> this.ccsHisTableBasketTask.refresh());
    }

    @Override
    protected void ctpQuery() {
    }

    @FXML
    public void ccsRefresh() {
        this.ccsQuery();
    }

    @FXML
    public void ccsDtRefresh() {
        this.ccsQueryDetail();
    }

    @FXML
    public void ccsCopy() {
        TableUtils.copyContentWithHead(this.ccsHisTableBasketTask);
    }

    @FXML
    public void ccsDtCopy() {
        TableUtils.copyContentWithHead(this.ccsBasketTaskDetail);
    }

    @FXML
    public void ctpRefresh() {
        this.ctpQuery();
    }

    @FXML
    public void ctpCopy() {
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u7bee\u5b50\u4efb\u52a1\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<BasketCcsOrder> page = this.ccsBasketHisService.getAllCcsData((HisQueryPage<BasketCcsOrder>)this.pageCcs);
                    ExcelUtils.writeExcel(this.ccsHisTableBasketTask, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void ccsDtExportExcel() {
        try {
            ExcelUtils.writeExcel(this.ccsBasketTaskDetail, (String)"\u7bee\u5b50\u4efb\u52a1\u8be6\u60c5\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private class AutoTableCell<S, T>
    extends TableCell<BasketCcsOrder, T> {
        BasketCcsOrder order;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.order = (BasketCcsOrder)BasketCcsOrder.class.cast(this.getTableRow().getItem());
                if (this.order == null || StringUtils.isEmpty((String)this.order.getErrorInfo())) {
                    return;
                }
                String errorInfo = this.order.getErrorInfo();
                if (!StringUtils.isEmpty((String)errorInfo)) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(errorInfo);
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(errorInfo);
            }
        }
    }
}

