/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.trade.basket.BasketAlgoStrategy;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.views.AdjPositionParamDialog;
import cms.tmx.query.history.models.AlgoStrategyHisQueryModel;
import cms.tmx.query.history.models.PageModel;
import java.io.File;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class AlgoStrategyHisQueryPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(AlgoStrategyHisQueryPart.class);
    @FXML
    private DatePicker dpBegin;
    @FXML
    private DatePicker dpEnd;
    @FXML
    protected ComboBox<MxNode> btnDimension;
    @FXML
    protected CheckComboBox<Account> ccmbAccnt;
    @FXML
    protected CheckComboBox<Portfolio> ccmbPort;
    @FXML
    protected Label lbAccnt;
    @FXML
    protected Label lbPort;
    @FXML
    private GridPane gridDimen;
    @FXML
    private GridPane gridAcct;
    @FXML
    private GridPane gridPort;
    @FXML
    private TabPane tabPane;
    @FXML
    protected TableView<BasketAlgoStrategy> tableAlgo;
    @FXML
    private TableColumn<BasketAlgoStrategy, String> colBelong;
    @FXML
    private TableColumn<BasketAlgoStrategy, Number> exeBuy;
    @FXML
    private TableColumn<BasketAlgoStrategy, Number> dealBuy;
    @FXML
    private TableColumn<BasketAlgoStrategy, Number> exeSell;
    @FXML
    private TableColumn<BasketAlgoStrategy, Number> dealSell;
    @FXML
    private TableColumn<BasketAlgoStrategy, Object> option;
    @FXML
    private Label lbTotal;
    @FXML
    private TextField txtJump;
    @FXML
    private ComboBox<MxNode> cmbSize;
    @FXML
    private Pagination pagi;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private AlgoStrategyHisQueryModel model;
    @Inject
    private IAccountService accntService;
    @Inject
    protected PortfolioAccountModel subAccMng;
    @Inject
    protected IFundAccountService fundAccntService;
    @Inject
    private IBaseApi iba;
    @Inject
    private PortfolioAccountModel portfMng;
    private PageModel<BasketAlgoStrategy> pageModel;
    private String format = "yyyy-MM-dd";
    protected InvalidationListener lstnModel = ob -> {
        if (this.tableAlgo.getItems() != null && this.tableAlgo.getItems().size() == 0) {
            this.tableAlgo.scrollToColumnIndex(0);
        }
        this.tableAlgo.sort();
    };
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    private Map<String, String> reactMap = new HashMap<String, String>();
    protected StringConverter<Account> converter = new StringConverter<Account>(){

        public String toString(Account accnt) {
            if (accnt.getInvestorId().isEmpty()) {
                return accnt.getName();
            }
            return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
        }

        public Account fromString(String string) {
            return null;
        }
    };

    @FXML
    public void initialize() {
        this.pageModel = this.model.initPageModel();
        BasketAlgoStrategy strategy = null;
        this.model.setHisBase(strategy);
        this.tableAlgo.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.model.setHisBase((BasketAlgoStrategy)now));
        this.model.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.initControls();
        this.createTable();
        this.query(true);
    }

    protected void createTable() {
        TableUtils.initValueFactory(this.tableAlgo);
        this.colBelong.setCellValueFactory(data -> {
            if (((BasketAlgoStrategy)data.getValue()).getBizAcct().startsWith("SF")) {
                String name = this.portfMng.getFundAccount(((BasketAlgoStrategy)data.getValue()).getBizAcct(), "CCS").getPortfolioName();
                return new SimpleStringProperty(name);
            }
            return ((BasketAlgoStrategy)data.getValue()).bizAcctProperty();
        });
        this.option.setCellValueFactory(data -> this.setOperate((BasketAlgoStrategy)data.getValue()));
        this.dealBuy.setCellFactory(data -> new NumberTableCell());
        this.dealSell.setCellFactory(data -> new NumberTableCell());
        this.tableAlgo.setItems(this.pageModel.getData());
        this.tableAlgo.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableAlgo);
        this.initReactMap(this.tableAlgo);
        this.reactMap.put(this.colBelong.getId(), "BeLong");
    }

    private void initReactMap(TableView<BasketAlgoStrategy> table) {
        for (TableColumn column : table.getColumns()) {
            String s = column.getId();
            if ("index".equals(s)) continue;
            String columnId = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            this.reactMap.put(s, columnId);
        }
    }

    private void initControls() {
        DatePickerUtils.setDateLimit((DatePicker)this.dpBegin, (DatePicker)this.dpEnd, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.dpBegin, (String)this.format);
        DatePickerUtils.setFormat((DatePicker)this.dpEnd, (String)this.format);
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.dpBegin.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.dpEnd.setValue((Object)ldEnd);
        MxNode node = MxNodeFactory.create((String)"query_dimension", (String)"1");
        this.btnDimension.setItems(node.getNodes());
        this.gridDimen.getChildren().clear();
        this.btnDimension.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now.getRaw().equals("1")) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAcct});
            } else {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPort});
            }
        });
        this.btnDimension.setValue((Object)node);
        this.initCheckBoxAcc();
        this.initCheckBoxPort();
        this.initPage(this.pagi, this.lbTotal, this.txtJump, this.cmbSize, this.pageModel);
    }

    private void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, PageModel<?> pageModel) {
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"20");
        node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw()));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(txtJump.getText()) - 1);
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && "".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(txtJump.getText()) - 1);
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalProperty());
    }

    private void initCheckBoxAcc() {
        try {
            ObservableList listAcc = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            this.ccmbAccnt.getItems().addAll((Collection)listAcc);
            this.ccmbAccnt.setConverter(this.converter);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAccId = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAccId.add(account.getInvestorId());
            }
            String accStr = listAccId.toString();
            this.lbAccnt.setText(accStr.substring(1, accStr.length() - 1));
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.subAccMng.getPortfolios();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        this.ccmbPort.getItems().add((Object)portfolio);
        this.ccmbPort.getItems().addAll(listPort);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPort);
        checkComboBoxModel.init();
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
            ObservableList listPortId = FxUtils.newList();
            for (Portfolio port : checkedItems) {
                if (port.getId().isEmpty()) continue;
                listPortId.add(port.getName());
            }
            String portStr = listPortId.toString();
            this.lbPort.setText(portStr.substring(1, portStr.length() - 1));
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    private ReadOnlyObjectWrapper<Object> setOperate(BasketAlgoStrategy instruction) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button btnParam = new Button("\u7b56\u7565\u53c2\u6570");
        btnParam.getStyleClass().add((Object)"btnOperation");
        btnParam.setOnAction(event -> this.showParam(instruction));
        box.getChildren().add((Object)btnParam);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void showParam(BasketAlgoStrategy instruction) {
        AdjPositionParamDialog adj = (AdjPositionParamDialog)((Object)this.of.create(AdjPositionParamDialog.class));
        adj.setStrategy(instruction);
        MxDialog dialog = this.df.create((DialogObj)adj, "\u53c2\u6570");
        dialog.setBtnText(ButtonType.OK, "\u5173\u95ed");
        dialog.launch();
    }

    private void selectRow(BasketAlgoStrategy instruction) {
        this.tableAlgo.getSelectionModel().select((Object)instruction);
    }

    private void setPageSize(ComboBox<MxNode> cmbSize, PageModel<?> pageModel) {
        int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
        pageModel.setPageSize(pageSize);
    }

    protected List<String> rebuildPagi() {
        LinkedList<String> list = new LinkedList<String>();
        MxNode dimension = (MxNode)this.btnDimension.getValue();
        if (dimension.getRaw().equals("1")) {
            this.fundAccntService.getFundAccountList().forEach(item -> {
                if (this.lbAccnt.getText().contains(item.getInvestId()) && "CCS".equals(item.getMarketGrp())) {
                    list.add(item.getInvestId());
                }
            });
        } else {
            for (Portfolio portfolio : this.ccmbPort.getCheckModel().getCheckedItems()) {
                if (portfolio.getId().isEmpty()) continue;
                for (CcsFundAccount fundAccnt : this.subAccMng.getMap(portfolio).keySet()) {
                    if (!(fundAccnt instanceof CcsSubFundAccount)) continue;
                    CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                    list.add(subFundAccnt.getSubAccntId());
                }
            }
        }
        return list;
    }

    @FXML
    private void query() {
        Tab tab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        boolean isCcs = tab.getText().equals("\u73b0\u8d27\u67e5\u8be2");
        this.query(isCcs);
    }

    private void query(boolean isCcs) {
        String start = ((LocalDate)this.dpBegin.getValue()).toString().replaceAll("-", "");
        String end = ((LocalDate)this.dpEnd.getValue()).toString().replaceAll("-", "");
        List<String> list = this.rebuildPagi();
        if (list.isEmpty()) {
            this.ccsReset();
            return;
        }
        this.model.query(list, start, end);
    }

    protected void ccsReset() {
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableAlgo);
    }

    @FXML
    public void refresh() {
        this.query();
    }

    @FXML
    public void exportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u7b56\u7565\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    ExcelUtils.writeExcel(this.tableAlgo, this.pageModel.getList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }
}

