/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.query.current.views.portfolio.CcsPortfOrderPart;
import cms.tmx.query.history.models.AlgoStrategyHisQueryModel;
import cms.tmx.query.history.views.AlgoHisOrderPart;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.fxml.FXML;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoStrategyHisOrderPart
extends CcsPortfOrderPart {
    @Inject
    private AlgoStrategyHisQueryModel model;
    @Inject
    protected ExecutorService exe;
    private static final Logger logger = LogManager.getLogger(AlgoHisOrderPart.class);
    protected InvalidationListener lstnRefresh = ob -> this.refresh();
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mxList.filter(this.model.getListOrder(), this.pd);
        this.tableOrder.sort();
        this.tableOrder.refresh();
    });
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.model.getListOrder(), this.pd);

    public AlgoStrategyHisOrderPart() {
        this.path = "AlgoHisOrderPart.fxml";
    }

    @Override
    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.onFocus();
        this.refresh();
    }

    @Override
    protected void listener() {
        this.model.getHisOrder().idProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefresh));
        this.model.changedOrderProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
    }

    @Override
    public void refresh() {
        this.tableOrder.getItems().clear();
        this.mxList.clear();
        this.model.getListDeal().clear();
        HisQueryPage<CcsOrder> page = this.model.getHisOrder();
        if (page.getId().isEmpty()) {
            return;
        }
        this.exe.execute(() -> {
            try {
                this.model.queryHisOrder();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
        });
    }
}

