/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.trade.basket.AlgoStrategyDetails;
import cms.tmx.entity.trade.basket.BasketAlgoStrategy;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.history.models.AlgoStrategyHisQueryModel;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoStrategyHisDetailPart
extends MxPart {
    @FXML
    private TableView<AlgoStrategyDetails> tableAlgoDetail;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colIndex;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colsecId;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colSecName;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colSide;
    @FXML
    private TableColumn<AlgoStrategyDetails, Number> colOrderVol;
    @FXML
    private TableColumn<AlgoStrategyDetails, Number> colDeal;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colExeDeal;
    @FXML
    private HBox hboxCount;
    @FXML
    private Label labCount;
    @FXML
    private AnchorPane paneAlgo;
    @FXML
    private RadioButton rbtn;
    @Inject
    private AlgoStrategyHisQueryModel model;
    @Inject
    protected MxAlert alert;
    private static final Logger logger = LogManager.getLogger(AlgoStrategyHisDetailPart.class);
    static BasketAlgoStrategy strategy;
    private MxList<AlgoStrategyDetails> listDetails = new MxList();
    protected InvalidationListener lstnRefresh = ob -> this.refreshLog();
    private Predicate<AlgoStrategyDetails> pd = inst -> {
        boolean b = this.rbtn.isSelected();
        return !b || !"100.00".equals(inst.getExeDeal());
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        ObservableList<AlgoStrategyDetails> observableList = this.model.getListDeatils();
        synchronized (observableList) {
            this.listDetails.update(this.model.getListDeatils(), this.pd);
            this.tableAlgoDetail.sort();
        }
    });

    @FXML
    public void initialize() {
        this.rbtn.selectedProperty().addListener(this.lstnModel);
        this.model.getHisDeal().idProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefresh));
        this.model.changedDetailsProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.creatTable();
        this.refreshLog();
    }

    private void creatTable() {
        TableUtils.isAuto(this.colIndex);
        this.colsecId.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).secNameProperty());
        this.colSide.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).sideProperty());
        this.colSide.setCellFactory(cell -> new SideCell());
        this.colOrderVol.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).orderVolProperty());
        this.colOrderVol.setCellFactory(data -> new NumberTableCell());
        this.colDeal.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).dealProperty());
        this.colDeal.setCellFactory(data -> new NumberTableCell());
        this.colExeDeal.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).exeDealProperty());
        this.tableAlgoDetail.setItems(this.listDetails.getList());
        this.tableAlgoDetail.setPlaceholder((Node)new Label());
    }

    @FXML
    public void copyLog() {
        TableUtils.copyContentWithHead(this.tableAlgoDetail);
    }

    @FXML
    public void refreshLog() {
        this.tableAlgoDetail.getItems().clear();
        this.listDetails.clear();
        if (this.model.getHisDeal().getId().isEmpty()) {
            return;
        }
        this.model.queryDeatail();
    }

    @FXML
    public void exportLog() {
        try {
            ExcelUtils.writeExcel(this.tableAlgoDetail, (String)"\u8c03\u4ed3\u660e\u7ec6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private class SideCell
    extends TableCell<AlgoStrategyDetails, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            switch (value) {
                case "\u4e70\u5165": {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

