/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.query.current.views.portfolio.CcsPortfDealPart;
import cms.tmx.query.history.models.AlgoStrategyHisQueryModel;
import cms.tmx.query.history.views.AlgoHisDealPart;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoStrategyHisDealPart
extends CcsPortfDealPart {
    private static final Logger logger = LogManager.getLogger(AlgoHisDealPart.class);
    @Inject
    private AlgoStrategyHisQueryModel model;
    @Inject
    protected ExecutorService exe;
    protected InvalidationListener lstnRefresh = ob -> this.refresh();
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mxList.filter(this.model.getListDeal(), this.pd);
        Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
        this.tableDeal.sort();
    });
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.model.getListDeal(), this.pd);

    public AlgoStrategyHisDealPart() {
        this.path = "AlgoHisDealPart.fxml";
    }

    @Override
    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.onFocus();
        this.refresh();
    }

    @Override
    protected void afterCreateTable() {
        this.colPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioId()));
        this.colPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
    }

    @Override
    protected void listener() {
        this.model.getHisDeal().idProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefresh));
        this.model.changedDealProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
    }

    @Override
    public void refresh() {
        this.tableDeal.getItems().clear();
        this.mxList.clear();
        HisQueryPage<CcsDeal> page = this.model.getHisDeal();
        if (page.getId().isEmpty()) {
            return;
        }
        this.exe.execute(() -> {
            try {
                this.model.queryHisDeal();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
        });
    }
}

