/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.app.parts.SettingDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.dialog.MxWebDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.StrToNumTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.basket.AlgoStrategyDetails;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.jxb.WebBrowserPart;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.current.models.portfolio.AlgoQueryModel;
import cms.tmx.query.current.views.AdjPositionParamDialog;
import cms.tmx.query.current.views.portfolio.BasketAlgoEvaluateDialog;
import cms.tmx.query.history.models.AlgoHisQueryModel;
import cms.tmx.query.history.models.AlgoHisService;
import cms.tmx.query.history.views.HisQueryPart;
import cms.tmx.query.history.views.OrderHisQueryPart;
import cms.tmx.query.utils.SideCell;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoHisQueryPart
extends HisQueryPart<AlgoBaseOrder, Object, Object> {
    private static final Logger logger = LogManager.getLogger(OrderHisQueryPart.class);
    @FXML
    private TableView<AlgoBaseOrder> tableBase;
    @FXML
    private TableView<AlgoBaseOrder> tableBskBase;
    @FXML
    private TableColumn<AlgoBaseOrder, String> type;
    @FXML
    private TableColumn<AlgoBaseOrder, String> instructionId;
    @FXML
    private TableColumn<AlgoBaseOrder, Number> count;
    @FXML
    private TableColumn<AlgoBaseOrder, Number> dealCount;
    @FXML
    private TableColumn<AlgoBaseOrder, String> avgPrice;
    @FXML
    private TableColumn<AlgoBaseOrder, String> portfolioName;
    @FXML
    private TableColumn<AlgoBaseOrder, Object> operation;
    @FXML
    private TableColumn<AlgoBaseOrder, MxNode> side;
    @FXML
    private TableColumn<AlgoBaseOrder, String> indexBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> instructionIdBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, MxNode> typeBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, MxNode> statusBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> codeBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> nameBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, MxNode> sideBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, Number> countBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, Number> dealCountBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> baseIdBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, Number> exeBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> avgPriceBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> portfolioBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, Object> operationBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> orderDateBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> orderStartTimeBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> orderEndTimeBsk;
    @FXML
    private TableColumn<AlgoBaseOrder, String> orderErrInfoBsk;
    @FXML
    private MenuItem excelApama;
    @FXML
    private MenuItem excelMise;
    @FXML
    private Label lbSecId;
    @FXML
    private TextField bskNameSearch;
    @FXML
    private Tab tabNormal;
    @FXML
    private Tab tabBsk;
    @Inject
    private AlgoHisService hisService;
    @Inject
    private AlgoHisQueryModel model;
    @Inject
    private DialogFactory df;
    private MxList<AlgoBaseOrder> mlist = new MxList();
    private InvalidationListener listener = ob -> Platform.runLater(() -> {
        this.mlist.update(this.hisService.bskList);
        this.tableBskBase.sort();
        this.tableBskBase.refresh();
    });
    @Inject
    private AlgoQueryModel algoQueryModel;
    @Inject
    private ExecutorService exe;
    private Map<String, String> reactMapApama = new HashMap<String, String>();

    @Override
    @FXML
    public void initialize() {
        super.initialize();
        this.model.setHisBase(null);
        this.tableBase.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.baseOrderChange((AlgoBaseOrder)now, false));
        this.createTable();
        this.tabPane.getTabs().remove((Object)this.ctpTab);
        this.query();
        this.focusRefresh(this.tableBase);
        this.createBskTable();
        this.hisService.changedProperty().addListener(this.listener);
        this.tableBskBase.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.baseOrderChange((AlgoBaseOrder)now, true));
        this.bskNameSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.tabBsk.selectedProperty().addListener((ob, old, now) -> {
            this.bskNameSearch.setVisible(now.booleanValue());
            this.secIdSearch.setVisible(now == false);
            this.lbSecId.setText(now != false ? "\u5bf9\u8c61\u540d\u79f0" : "\u8bc1\u5238\u4ee3\u7801");
        });
        this.tabBsk.getTabPane().getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            AlgoBaseOrder baseNormal = (AlgoBaseOrder)this.tableBase.getSelectionModel().getSelectedItem();
            AlgoBaseOrder baseBsk = (AlgoBaseOrder)this.tableBskBase.getSelectionModel().getSelectedItem();
            boolean isBsk = this.tabBsk.equals(now);
            this.baseOrderChange(isBsk ? baseBsk : baseNormal, isBsk);
        });
    }

    private void baseOrderChange(AlgoBaseOrder base, boolean isBsk) {
        this.model.setHisBase(base);
        MEvent event = new MEvent();
        if (isBsk) {
            event.setObj((Object)base);
        }
    }

    @PreDestroy
    public void close() {
        this.hisService.changedProperty().removeListener(this.listener);
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tableBase);
        this.count.setCellFactory(cell -> new NumberTableCell());
        this.dealCount.setCellFactory(cell -> new NumberTableCell());
        this.avgPrice.setCellFactory(cell -> new StrToNumTableCell(4));
        this.operation.setCellValueFactory(data -> this.setOperate((AlgoBaseOrder)data.getValue(), true));
        this.tableBase.setItems(this.pageCcs.getDataList());
        this.tableBase.setPlaceholder((Node)new Label());
        this.side.setCellFactory(cell -> new SideCell());
        this.initReactMap(this.tableBase, this.reactMapApama);
        this.reactMapApama.put(this.operation.getId(), "");
    }

    private void initReactMap(TableView<AlgoBaseOrder> table, Map<String, String> reactMap) {
        for (TableColumn column : table.getColumns()) {
            String s = column.getId();
            if ("index".equals(s)) continue;
            String columnId = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            reactMap.put(s, columnId);
        }
    }

    private void createBskTable() {
        TableUtils.isAuto(this.indexBsk);
        this.typeBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).typeProperty());
        this.instructionIdBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).instructionIdProperty());
        this.statusBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).statusProperty());
        this.codeBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).codeProperty());
        this.nameBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).nameProperty());
        this.sideBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).sideProperty());
        this.sideBsk.setCellFactory(cell -> new SideCell());
        this.countBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).countProperty());
        this.dealCountBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).dealCountProperty());
        this.baseIdBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).baseIdProperty());
        this.exeBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).exeProperty());
        this.avgPriceBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).avgPriceProperty());
        this.portfolioBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).portfolioNameProperty());
        this.orderDateBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).orderDateProperty());
        this.orderStartTimeBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).orderStartTimeProperty());
        this.orderEndTimeBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).orderEndTimeProperty());
        this.orderErrInfoBsk.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).orderErrInfoProperty());
        this.countBsk.setCellFactory(cell -> new NumberTableCell());
        this.dealCountBsk.setCellFactory(cell -> new NumberTableCell());
        this.operationBsk.setCellValueFactory(data -> this.setOperate((AlgoBaseOrder)data.getValue(), false));
        this.tableBskBase.setPlaceholder((Node)new Label());
        this.tableBskBase.setItems(this.mlist.getList());
    }

    protected void afterTableRestore() {
        this.baseIdBsk.setSortType(TableColumn.SortType.DESCENDING);
        this.tableBskBase.getSortOrder().add(this.baseIdBsk);
        this.tableBskBase.sort();
    }

    private ReadOnlyObjectWrapper<Object> setOperate(AlgoBaseOrder order, boolean flag) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button param = new Button("\u7b97\u6cd5\u53c2\u6570");
        Button evaluate = new Button("\u7b97\u6cd5\u8bc4\u4ef7");
        param.getStyleClass().add((Object)"btnOperation");
        evaluate.getStyleClass().add((Object)"btnOperation");
        param.setOnAction(event -> this.lookOver(order));
        evaluate.setOnAction(event -> this.algoEvaluate(order));
        box.getChildren().add((Object)param);
        String raw = order.getType().getRaw();
        if (!"17".equals(raw)) {
            box.getChildren().add((Object)evaluate);
        }
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void lookOver(AlgoBaseOrder order) {
        if (this.isStartegyDialog(order)) {
            return;
        }
        this.tableBase.getSelectionModel().select((Object)order);
        MEvent event = new MEvent();
        try {
            this.algoQueryModel.getOrderDetails(order);
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        event.setObj((Object)order);
        this.es.sendEvent("algo.dialog", event);
    }

    private boolean isStartegyDialog(AlgoBaseOrder order) {
        String type = order.getType().getRaw();
        if (!type.equals("17")) {
            return false;
        }
        AdjPositionParamDialog adj = (AdjPositionParamDialog)((Object)this.of.create(AdjPositionParamDialog.class));
        adj.setStrategy(order);
        MxDialog dialog = this.df.create((DialogObj)adj, "\u53c2\u6570");
        dialog.setBtnText(ButtonType.OK, "\u5173\u95ed");
        dialog.launch();
        return true;
    }

    protected void algoEvaluate(AlgoBaseOrder order) {
        try {
            this.algoQueryModel.getOrderDetails(order);
        }
        catch (MException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        String code = order.getCode();
        String market = order.getMarket();
        String fundAcctId = order.getAlgoParam().getFundAccId();
        String secAcctId = order.getAlgoParam().getSecAccId();
        String subFundId = "";
        String subSecId = "";
        AlgoStrategyDetails details = null;
        if (AlgoMiseMng.isMise(order.getType().getRaw())) {
            details = this.basketAlgoEvaluate(order);
            if (details == null) {
                return;
            }
            code = details.getSecId();
            market = details.getMarket();
            fundAcctId = details.getFundAccntId();
            secAcctId = details.getSecAccntId();
            subFundId = details.getSubFundId();
            subSecId = details.getSubSecId();
        }
        String format = "/algo-evaluate?algoOid=%s&date=%s&secCode=%s&mkt=%s&slot=64&begin=%s&end=%s&fundAcct=%s&secAcct=%s&subFundAcct=%s&subSecAcct=%s";
        SettingDialog sd = (SettingDialog)this.of.create(SettingDialog.class);
        String url = String.format(format, order.getBaseId(), order.getOrderDate(), code, market, order.getOrderStartTime(), order.getOrderEndTime(), fundAcctId, secAcctId, subFundId, subSecId);
        sd.setUrl(url);
        logger.debug(String.valueOf(order.getBaseId()) + " : " + url);
        MxWebDialog dialog = this.df.createWeb((WebBrowserPart)sd, "\u7b97\u6cd5\u8bc4\u4ef7", 1200, 600);
        dialog.launch();
        dialog.disposeBrowser();
    }

    private AlgoStrategyDetails basketAlgoEvaluate(AlgoBaseOrder order) {
        BasketAlgoEvaluateDialog.baseOrder = order;
        BasketAlgoEvaluateDialog deatil = (BasketAlgoEvaluateDialog)((Object)this.of.create(BasketAlgoEvaluateDialog.class));
        MxDialog dialog = this.df.create((DialogObj)deatil, "\u8bf7\u9009\u62e9\u6210\u5206\u80a1");
        ButtonType btnType = dialog.launch();
        if (btnType == ButtonType.OK) {
            return deatil.getSelectedItem();
        }
        return null;
    }

    @Override
    protected void query() {
        if (this.tabNormal.isSelected()) {
            this.pageCcs.clear();
        }
        String raw = ((MxNode)this.btnDimension.getValue()).getRaw();
        this.pageCcs.setDimension(raw);
        this.pageCtp.setDimension(raw);
        this.ccsChangeExtAcc = true;
        this.pageCcs.setSecurityId(this.secIdSearch.getText());
        this.queryAll();
        this.layout();
    }

    @Override
    protected void ccsQuery() {
        if (!this.rebuildPagi(this.pageCcs, this.ccsChangeExtAcc)) {
            this.ccsReset();
            return;
        }
        this.ccsChangeExtAcc = false;
        if (this.tabNormal.isSelected()) {
            this.checkPortfolio(this.tableBase, this.portfolioName);
            try {
                this.hisService.query((HisQueryPage<AlgoBaseOrder>)this.pageCcs);
            }
            catch (MException e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
            if (this.pageCcs.getDataList().size() == 0) {
                this.tableBase.scrollToColumnIndex(0);
            }
            this.tableBase.scrollTo(0);
            this.tableBase.sort();
        } else {
            this.checkPortfolio(this.tableBskBase, this.portfolioBsk);
            this.hisService.queryHisBskAlgo((HisQueryPage<AlgoBaseOrder>)this.pageCcs, this.bskNameSearch.getText());
            if (this.pageCcs.getDataList().size() == 0) {
                this.tableBskBase.scrollToColumnIndex(0);
            }
            this.tableBskBase.sort();
        }
    }

    @Override
    protected void ctpQuery() {
    }

    @FXML
    public void ccsRefresh() {
        this.ccsQuery();
        this.ctpQuery();
    }

    @FXML
    public void ctpRefresh() {
        this.ccsQuery();
        this.ctpQuery();
    }

    @FXML
    public void copyApama() {
        TableUtils.copyContentWithHead(this.tableBase);
    }

    @FXML
    public void copyMise() {
        TableUtils.copyContentWithHead(this.tableBskBase);
    }

    @FXML
    public void ctpCopy() {
    }

    @FXML
    private void exportExcelApama() {
        try {
            File file = ExcelUtils.saveFile((String)"\u7b97\u6cd5\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.excelApama.setDisable(true);
            this.exe.execute(() -> {
                try {
                    ExcelUtils.writeExcel(this.tableBase, this.hisService.getAllCcsData((HisQueryPage<AlgoBaseOrder>)this.pageCcs), this.reactMapApama, (File)file);
                    Platform.runLater(() -> this.excelApama.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.excelApama.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void exportExcelMise() {
        try {
            ExcelUtils.writeExcel(this.tableBskBase, (String)"\u7b97\u6cd5\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void ctpExportExcel() {
    }
}

