/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.query.current.views.portfolio.CcsPortfOrderPart;
import cms.tmx.query.history.models.AlgoHisQueryModel;
import java.util.Collections;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.fxml.FXML;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoHisOrderPart
extends CcsPortfOrderPart {
    @Inject
    private AlgoHisQueryModel hisModel;
    private static final Logger logger = LogManager.getLogger(AlgoHisOrderPart.class);
    protected InvalidationListener lstnRefresh = ob -> this.refresh();
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mxList.clear();
        this.mxList.update(this.hisModel.getListOrder(), this.pd);
        Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableOrder.sort();
    });
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.hisModel.getListOrder(), this.pd);

    @Override
    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.onFocus();
        this.refresh();
    }

    @Override
    protected void listener() {
        this.hisModel.getHisOrder().idProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefresh));
        this.hisModel.changedOrderProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
    }

    @Override
    @PreDestroy
    protected void close() {
        this.hisModel.getHisOrder().idProperty().removeListener(this.lstnRefresh);
        this.hisModel.changedOrderProperty().removeListener(this.lstnModel);
    }

    @Override
    public void refresh() {
        HisQueryPage<CcsOrder> page = this.hisModel.getHisOrder();
        if (page.getId().isEmpty()) {
            this.tableOrder.getItems().clear();
            this.mxList.clear();
            return;
        }
        this.exe.execute(() -> {
            try {
                this.hisModel.queryHisOrder();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
        });
    }
}

