/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.query.current.views.portfolio.CcsPortfDealPart;
import cms.tmx.query.history.models.AlgoHisQueryModel;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoHisDealPart
extends CcsPortfDealPart {
    private static final Logger logger = LogManager.getLogger(AlgoHisDealPart.class);
    @Inject
    private AlgoHisQueryModel hisModel;
    @Inject
    @Named(value="fixed.query.pool")
    private ExecutorService exe;
    protected InvalidationListener lstnRefresh = ob -> this.refresh();
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mxList.update(this.hisModel.getListDeal(), this.pd);
        Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
        this.tableDeal.sort();
    });
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.hisModel.getListDeal(), this.pd);

    @Override
    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.onFocus();
        this.refresh();
    }

    @Override
    protected void afterCreateTable() {
        this.colPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioId()));
        this.colPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
    }

    @Override
    protected void listener() {
        this.hisModel.getHisDeal().idProperty().addListener(this.lstnRefresh);
        this.hisModel.changedDealProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @Override
    @PreDestroy
    protected void close() {
        this.hisModel.getHisDeal().idProperty().removeListener(this.lstnRefresh);
        this.hisModel.changedDealProperty().removeListener(this.lstnModel);
    }

    @Override
    public void refresh() {
        HisQueryPage<CcsDeal> page = this.hisModel.getHisDeal();
        if (page.getId().isEmpty()) {
            this.tableDeal.getItems().clear();
            this.mxList.clear();
            return;
        }
        this.exe.execute(() -> {
            try {
                this.hisModel.queryHisDeal();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
        });
    }
}

