/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.Product;
import cms.tmx.entity.trade.MonthReport;
import cms.tmx.entity.trade.MonthReportDate;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.ProductMngServiceImpl;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.IMonthReportHisService;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class AddedTaxHisQueryPart
extends MxPart {
    private static String FORMAT = "yyyy-MM-dd";
    @FXML
    private Tab ccsTab;
    @FXML
    private TabPane tabPane;
    @FXML
    private ComboBox<MonthReportDate> cmbMonth;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<MxNode> btnDimension;
    @FXML
    private ComboBox<Product> ccmbProduct;
    @FXML
    private CheckComboBox<Portfolio> ccmbPort;
    @FXML
    private Label lbProduct;
    @FXML
    private Label lbPort;
    @FXML
    private GridPane gridDimen;
    @FXML
    private GridPane gridAcct;
    @FXML
    private GridPane gridPort;
    @FXML
    private Button btnSearch;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private MxAlert alert;
    @FXML
    private TableView<MonthReport> tableMonthReport;
    @FXML
    private TableColumn<MonthReport, String> colIndex;
    @FXML
    private TableColumn<MonthReport, String> colSecId;
    @FXML
    private TableColumn<MonthReport, String> colSecName;
    @FXML
    private TableColumn<MonthReport, String> colMonth;
    @FXML
    private TableColumn<MonthReport, Number> colDividendVolume;
    @FXML
    private TableColumn<MonthReport, Number> colBuyVolume;
    @FXML
    private TableColumn<MonthReport, Number> colBuyAmt;
    @FXML
    private TableColumn<MonthReport, Number> colSellVolume;
    @FXML
    private TableColumn<MonthReport, Number> colSellAmt;
    @FXML
    private TableColumn<MonthReport, Number> colPreTotalVolume;
    @FXML
    private TableColumn<MonthReport, Number> colPreHoldCostAmt;
    @FXML
    private TableColumn<MonthReport, Number> colClosingCostAmt;
    @FXML
    private TableColumn<MonthReport, Number> colInvestIncome;
    @FXML
    private TableColumn<MonthReport, Number> colAddedTax;
    @FXML
    private TableColumn<MonthReport, Number> colLastTotalVolume;
    @FXML
    private TableColumn<MonthReport, Number> colLastHoldCostAmt;
    @Inject
    private IMonthReportHisService monthReportService;
    private static final Logger logger = LogManager.getLogger(AddedTaxHisQueryPart.class);
    private boolean changeExtAcc = false;
    private Map<String, String> reactMap = new HashMap<String, String>();
    @Inject
    private ProductMngServiceImpl productMng;
    @Inject
    private IBaseApi iba;
    private ObservableList<MonthReportDate> monthList = FxUtils.newList();
    private String marketGrp;
    private List<String> productIdList;
    private ChangeListener<Product> productChange = (ob, old, newV) -> {
        Product product = newV;
        ObservableList listProduct = FxUtils.newList();
        if (!product.getId().isEmpty()) {
            listProduct.add(product.getId());
        }
        String proStr = listProduct.toString();
        this.lbProduct.setText(proStr.substring(1, proStr.length() - 1));
        this.lbProduct.setTooltip(new Tooltip(this.lbProduct.getText()));
        this.cmbMonth.setItems(null);
        if (!product.getId().isEmpty()) {
            try {
                this.monthList = this.monthReportService.queryHisMonthReportDate("CCS", (List<String>)listProduct, 1);
                this.cmbMonth.setItems(this.monthList);
                if (this.monthList.size() > 0) {
                    this.cmbMonth.setValue((Object)((MonthReportDate)this.monthList.get(this.monthList.size() - 1)));
                }
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u6708\u62a5\u7ed3\u8f6c\u65e5", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
    };
    private ChangeListener<MonthReportDate> monthChange = (ob, old, newV) -> this.setNewDate((MonthReportDate)newV);
    private StringConverter<Product> converter = new StringConverter<Product>(){

        public String toString(Product product) {
            return String.valueOf(product.getId()) + "-" + product.getName();
        }

        public Product fromString(String string) {
            return null;
        }
    };
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;

    @FXML
    private void initialize() {
        this.marketGrp = "CCS";
        this.initValue();
        this.createTable();
        this.focusRefresh(this.tableMonthReport);
    }

    @PreDestroy
    private void close() {
        this.ccmbProduct.valueProperty().removeListener(this.productChange);
        this.cmbMonth.valueProperty().removeListener(this.monthChange);
        this.monthReportService.getTaxList().clear();
    }

    private void initValue() {
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        this.beginDateText.setEditable(false);
        this.beginDateText.getEditor().setDisable(false);
        this.beginDateText.setDisable(true);
        this.endDateText.setEditable(false);
        this.endDateText.getEditor().setDisable(true);
        LocalDate ldEnd = LocalDate.now().minusDays(1L);
        this.endDateText.setValue((Object)ldEnd);
        LocalDate ldBegin = ldEnd.minusDays(ldEnd.getDayOfMonth() - 1);
        this.beginDateText.setValue((Object)ldBegin);
        Callback<DatePicker, DateCell> dayCellFactoryEnd = new Callback<DatePicker, DateCell>(){

            public DateCell call(DatePicker datePicker) {
                return new DateCell(){

                    public void updateItem(LocalDate item, boolean empty) {
                        super.updateItem(item, empty);
                        if (AddedTaxHisQueryPart.this.beginDateText.getValue() == null) {
                            return;
                        }
                        LocalDate start = (LocalDate)AddedTaxHisQueryPart.this.beginDateText.getValue();
                        LocalDate today = LocalDate.now().minusDays(1L);
                        if (item.isAfter(today) || item.isBefore(start)) {
                            this.setDisable(true);
                        }
                    }
                };
            }
        };
        this.endDateText.setDayCellFactory((Callback)dayCellFactoryEnd);
        MxNode node = MxNodeFactory.create((String)"query_dimension_clearrecord", (String)"3");
        this.btnDimension.setItems(node.getNodes());
        this.gridDimen.getChildren().clear();
        this.btnDimension.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if ("3".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAcct});
            } else {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPort});
            }
        });
        this.btnDimension.setValue((Object)node);
        this.btnDimension.setDisable(true);
        this.initCheckBoxProduct();
    }

    private void initCheckBoxProduct() {
        try {
            List productList = this.productMng.getProducts(this.iba.getPartyId());
            this.cmbMonth.valueProperty().addListener(this.monthChange);
            this.ccmbProduct.getItems().addAll((Collection)productList);
            this.ccmbProduct.valueProperty().addListener(this.productChange);
            this.ccmbProduct.setValue((Object)((Product)productList.get(0)));
            this.ccmbProduct.setConverter(this.converter);
        }
        catch (MException e) {
            Platform.runLater(() -> {
                logger.error("\u6839\u636e\u673a\u6784ID\u67e5\u8be2\u8d26\u6237", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.subAccMng.getPortfolios();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        this.ccmbPort.getItems().add((Object)portfolio);
        this.ccmbPort.getItems().addAll(listPort);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPort);
        checkComboBoxModel.init();
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Portfolio account : checkedItems) {
                if (account.getId().isEmpty()) continue;
                listAcc.add(account.getName());
            }
            String accStr = listAcc.toString();
            this.lbPort.setText(accStr.substring(1, accStr.length() - 1));
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    @FXML
    private void query() throws MException {
        this.changeExtAcc = true;
        this.queryAll();
    }

    private void queryAll() {
        this.ccsQuery();
    }

    private boolean rebuildPagi(String dimension) {
        if (this.changeExtAcc) {
            this.changeExtAcc = false;
            if ("3".equals(dimension)) {
                this.productIdList = FxUtils.newList();
                Product product = (Product)this.ccmbProduct.getValue();
                if (!product.getId().isEmpty()) {
                    this.productIdList.add(product.getId());
                }
                if (this.productIdList.isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }

    private void focusRefresh(TableView<? extends Object> table) {
        table.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> table.refresh());
            }
        });
    }

    private void setNewDate(MonthReportDate monthReportDate) {
        if (monthReportDate == null) {
            return;
        }
        String year = monthReportDate.getEndDate().substring(0, 4);
        String month = monthReportDate.getEndDate().substring(4, 6);
        String day = monthReportDate.getEndDate().substring(6);
        String date = String.valueOf(year) + "-" + month + "-" + day;
        LocalDate lastEnd = LocalDate.parse(date);
        LocalDate beginDate = lastEnd.plusDays(1L);
        LocalDate endDate = (LocalDate)this.endDateText.getValue();
        if (beginDate.isAfter(LocalDate.now().minusDays(1L))) {
            beginDate = LocalDate.now().minusDays(1L);
        }
        if (endDate.isAfter(LocalDate.now().minusDays(1L))) {
            endDate = LocalDate.now().minusDays(1L);
        }
        if (endDate.isBefore(beginDate)) {
            endDate = LocalDate.now().minusDays(1L);
        }
        this.beginDateText.setValue((Object)beginDate);
        this.endDateText.setValue((Object)endDate);
    }

    private void ccsQuery() {
        String dimension = ((MxNode)this.btnDimension.getValue()).getRaw();
        if (!this.rebuildPagi(dimension)) {
            return;
        }
        String beginDate = ((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", "");
        String endDate = ((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", "");
        LocalDate.parse(((LocalDate)this.endDateText.getValue()).toString());
        this.exe.execute(() -> {
            try {
                this.monthReportService.query(dimension, beginDate, endDate, this.marketGrp, this.productIdList, 1);
                Product product = (Product)this.ccmbProduct.getValue();
                if (!product.getId().isEmpty()) {
                    List<String> listProduct = Arrays.asList(product.getId());
                    this.monthList = this.monthReportService.queryHisMonthReportDate("CCS", listProduct, 1);
                    Platform.runLater(() -> {
                        this.cmbMonth.setItems(this.monthList);
                        this.tableMonthReport.scrollTo(0);
                    });
                }
            }
            catch (MException | Exception e) {
                logger.error("\u67e5\u8be2\u6708\u62a5\uff0c\u66f4\u65b0\u7ed3\u8f6c\u65e5", e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    private void createTable() {
        this.colSecId.setCellValueFactory(data -> ((MonthReport)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((MonthReport)data.getValue()).getInstrument().symbolProperty());
        this.reactMap.put(this.colSecId.getId(), "SecId");
        this.reactMap.put(this.colSecName.getId(), "SecName");
        this.colMonth.setCellValueFactory(data -> ((MonthReport)data.getValue()).monthProperty());
        this.colDividendVolume.setCellValueFactory(data -> ((MonthReport)data.getValue()).dividendVolumeProperty());
        this.colDividendVolume.setCellFactory(p -> new NumberTableCell());
        this.colBuyVolume.setCellValueFactory(data -> ((MonthReport)data.getValue()).buyVolumeProperty());
        this.colBuyVolume.setCellFactory(p -> new NumberTableCell());
        this.colBuyAmt.setCellValueFactory(data -> ((MonthReport)data.getValue()).buyAmtProperty());
        this.colBuyAmt.setCellFactory(p -> new DoubleTableCell());
        this.colSellVolume.setCellValueFactory(data -> ((MonthReport)data.getValue()).sellVolumeProperty());
        this.colSellVolume.setCellFactory(p -> new NumberTableCell());
        this.colSellAmt.setCellValueFactory(data -> ((MonthReport)data.getValue()).sellAmtProperty());
        this.colSellAmt.setCellFactory(p -> new DoubleTableCell());
        this.colPreTotalVolume.setCellValueFactory(data -> ((MonthReport)data.getValue()).preTotalVolumeProperty());
        this.colPreTotalVolume.setCellFactory(p -> new NumberTableCell());
        this.colPreHoldCostAmt.setCellValueFactory(data -> ((MonthReport)data.getValue()).preHoldCostAmtProperty());
        this.colPreHoldCostAmt.setCellFactory(p -> new DoubleTableCell());
        this.colClosingCostAmt.setCellValueFactory(data -> ((MonthReport)data.getValue()).closingCostAmtProperty());
        this.colClosingCostAmt.setCellFactory(p -> new DoubleTableCell());
        this.colInvestIncome.setCellValueFactory(data -> ((MonthReport)data.getValue()).investIncomeProperty());
        this.colInvestIncome.setCellFactory(p -> new DoubleTableCell());
        this.colAddedTax.setCellValueFactory(data -> ((MonthReport)data.getValue()).addedTaxProperty());
        this.colAddedTax.setCellFactory(p -> new DoubleTableCell());
        this.colLastTotalVolume.setCellValueFactory(data -> ((MonthReport)data.getValue()).lastTotalVolumeProperty());
        this.colLastTotalVolume.setCellFactory(p -> new NumberTableCell());
        this.colLastHoldCostAmt.setCellValueFactory(data -> ((MonthReport)data.getValue()).lastHoldCostAmtProperty());
        this.colLastHoldCostAmt.setCellFactory(p -> new DoubleTableCell());
        this.reactMap.put(this.colMonth.getId(), "Month");
        this.reactMap.put(this.colDividendVolume.getId(), "DividendVolume");
        this.reactMap.put(this.colBuyVolume.getId(), "BuyVolume");
        this.reactMap.put(this.colBuyAmt.getId(), "BuyAmt");
        this.reactMap.put(this.colSellVolume.getId(), "SellVolume");
        this.reactMap.put(this.colSellAmt.getId(), "SellAmt");
        this.reactMap.put(this.colPreTotalVolume.getId(), "PreTotalVolume");
        this.reactMap.put(this.colPreHoldCostAmt.getId(), "PreHoldCostAmt");
        this.reactMap.put(this.colClosingCostAmt.getId(), "ClosingCostAmt");
        this.reactMap.put(this.colInvestIncome.getId(), "InvestIncome");
        this.reactMap.put(this.colAddedTax.getId(), "AddedTax");
        this.reactMap.put(this.colLastTotalVolume.getId(), "LastTotalVolume");
        this.reactMap.put(this.colLastHoldCostAmt.getId(), "LastHoldCostAmt");
        TableUtils.isAuto(this.colIndex);
        this.colIndex.setSortable(false);
        this.tableMonthReport.setItems(this.monthReportService.getTaxList());
        this.tableMonthReport.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableMonthReport);
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithTwoHeadList(this.tableMonthReport, this.monthReportService.getTaxList(), this.reactMap);
    }

    @FXML
    private void refresh() {
        this.ccsQuery();
    }

    @FXML
    private void exportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u589e\u503c\u7a0e\u62a5\u8868");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    ExcelUtils.writeHisTwoHeadExcel(this.tableMonthReport, this.monthReportService.getTaxList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private class PriceCell
    extends DoubleTableCell<MonthReport> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

