/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.entity.Party;
import cms.tmx.entity.trade.ExtTransRecord;
import cms.tmx.entity.trade.SecTransRecord;
import cms.tmx.entity.trade.TransRecord;
import cms.tmx.manage.IPartyService;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.query.history.models.PageModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.Alert;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class TransferQueryModel {
    private static final Logger logger = LogManager.getLogger(TransferQueryModel.class);
    @Inject
    private IPartyService ips;
    @Inject
    private IPortfolioApi portApi;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;
    private Menu root;
    private Map<String, List<MenuItem>> map = new HashMap<String, List<MenuItem>>();
    private PageModel<TransRecord> pageCash;
    private PageModel<TransRecord> pagePosi;
    public BooleanProperty changedCash = new SimpleBooleanProperty();
    public BooleanProperty changedPosi = new SimpleBooleanProperty();
    private BooleanProperty done = new SimpleBooleanProperty(false);
    @Inject
    private AccountMngServiceImpl accountServiceImpl;
    @Inject
    private PortfolioMngServiceImpl portfolioServiceImpl;
    public String accntName;

    @PostConstruct
    public void init() {
        this.exe.execute(() -> {
            this.queryParty();
            this.initRoot();
            this.setDone(true);
        });
    }

    private void queryParty() {
        try {
            Party parent = this.ips.getUserParty();
            this.root = (Menu)this.createMenu(parent, true);
            List listParty = this.ips.getPartyList(parent.getId(), PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING);
            HashMap checkMap = new HashMap();
            listParty.forEach(p -> {
                Party party = checkMap.put(p.getParentId(), p);
            });
            for (Party party : listParty) {
                List<MenuItem> list = this.map.get(party.getParentId());
                if (list == null) {
                    list = new LinkedList<MenuItem>();
                    this.map.put(party.getParentId(), list);
                }
                boolean isMenu = checkMap.get(party.getId()) != null;
                list.add(this.createMenu(party, isMenu));
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
    }

    private void initRoot() {
        List<MenuItem> list2;
        for (List<MenuItem> list2 : this.map.values()) {
            for (MenuItem parent : list2) {
                List<MenuItem> items = this.map.get(parent.getId());
                if (items == null) continue;
                ((Menu)parent).getItems().addAll(items);
            }
        }
        list2 = this.map.get(this.root.getId());
        if (this.root != null && list2 != null) {
            this.root.getItems().addAll(list2);
        }
    }

    public void query(boolean isCash, String start, String end, String partyId) throws MException {
        List<MenuItem> listMenu = this.map.get(partyId);
        LinkedList<String> listParty = new LinkedList<String>();
        listParty.add(partyId);
        this.addIds(listParty, listMenu);
        if (isCash) {
            this.queryCash(start, end, listParty);
        } else {
            this.queryPos(start, end, listParty);
        }
    }

    private void addIds(List<String> listId, List<MenuItem> items) {
        if (items == null) {
            return;
        }
        for (MenuItem item : items) {
            if (item instanceof Menu) {
                Menu menu = (Menu)Menu.class.cast(item);
                this.addIds(listId, (List<MenuItem>)menu.getItems());
            }
            listId.add(item.getId());
        }
    }

    public void queryCash(String start, String end, List<String> listParty) throws MException {
        List listRecord = this.portApi.getCashTransfer(start, end, listParty);
        LinkedList<TransRecord> list = new LinkedList<TransRecord>();
        for (PCashService.CashTransRecord cash : listRecord) {
            TransRecord record = (TransRecord)this.of.create(TransRecord.class);
            if (!cash.getSrcPortfolioId().isEmpty()) {
                record.setMasterPortName(this.portfolioServiceImpl.getPortfolioFromCache(cash.getSrcPortfolioId()).getName());
            } else {
                this.accntName = this.accountServiceImpl.getAccountNameFromCache(cash.getExtAccntId().replaceAll("[_A-Z]$*", ""));
                record.setMasterPortName(this.accntName);
            }
            if (!cash.getDstPortfolioId().isEmpty()) {
                record.setSlavePortName(this.portfolioServiceImpl.getPortfolioFromCache(cash.getDstPortfolioId()).getName());
            } else {
                this.accntName = this.accountServiceImpl.getAccountNameFromCache(cash.getExtAccntId().replaceAll("[_A-Z]$*", ""));
                record.setSlavePortName(this.accntName);
            }
            record.update((Object)cash);
            list.add(record);
        }
        this.pageCash.getList().setAll(list);
        this.changedCash();
    }

    public void queryPos(String start, String end, List<String> listParty) throws MException {
        List listRecord = this.portApi.getPosTransfer(start, end, listParty);
        LinkedList<TransRecord> list = new LinkedList<TransRecord>();
        for (PCashService.PosTransRecord cash : listRecord) {
            TransRecord record = (TransRecord)this.of.create(TransRecord.class);
            if (!cash.getSrcPortfolioId().isEmpty()) {
                record.setMasterPortName(this.portfolioServiceImpl.getPortfolioFromCache(cash.getSrcPortfolioId()).getName());
            } else {
                this.accntName = this.accountServiceImpl.getAccountNameFromCache(cash.getExtAccntId().replaceAll("[_A-Z]$*", ""));
                record.setMasterPortName(this.accntName);
            }
            if (!cash.getDstPortfolioId().isEmpty()) {
                record.setSlavePortName(this.portfolioServiceImpl.getPortfolioFromCache(cash.getDstPortfolioId()).getName());
            } else {
                this.accntName = this.accountServiceImpl.getAccountNameFromCache(cash.getExtAccntId().replaceAll("[_A-Z]$*", ""));
                record.setSlavePortName(this.accntName);
            }
            record.update((Object)cash);
            list.add(record);
        }
        this.pagePosi.getList().setAll(list);
        this.changedPosi();
    }

    public List<ExtTransRecord> getExtTransfer(String start, String end, List<String> listPort) throws MException {
        List listRecord = this.portApi.getExtTransfer(start, end, listPort);
        LinkedList<ExtTransRecord> list = new LinkedList<ExtTransRecord>();
        for (PCashService.CashTransRecord cash : listRecord) {
            ExtTransRecord record = (ExtTransRecord)this.of.create(ExtTransRecord.class);
            record.update((Object)cash);
            list.add(record);
        }
        return list;
    }

    public List<SecTransRecord> getSecTransfer(String start, String end, List<String> listPort) throws MException {
        List listRecord = this.portApi.getSecTransfer(start, end, listPort);
        LinkedList<SecTransRecord> list = new LinkedList<SecTransRecord>();
        for (PCashService.PosTransRecord posi : listRecord) {
            SecTransRecord record = (SecTransRecord)this.of.create(SecTransRecord.class);
            record.update((Object)posi);
            list.add(record);
        }
        return list;
    }

    private MenuItem createMenu(Party party, boolean isMenu) {
        Menu menu = isMenu ? new Menu() : new MenuItem();
        menu.setText(party.getName());
        menu.setId(party.getId());
        return menu;
    }

    public Menu getRoot() {
        return this.root;
    }

    public List<MenuItem> getMenus() {
        LinkedList<MenuItem> list = new LinkedList<MenuItem>();
        if (this.root != null) {
            list.add((MenuItem)this.root);
        }
        this.map.values().forEach(menus -> {
            boolean bl = list.addAll((Collection<MenuItem>)menus);
        });
        return list;
    }

    public PageModel<TransRecord> initPageCash() {
        this.pageCash = new PageModel();
        return this.pageCash;
    }

    public PageModel<TransRecord> initPagePosi() {
        this.pagePosi = new PageModel();
        return this.pagePosi;
    }

    public BooleanProperty changedCashProperty() {
        return this.changedCash;
    }

    public void changedCash() {
        this.changedCash.set(!this.changedCash.get());
    }

    public BooleanProperty changedPosiProperty() {
        return this.changedPosi;
    }

    public void changedPosi() {
        this.changedPosi.set(!this.changedPosi.get());
    }

    public final BooleanProperty doneProperty() {
        return this.done;
    }

    public final boolean isDone() {
        return this.doneProperty().get();
    }

    public final void setDone(boolean done) {
        this.doneProperty().set(done);
    }
}

