/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.trade.ISecuritySummaryHisQueryApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.SecuritySummaryFactory;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.SecuritySummary;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.ISecuritySummaryHisService;
import cmx.tmx.data.IRefDataMng;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SecuritySummaryHisServiceImpl
implements ISecuritySummaryHisService {
    @Inject
    private ISecuritySummaryHisQueryApi<SecuritySummary> securityHisQueryApi;
    @Inject
    private SecuritySummaryFactory factory;
    @Inject
    private PortfolioAccountModel portfModel;
    @Inject
    private IRefDataMng refMng;

    @Override
    public void query(HisQueryPage<SecuritySummary> queryPage) throws MException {
        LinkedList<SecuritySummary> list = new LinkedList<SecuritySummary>();
        String dimension = queryPage.getDimension();
        if (dimension.equals("3")) {
            List listInfo = this.securityHisQueryApi.queryHisSummary(queryPage, Integer.valueOf(0));
            for (PCashService.ExtAccntSecuritySummary info : listInfo) {
                SecuritySummary security = this.factory.create();
                security.update((Object)info);
                list.add(security);
            }
        } else if (dimension.equals("2")) {
            List listInfo = this.securityHisQueryApi.querySubHisSummary(queryPage, Integer.valueOf(0));
            for (PCashService.SubAccntSecuritySummary info : listInfo) {
                SecuritySummary security = this.factory.create();
                security.update((Object)info);
                security.setPortfolio(this.portfModel.getPortfolioNameById(security.getPortfolio()));
                list.add(security);
            }
        }
        this.getSecName(list);
        queryPage.updateData(list);
    }

    @Override
    public HisQueryPage<SecuritySummary> getAllCcsData(HisQueryPage<SecuritySummary> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setProductIdList(pageCcs.getProductIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setPortfolioIdList(pageCcs.getPortfolioIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        this.query((HisQueryPage<SecuritySummary>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<SecuritySummary>)page);
        }
        return page;
    }

    private void getSecName(List<SecuritySummary> securityList) {
        for (SecuritySummary t : securityList) {
            RefItem item = this.refMng.getItem(t.getInstrument().getSecType(), t.getInstrument().getMarket().getRaw(), t.getSecId());
            if ("SHSC".equals(t.getInstrument().getMarket().getRaw()) || "SZSC".equals(t.getInstrument().getMarket().getRaw())) {
                item = this.refMng.getItem(String.valueOf(t.getInstrument().getSecType()) + t.getInstrument().getMarket().getRaw(), t.getInstrument().getMarket().getRaw(), t.getSecId());
            }
            if (item != null) {
                t.getInstrument().setSymbol(item.getName());
            } else {
                t.getInstrument().setSymbol(t.getSecId());
            }
            t.setSecName(t.getInstrument().getSymbol());
        }
    }
}

