/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.entity.SecClassifyDetails;
import cms.tmx.query.history.ISecClassifyService;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SecClassifyServiceImpl
implements ISecClassifyService {
    @Inject
    private static HttpClientService httpClient;
    @Inject
    private IBaseApi bmi;
    private Gson gson = new Gson();

    @Override
    public List<SecClassifyDetails> query(String partyId, String secClassifyId, String pageNum, String pageSize) throws MException {
        LinkedList<SecClassifyDetails> detailList = new LinkedList<SecClassifyDetails>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pageNum", pageNum);
        param.put("pageSize", pageSize);
        param.put("partyId", partyId);
        param.put("secClassifyId", secClassifyId);
        param.put("cms_s_token", this.bmi.getToken());
        String url = "/risk/secClassifyDetails";
        try {
            String respUrl = httpClient.doGet(url, param, true);
            JsonArray dataList = null;
            JsonObject jsonObject = new JsonParser().parse(respUrl).getAsJsonObject();
            JsonObject jsonData = jsonObject.getAsJsonObject("res");
            dataList = jsonData.getAsJsonArray("list");
            for (JsonElement item : dataList) {
                SecClassifyDetails detail = (SecClassifyDetails)this.gson.fromJson(item.toString(), SecClassifyDetails.class);
                detailList.add(detail);
            }
            if (!"200".equals(jsonObject.getAsJsonPrimitive("code").getAsString())) {
                throw new MException(-1, "\u67e5\u8be2\u8bc1\u5238\u7c7b\u522b\u6570\u636e\u5f02\u5e38");
            }
        }
        catch (MException e) {
            e.printStackTrace();
        }
        return detailList;
    }
}

