/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.PortfolioDetail;
import cms.tmx.entity.trade.PortfolioDetailNew;
import cms.tmx.http.api.strategy.dto.GetNewAccountNetReq;
import cms.tmx.query.history.IPortfolioDetailService;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PortfolioDetailServiceImpl
implements IPortfolioDetailService {
    @Inject
    private static HttpClientService httpClient;
    @Inject
    private IBaseApi bmi;
    private Gson gson = new Gson();
    @Inject
    private MConfService ms;

    @Override
    public List<PortfolioDetail> query(String partyId, String currentDate, String endDate, String pageNum, String pageSize) throws MException {
        LinkedList<PortfolioDetail> detailList = new LinkedList<PortfolioDetail>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pageNum", pageNum);
        param.put("pageSize", pageSize);
        if (!"".equals(currentDate)) {
            param.put("dateFrom", currentDate);
            param.put("dateTo", endDate);
        }
        param.put("partyId", partyId);
        param.put("cms_s_token", this.bmi.getToken());
        String url = "/portfolio/getDetailContainZero";
        try {
            String respUrl = httpClient.doGet(url, param, true);
            JsonArray dataList = null;
            JsonObject jsonObject = new JsonParser().parse(respUrl).getAsJsonObject();
            JsonObject jsonData = jsonObject.getAsJsonObject("res");
            dataList = jsonData.getAsJsonArray("list");
            for (JsonElement item : dataList) {
                PortfolioDetail detail = (PortfolioDetail)this.gson.fromJson(item.toString(), PortfolioDetail.class);
                detailList.add(detail);
            }
            if (!"200".equals(jsonObject.getAsJsonPrimitive("code").getAsString())) {
                throw new MException(-1, "\u67e5\u8be2\u6295\u7ec4\u8d44\u4ea7\u6570\u636e\u5f02\u5e38");
            }
        }
        catch (MException e) {
            e.printStackTrace();
        }
        return detailList;
    }

    public void queryNetsInTurn(IPageInTurn<String, String, PortfolioDetail> page, String partyId, String beginDate, String endDate) throws MException {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        LinkedList<PortfolioDetail> detailList = new LinkedList<PortfolioDetail>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pageNum", String.valueOf(page.getStartRow() / page.getPageSize() + 1));
        param.put("pageSize", String.valueOf(page.getPageSize()));
        if (!"".equals(beginDate)) {
            param.put("dateFrom", beginDate);
            param.put("dateTo", endDate);
        }
        param.put("partyId", partyId);
        param.put("cms_s_token", this.bmi.getToken());
        String url = "/portfolio/getDetailContainZero";
        String respUrl = httpClient.doGet(url, param, true);
        JsonArray dataList = null;
        JsonObject jsonObject = new JsonParser().parse(respUrl).getAsJsonObject();
        JsonObject jsonData = jsonObject.getAsJsonObject("res");
        dataList = jsonData.getAsJsonArray("list");
        JsonElement total = jsonData.get("totalRow");
        int sum = (Integer)this.gson.fromJson(total, Integer.class);
        for (JsonElement item : dataList) {
            PortfolioDetail detail = (PortfolioDetail)this.gson.fromJson(item.toString(), PortfolioDetail.class);
            detailList.add(detail);
        }
        if (!"200".equals(jsonObject.getAsJsonPrimitive("code").getAsString())) {
            throw new MException(-1, "\u67e5\u8be2\u6295\u7ec4\u8d44\u4ea7\u6570\u636e\u5f02\u5e38");
        }
        page.getResList().addAll(detailList);
        page.setTotalRow(sum);
        int size = detailList.size();
        if (size == 0 || page.getResList().size() == sum || page.getResList().size() + page.getStartRow() - 1 == sum) {
            return;
        }
        if (size < page.getPageSize()) {
            page.setStartRow(page.getStartRow() + size);
            page.setPageSize(page.getPageSize() - size);
            this.queryNetsInTurn(page, partyId, beginDate, endDate);
        }
    }

    public void queryNewNetsInTurn(IPageInTurn<String, String, PortfolioDetailNew> page, String beginDate, String endDate, Set<String> portfolioIds) throws MException {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        LinkedList<PortfolioDetailNew> detailList = new LinkedList<PortfolioDetailNew>();
        GetNewAccountNetReq request = new GetNewAccountNetReq();
        request.setBeginDate(beginDate);
        request.setEndDate(endDate);
        request.setType("1");
        request.setPostId(this.bmi.getPostId());
        request.setPortfolioId(new ArrayList<String>(portfolioIds));
        String body = this.gson.toJson((Object)request);
        String url = "/reportapi/assets/query";
        StringBuffer stringBuffer = new StringBuffer(this.ms.getValue("web.domain"));
        stringBuffer.append("api").append(url).append("?cms_s_token=" + this.bmi.getToken());
        String respUrl = httpClient.doPostJson2(stringBuffer.toString(), body);
        JsonArray dataList = null;
        if (respUrl == null) {
            throw new MException(-1, "\u67e5\u8be2\u6295\u7ec4\u8d44\u4ea7\u6570\u636e\u5f02\u5e38");
        }
        JsonObject jsonObject = new JsonParser().parse(respUrl).getAsJsonObject();
        JsonElement jsonData = jsonObject.get("res");
        if (jsonData != null && jsonData.isJsonObject()) {
            dataList = jsonData.getAsJsonObject().getAsJsonArray("list");
            for (JsonElement item : dataList) {
                PortfolioDetailNew detail = (PortfolioDetailNew)this.gson.fromJson(item.toString(), PortfolioDetailNew.class);
                detailList.add(detail);
            }
        }
        if (!"200".equals(jsonObject.getAsJsonPrimitive("code").getAsString())) {
            throw new MException(-1, "\u67e5\u8be2\u6295\u7ec4\u8d44\u4ea7\u6570\u636e\u5f02\u5e38");
        }
        page.getResList().addAll(detailList);
        int size = detailList.size();
        if (size == 0) {
            return;
        }
    }
}

