/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.FxUtils;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ObservableList;

public class PageModel<T>
extends MxChgObj {
    private IntegerProperty currentPage = new SimpleIntegerProperty(1);
    private IntegerProperty pageSize = new SimpleIntegerProperty(100);
    private IntegerProperty pageCount = new SimpleIntegerProperty(1);
    private IntegerProperty total = new SimpleIntegerProperty(0);
    private ObservableList<T> list = FxUtils.newList();
    private ObservableList<T> data = FxUtils.newList();
    protected InvalidationListener lstnList = ob -> Platform.runLater(() -> {
        this.total.set(this.list.size());
        this.compPageCount();
    });

    public PageModel() {
        this.list.addListener(this.lstnList);
        this.currentPage.addListener(ob -> this.compData());
        this.pageSize.addListener(ob -> this.compPageCount());
    }

    private void compPageCount() {
        int size = this.pageSize.get();
        int page = size == 0 ? 0 : this.list.size() / size;
        int remainder = this.list.size() % this.pageSize.get();
        page = remainder == 0 ? page : ++page;
        this.pageCount.set(page);
        if (this.currentPage.get() == 0) {
            this.compData();
        }
        this.currentPage.set(0);
    }

    private void compData() {
        int maxPage;
        int page = this.currentPage.get();
        if (page >= (maxPage = this.pageCount.get())) {
            page = --maxPage;
        } else if (page < 0) {
            page = 0;
        }
        int begin = this.pageSize.get() * page++;
        int end = this.pageSize.get() * page;
        int sum = this.total.get();
        begin = begin < 0 ? 0 : begin;
        end = end > sum ? sum : end;
        List listShow = this.list.subList(begin, end);
        this.data.setAll((Collection)listShow);
        this.changed();
    }

    public final IntegerProperty currentPageProperty() {
        return this.currentPage;
    }

    public final int getCurrentPage() {
        return this.currentPageProperty().get();
    }

    public final void setCurrentPage(int currentPage) {
        this.currentPageProperty().set(currentPage);
    }

    public final IntegerProperty pageSizeProperty() {
        return this.pageSize;
    }

    public final int getPageSize() {
        return this.pageSizeProperty().get();
    }

    public final void setPageSize(int pageSize) {
        this.pageSizeProperty().set(pageSize);
    }

    public final IntegerProperty pageCountProperty() {
        return this.pageCount;
    }

    public final int getPageCount() {
        return this.pageCountProperty().get();
    }

    public final void setPageCount(int pageCount) {
        this.pageCountProperty().set(pageCount);
    }

    public final IntegerProperty totalProperty() {
        return this.total;
    }

    public final int getTotal() {
        return this.totalProperty().get();
    }

    public ObservableList<T> getList() {
        return this.list;
    }

    public void setList(ObservableList<T> list) {
        this.list = list;
    }

    public ObservableList<T> getData() {
        return this.data;
    }
}

