/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.TransRecord;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.OtcTransferQueryApi;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.trans.record.GetOtcTransRecordsReq;
import cms.tmx.http.trans.record.GetOtcTransRecordsResp;
import cms.tmx.http.trans.record.OtcTransRecords;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.query.history.models.PageModel;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class OtcTransferQueryModel
extends MxModel {
    @Inject
    private OtcTransferQueryApi api;
    @Inject
    private MObjFactory of;
    @Inject
    private HttpBaseApi baseApi;
    private PageModel<TransRecord> pagePosi;
    public BooleanProperty changedPosi = new SimpleBooleanProperty();
    private BooleanProperty done = new SimpleBooleanProperty(false);
    protected List<OtcTransRecords> list = new LinkedList<OtcTransRecords>();
    @Inject
    private AccountMngServiceImpl accountServiceImpl;
    @Inject
    private PortfolioMngServiceImpl portfolioServiceImpl;
    public String accntName;

    public void query(boolean isCash, String start, String end, List<String> portfolioId) throws MException {
        this.queryPos(start, end, portfolioId);
    }

    public void queryPos(String start, String end, List<String> portfolioId) throws MException {
        Page httpDefPage = this.baseApi.getHttpDefPage();
        GetOtcTransRecordsReq req = new GetOtcTransRecordsReq();
        req.setPortfolioId(portfolioId);
        req.setBeginDate(start);
        req.setEndDate(end);
        req.setPage(httpDefPage);
        req.setMarketGroup("CCS");
        req.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
        req.setAccntType(AccntType.ACCNT_TYPE_SEC);
        GetOtcTransRecordsResp resp = this.api.getTransRecords(req);
        this.list.clear();
        this.list.addAll(resp.getData());
        int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / (double)httpDefPage.getPageSize());
        while (--queryTimes > 0) {
            httpDefPage.setStartRow(httpDefPage.getPageSize() + resp.getOffset());
            req.setPage(httpDefPage);
            GetOtcTransRecordsResp res = this.api.getTransRecords(req);
            this.list.addAll(res.getData());
        }
        LinkedList<TransRecord> data = new LinkedList<TransRecord>();
        for (OtcTransRecords cash : this.list) {
            TransRecord record = (TransRecord)this.of.create(TransRecord.class);
            if (!cash.getSrcPortfolioId().isEmpty()) {
                record.setMasterPortName(this.portfolioServiceImpl.getPortfolioFromCache(cash.getSrcPortfolioId()).getName());
            } else {
                this.accntName = this.accountServiceImpl.getAccountNameFromCache(cash.getInvestorId());
                record.setMasterPortName(this.accntName);
            }
            if (!cash.getDstPortfolioId().isEmpty()) {
                record.setSlavePortName(this.portfolioServiceImpl.getPortfolioFromCache(cash.getDstPortfolioId()).getName());
            } else {
                this.accntName = this.accountServiceImpl.getAccountNameFromCache(cash.getInvestorId());
                record.setSlavePortName(this.accntName);
            }
            record.update((Object)cash);
            data.add(record);
        }
        this.pagePosi.getList().setAll(data);
        this.changedPosi();
    }

    public PageModel<TransRecord> initPagePosi() {
        this.pagePosi = new PageModel();
        return this.pagePosi;
    }

    public BooleanProperty changedPosiProperty() {
        return this.changedPosi;
    }

    public void changedPosi() {
        this.changedPosi.set(!this.changedPosi.get());
    }

    public final BooleanProperty doneProperty() {
        return this.done;
    }

    public final boolean isDone() {
        return this.doneProperty().get();
    }

    public final void setDone(boolean done) {
        this.doneProperty().set(done);
    }
}

