/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.trade.IMonthReportHisQueryApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.MonthReportDateFactory;
import cms.tmx.entity.factory.MonthReportFactory;
import cms.tmx.entity.trade.MonthReport;
import cms.tmx.entity.trade.MonthReportDate;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.IMonthReportHisService;
import cmx.tmx.data.IRefDataMng;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MonthReportHisServiceImpl
extends MxModel
implements IMonthReportHisService {
    @Inject
    protected IMonthReportHisQueryApi<MonthReport> reportHisQueryApi;
    @Inject
    private MonthReportFactory factory;
    @Inject
    private MonthReportDateFactory dateFactory;
    @Inject
    private PortfolioAccountModel portfModel;
    @Inject
    private IRefDataMng refMng;
    private StringBuffer month;
    protected MxList<MonthReport> list = new MxList();
    protected MxList<MonthReport> taxList = new MxList();

    @Override
    public ObservableList<MonthReport> getList() {
        return this.list.getList();
    }

    @Override
    public ObservableList<MonthReport> getTaxList() {
        return this.taxList.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void query(String dimension, String beginDate, String endDate, String marketGrp, List<String> productIdList, int reportType) throws MException {
        ObservableList observableList;
        LinkedList<MonthReport> list = new LinkedList<MonthReport>();
        MonthReport sum = this.factory.create();
        if (dimension.equals("3")) {
            List listInfo = this.reportHisQueryApi.queryHisMonthReport(beginDate, endDate, marketGrp, productIdList, reportType);
            for (PCashService.ExtMonthReport info : listInfo) {
                MonthReport report = this.factory.create();
                report.update((Object)info);
                this.month = new StringBuffer();
                this.month.append(beginDate).append(" - ").append(endDate);
                report.setMonth(this.month.toString());
                list.add(report);
                sum.setPreHoldCostAmt(sum.getPreHoldCostAmt() + report.getPreHoldCostAmt());
                sum.setAddedTax(sum.getAddedTax() + report.getAddedTax());
            }
        }
        this.getSecName(list);
        if (reportType == 1 && !list.isEmpty()) {
            list.add(sum);
        }
        if (reportType == 1) {
            observableList = this.taxList.getList();
            synchronized (observableList) {
                this.taxList.clear();
                list.addAll((Collection<MonthReport>)this.taxList.getList());
            }
            this.taxList.update(list);
        } else {
            observableList = this.list.getList();
            synchronized (observableList) {
                this.list.clear();
                list.addAll((Collection<MonthReport>)this.list.getList());
            }
            this.list.update(list);
        }
        this.changed();
    }

    private void getSecName(List<MonthReport> monthList) {
        for (MonthReport t : monthList) {
            RefItem item = this.refMng.getItem(t.getInstrument().getSecType(), t.getInstrument().getMarket().getRaw(), t.getSecId());
            if (item != null) {
                t.getInstrument().setSymbol(item.getName());
            } else {
                t.getInstrument().setSymbol(t.getSecId());
            }
            t.setSecName(t.getInstrument().getSymbol());
        }
    }

    @Override
    public ObservableList<MonthReportDate> queryHisMonthReportDate(String marketGrp, List<String> productIdList, int reportType) throws MException {
        List list = this.reportHisQueryApi.queryHisMonthReportDate(marketGrp, productIdList, reportType);
        ObservableList dateList = FxUtils.newList();
        for (PCashService.ExtMonthReportDate item : list) {
            MonthReportDate date = this.dateFactory.create();
            date.update((Object)item);
            dateList.add((Object)date);
        }
        return dateList;
    }
}

