/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.IDictMap;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.datahub.Type;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.GetInstructionsReq;
import cms.tmx.http.instruction.dto.GetInstructionsResp;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.manage.IProductService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.query.history.IInstructionHisNewService;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import cmx.tmx.data.INewRefMng;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionHisNewServiceImpl
implements IInstructionHisNewService {
    @Inject
    protected MObjFactory of;
    @Inject
    private InstructionServiceApi ins;
    @Inject
    private HttpBaseApi baseApi;
    private String dimension;
    @Inject
    private UserMngServiceImpl userService;
    @Inject
    private WorkflowTemplateApi workflowApi;
    @Inject
    private IProductService productService;
    @Inject
    protected INewRefMng refMng;
    @Inject
    private IDictMap dictMap;
    @Inject
    private FundAccountMngServiceImpl fundService;

    @Override
    public void query(HisQueryPage<ObInstruction> queryPage) throws MException {
        GetInstructionsReq req = new GetInstructionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setType(Type.HISTORY);
        req.setBeginDate(queryPage.getBeginDate());
        req.setEndDate(queryPage.getEndDate());
        if (!StringUtils.isEmpty((String)queryPage.getSecurityId())) {
            req.setSecurityId(queryPage.getSecurityId());
        }
        if (!StringUtils.isEmpty((String)queryPage.getReferenceId())) {
            req.setKeyword(queryPage.getReferenceId());
        }
        this.dimension = queryPage.getDimension();
        if (this.dimension.equals("1")) {
            req.setExtCashAccntId(queryPage.getAccountIdList());
        } else if (this.dimension.equals("2")) {
            req.setPortfolioId(queryPage.getPortfolioIdList());
        }
        GetInstructionsResp res = null;
        ArrayList<ObInstruction> instructionList = new ArrayList<ObInstruction>();
        ArrayList instructions = new ArrayList();
        queryPage.initParam();
        Page pageReq = this.baseApi.getHttpDefPage();
        do {
            queryPage.updatePage(pageReq);
            req.setPage(pageReq);
        } while (queryPage.hasNext((res = this.ins.queryInstructionByPage(req, instructions)).getPage().getTotalRow()));
        for (Instruction instruction : instructions) {
            ObInstruction obIns = new ObInstruction();
            instruction.setCreatorName((String)this.userService.getCreditUserName(instruction.getCreator()).get());
            obIns.update((Object)instruction);
            if ("SimpleDetail".equals(obIns.getType())) {
                this.transferField(obIns);
            }
            instructionList.add(obIns);
        }
        queryPage.updateData(instructionList);
    }

    private void transferField(ObInstruction ins) throws MException {
        List workflowTasks = ins.getWorkflowTasks();
        for (WorkflowTask workflowTask : workflowTasks) {
            if (workflowTask.getPermissibleList().contains("4")) {
                ins.setIsOrderStep(true);
                continue;
            }
            if (!workflowTask.getPermissibleList().contains("2") && !workflowTask.getPermissibleList().contains("6")) continue;
            ins.setIsApproveStep(true);
        }
        if ("SimpleDetail".equals(ins.getType())) {
            RefItem refItem = this.refMng.getItem(ins.getSecType(), ins.getSecMarket(), ins.getSecurityCode());
            if (refItem != null) {
                if (refItem.isNeeqQuery()) {
                    this.refMng.queryStockInfo(refItem);
                }
                ins.setLevelInfo(refItem.getLevelInfo());
                ins.setTransferMethod(refItem.getTransferMethod());
            }
            String marketGrp = MarketUtils.getMarketGroup((String)ins.getSecMarket());
            AccountId accountId = ((AccntSecInfo)ins.getOrderDetail().getAccntSecInfo().get(0)).getAccountId();
            FundAccount fundAcc = this.fundService.getFundAccountByCashAccntId(accountId.getCashAccntId(), marketGrp);
            if (fundAcc == null) {
                fundAcc = this.fundService.getFundAccountNew(accountId.getCashAccntId(), marketGrp);
            }
            String investorId = "";
            if (fundAcc != null) {
                investorId = fundAcc.getInvestId();
            }
            if (!StringUtils.isEmpty((String)ins.getMarketIndicate())) {
                ins.setSideName(ins.getMarketIndicate());
            }
            if (ins.getProductId() != null && !ins.getProductId().isEmpty()) {
                ins.setBelongTo(String.valueOf(this.productService.getProductDetailFromCache(ins.getProductId()).getName()) + "(" + investorId + ")");
            }
            if (ins.getOrderDetail().getPlateLevels() != 0) {
                ins.getOrderDetail().setPlateLevels(ins.getOrderDetail().getPlateLevels() - 11);
                ins.setInsPriceStr("\u76d8\u53e3-" + this.dictMap.get("instr_handicap", ins.getOrderDetail().getPlateLevels()));
                ins.getOrderDetail().setOrdType(OrdType.ORD_TYPE_UNDEFINED);
            } else if ("49".equals(ins.getOrderDetail().getOrdType().getValue())) {
                if (ins.getOrderDetail().getTif() != null) {
                    String neeqMarketPriceType = MarketUtils.getNeeqMarketPriceType((int)ins.getOrderDetail().getTif().getValue(), (int)ins.getOrderDetail().getMaxPriceLevels());
                    ins.setInsPriceStr("\u5e02\u4ef7-" + this.dictMap.get("cstr_price_type_mkt", neeqMarketPriceType));
                }
            } else if ("50".equals(ins.getOrderDetail().getOrdType().getValue())) {
                if (ins.getOrderDetail().getPrice() > 0.0 && !"3".equals(Integer.toString(ins.getOrderDetail().getPriceRestriction()))) {
                    ins.setInsPriceStr(String.valueOf(this.dictMap.get("cstr_price_type_limited", ins.getOrderDetail().getPriceRestriction())) + "-" + new BigDecimal(String.valueOf(ins.getOrderDetail().getPrice())).toPlainString());
                } else {
                    ins.setInsPriceStr(this.dictMap.get("cstr_price_type_limited", ins.getOrderDetail().getPriceRestriction()));
                }
            } else if ("99".equals(ins.getOrderDetail().getOrdType().getValue())) {
                ins.setInsPriceStr("\u76d8\u540e\u56fa\u5b9a\u4ef7-" + ins.getOrderDetail().getPrice());
            }
        }
    }

    @Override
    public List<ObInstruction> exportIns(HisQueryPage<ObInstruction> pageCcs) throws MException, IOException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setAccountIdList(pageCcs.getAccountIdList());
        page.setPortfolioIdList(pageCcs.getPortfolioIdList());
        page.setDimension(pageCcs.getDimension());
        page.setSecurityId(pageCcs.getSecurityId());
        this.query((HisQueryPage<ObInstruction>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<ObInstruction>)page);
        }
        return page.getDataList();
    }
}

