/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.data.IRefApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.entity.data.SecRefItem;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class IndustryNameMap {
    @Inject
    private IRefApi refApi;
    private Map<String, String> industryName = new HashMap<String, String>();
    private static final Logger logger = LogManager.getLogger(IndustryNameMap.class);
    private int pageSize = 500;

    public PComponent.Instrument getInstrument(String secType, String secId, String market) {
        if (!this.industryName.containsKey(this.getKey(secId, market)) || StringUtils.isEmpty((String)this.industryName.get(this.getKey(secId, market)))) {
            PComponent.Instrument.Builder builderInst = PComponent.Instrument.newBuilder();
            builderInst.setSecurityType(secType);
            builderInst.setSecurityId(secId);
            builderInst.setMarket(market);
            return builderInst.build();
        }
        return null;
    }

    private String getKey(String secId, String market) {
        StringBuilder key = new StringBuilder(String.join((CharSequence)",", secId, market));
        return key.toString();
    }

    public void queryRefData(List<PComponent.Instrument> instrumentList) {
        if (instrumentList.size() == 0) {
            return;
        }
        try {
            ArrayList refList = new ArrayList();
            int m = instrumentList.size() / this.pageSize;
            int n = instrumentList.size() % this.pageSize;
            int i = 0;
            while (i < m + 1) {
                List<Object> list = new LinkedList();
                list = i == m ? instrumentList.subList(m * this.pageSize, m * this.pageSize + n) : instrumentList.subList(i * this.pageSize, (i + 1) * this.pageSize);
                refList.addAll(this.refApi.loadRefData(12, "CCS", "", "", list));
                ++i;
            }
            for (PRefData.SecListItem item : refList) {
                Any any = item.getObject();
                if (!any.is(PCcsRefdata.SecStaticData.class)) continue;
                SecRefItem refItem = new SecRefItem();
                refItem.update((Object)item);
                this.industryName.put(this.getKey(refItem.getCode(), refItem.getMarket()), refItem.getIndustryClass());
            }
        }
        catch (MException | Exception e) {
            logger.error("\u67e5\u8be2\u7533\u4e07\u4e00\u7ea7\u884c\u4e1a\u5931\u8d25" + e.getMessage(), e);
        }
    }

    public Map<String, String> getIndustryNameMap() {
        return this.industryName;
    }
}

