/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.FutureCrossOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.history.models.OrderHisModel;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FutureCrossOrderHisServiceImpl
extends OrderHisModel<FutureCrossOrder> {
    @Inject
    private CtpAccountMap accountMap;

    @Override
    public void query(HisQueryPage<FutureCrossOrder> orderPage) throws MException {
        orderPage.getDataList().clear();
        ArrayList list = new ArrayList();
        List orderList = this.orderHisQuery.queryEtfHisOrders(orderPage, Integer.valueOf(0));
        orderList.forEach(item -> {
            String marketGrp = orderPage.getMarketGrp();
            if (marketGrp.equals("FUTURES")) {
                FutureCrossOrder order = new FutureCrossOrder();
                order.update(item);
                order.setInvestorId(this.accountMap.getCtpInvestId(order.getAccntId()));
                list.add(order);
            }
        });
        orderPage.updateData(list);
    }

    public HisQueryPage<FutureCrossOrder> getAllCrossOrderData(HisQueryPage<FutureCrossOrder> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setExtAccntIdList(pageCcs.getExtAccntIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        page.setSum(pageCcs.isSum());
        this.query((HisQueryPage<FutureCrossOrder>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<FutureCrossOrder>)page);
        }
        return page;
    }
}

