/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.ObSummarizedOrder;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.SummarizedService;
import cms.tmx.http.api.strategy.dto.AssetGroupType;
import cms.tmx.http.api.strategy.dto.GetOrderSummariesReq;
import cms.tmx.http.api.strategy.dto.GetOrderSummariesResp;
import cms.tmx.http.api.strategy.dto.SummarizedOrder;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.query.history.IDealSumNewHisService;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class DealSumNewHisServiceImpl
implements IDealSumNewHisService {
    @Inject
    protected MObjFactory of;
    @Inject
    protected QueryModel model;
    private List<SummarizedOrder> list = new ArrayList<SummarizedOrder>();
    @Inject
    private SummarizedService api;
    @Inject
    private HttpBaseApi baseApi;

    @Override
    public void queryDealSum(HisQueryPage<ObSummarizedOrder> queryPage) throws MException, IOException {
        GetOrderSummariesReq req = new GetOrderSummariesReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup(queryPage.getMarketGrp());
        Instrument instrument = new Instrument();
        instrument.setSecurityId(queryPage.getSecurityId());
        req.setInstrument(instrument);
        String dimension = queryPage.getDimension();
        if (dimension.equals("1")) {
            req.setExtCashAccntId(queryPage.getAccountIdList());
        } else if (dimension.equals("2")) {
            req.setPortfolioId(queryPage.getPortfolioIdList());
            req.setExtCashAccntId(queryPage.getAccountIdList());
        } else if (dimension.equals("7")) {
            req.setAssetGroupType(Integer.valueOf(AssetGroupType.kPortfolio.getValue()));
            req.setExtCashAccntId(queryPage.getAccountIdList());
            req.setPortfolioId(queryPage.getPortfolioIdList());
            req.setAssetGroupId(queryPage.getAssetsGrpIdList());
        }
        req.setBeginDate(queryPage.getBeginDate());
        req.setEndDate(queryPage.getEndDate());
        if (queryPage.isInverval()) {
            req.setDimension(GetOrderSummariesReq.Dimension.kDimensionOrderDate.getValue());
        }
        queryPage.initParam();
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        GetOrderSummariesResp res = null;
        LinkedList<ObSummarizedOrder> listSrc = new LinkedList<ObSummarizedOrder>();
        this.list.clear();
        do {
            queryPage.updatePage(fragment);
            req.setFragment(fragment);
            res = this.api.getNewDeals(req);
            this.list.addAll(res.getData());
        } while (queryPage.hasNext(res.getTotal()));
        for (SummarizedOrder exe : this.list) {
            exe.setExtraFields();
            ObSummarizedOrder ob = new ObSummarizedOrder();
            ob.update((Object)exe);
            if (!queryPage.isInverval()) {
                ob.setSumDate(String.valueOf(queryPage.getBeginDate()) + "-" + queryPage.getEndDate());
            }
            ob.setIncurredAmt(this.getIncurredAmt(ob));
            ob.setUnit(QueryUtils.getUnit(ob.getSecType(), ob.getMarket().getRaw()));
            listSrc.add(ob);
        }
        queryPage.updateData(listSrc);
    }

    private double getIncurredAmt(ObSummarizedOrder o) {
        double amt = 0.0;
        int side = StringUtils.parseInt((String)o.getSide().getRaw());
        switch (side) {
            case 49: 
            case 71: 
            case 80: 
            case 83: 
            case 201: {
                amt = o.getSettlCurrAmt() + o.getRealFee();
                break;
            }
            default: {
                amt = o.getSettlCurrAmt() - o.getRealFee();
            }
        }
        return amt;
    }

    @Override
    public HisQueryPage<ObSummarizedOrder> getAllCcsSumData(HisQueryPage<ObSummarizedOrder> pageCcs) throws MException, IOException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setAccountIdList(pageCcs.getAccountIdList());
        page.setPortfolioIdList(pageCcs.getPortfolioIdList());
        page.setAssetsGrpIdList(pageCcs.getAssetsGrpIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSecurityId(pageCcs.getSecurityId());
        page.setInverval(pageCcs.isInverval());
        this.queryDealSum((HisQueryPage<ObSummarizedOrder>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.queryDealSum((HisQueryPage<ObSummarizedOrder>)page);
        }
        return page;
    }

    public List<SummarizedOrder> getList() {
        return this.list;
    }
}

