/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.ExtPositionsHisResp;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.trade.CtpPosition;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.Position;
import cms.tmx.query.history.ICtpPositionHisService;
import cms.tmx.query.history.models.PositionHisModel;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CtpPositionHisServiceImpl
extends PositionHisModel<CtpPosition>
implements ICtpPositionHisService {
    @Inject
    protected PositionFactory factory;

    @Override
    public synchronized void query(HisQueryPage<CtpPosition> queryPage) throws MException {
        LinkedList<CtpPosition> list = new LinkedList<CtpPosition>();
        queryPage.getDataList().clear();
        ExtPositionsHisResp hisResp = this.positionHisQueryApi.queryHisPositions(queryPage);
        List listInfo = hisResp.getList();
        for (PPositionService.ExtPosition info : listInfo) {
            Position positioon = this.factory.create(info);
            if (!(positioon instanceof CtpPosition)) continue;
            this.model.afterUpdate(positioon);
            list.add((CtpPosition)CtpPosition.class.cast(positioon));
        }
        queryPage.updateData(list);
    }

    @Override
    public HisQueryPage<CtpPosition> getAllCtpData(HisQueryPage<CtpPosition> pageCtp) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCtp.getBeginDate());
        page.setEndDate(pageCtp.getEndDate());
        page.setExtAccntIdList(pageCtp.getExtAccntIdList());
        page.setMarketGrp(pageCtp.getMarketGrp());
        page.setDimension(pageCtp.getDimension());
        page.setSubAccntIdList(pageCtp.getSubAccntIdList());
        page.setSecurityId(pageCtp.getSecurityId());
        this.query((HisQueryPage<CtpPosition>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<CtpPosition>)page);
        }
        return page;
    }
}

