/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.Order;
import cms.tmx.query.history.ICtpOrderHisService;
import cms.tmx.query.history.models.OrderHisModel;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CtpOrderHisServiceImpl
extends OrderHisModel<CtpOrder>
implements ICtpOrderHisService {
    @Inject
    private OrderFactory fOrder;

    @Override
    public void query(HisQueryPage<CtpOrder> orderPage) throws MException {
        LinkedList<CtpOrder> list = new LinkedList<CtpOrder>();
        List orderList = this.orderHisQuery.queryHisOrders(orderPage, Integer.valueOf(0));
        for (POrderService.SingleOrder item : orderList) {
            Order order = this.fOrder.create(item);
            order.update((Object)item);
            if (!(order instanceof CtpOrder)) continue;
            CtpOrder ctpOrder = (CtpOrder)CtpOrder.class.cast(order);
            order.setWthUserName(this.getWthUserName(item));
            order.setErrInfo(order.transferErrInfo());
            this.model.afterUpdate(ctpOrder);
            list.add(ctpOrder);
        }
        orderPage.updateData(list);
    }

    @Override
    public HisQueryPage<CtpOrder> getAllCcsData(HisQueryPage<CtpOrder> pageCtp) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCtp.getBeginDate());
        page.setEndDate(pageCtp.getEndDate());
        page.setExtAccntIdList(pageCtp.getExtAccntIdList());
        page.setMarketGrp(pageCtp.getMarketGrp());
        page.setDimension(pageCtp.getDimension());
        page.setSubAccntIdList(pageCtp.getSubAccntIdList());
        page.setSecurityId(pageCtp.getSecurityId());
        long a = System.currentTimeMillis();
        this.query((HisQueryPage<CtpOrder>)page);
        long b = System.currentTimeMillis();
        this.logger.info(String.valueOf(b - a) + "\u7b2c\u4e00\u9875\u82b1\u4e86");
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<CtpOrder>)page);
            this.logger.info(String.valueOf(System.currentTimeMillis() - b) + "\u4e00\u9875\u540e\u82b1\u4e86");
        }
        return page;
    }
}

