/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.trade.IDealHisQueryApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PAssetService;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.CtpDealSum;
import cms.tmx.entity.trade.Deal;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.query.history.ICtpDealHisService;
import cms.tmx.query.utils.QueryModel;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CtpDealHisServiceImpl
implements ICtpDealHisService {
    @Inject
    private DealFactory fDeal;
    @Inject
    protected IDealHisQueryApi<CtpDeal> dealHisQueryApi;
    @Inject
    protected IDealHisQueryApi<CtpDealSum> dealSumHisQueryApi;
    @Inject
    protected QueryModel model;

    @Override
    public void query(HisQueryPage<CtpDeal> queryPage) throws MException {
        queryPage.getDataList().clear();
        LinkedList list = new LinkedList();
        List orderList = this.dealHisQueryApi.queryHisDeals(queryPage, Integer.valueOf(0));
        orderList.forEach(item -> {
            Deal deal = this.fDeal.create(item);
            deal.update(item);
            if (deal instanceof CtpDeal) {
                CtpDeal ctpDeal = (CtpDeal)CtpDeal.class.cast(deal);
                this.model.afterUpdate(ctpDeal);
                list.add(ctpDeal);
            }
        });
        queryPage.updateData(list);
    }

    @Override
    public void queryDealSum(HisQueryPage<CtpDealSum> queryPage) throws MException {
        LinkedList<CtpDealSum> list = new LinkedList<CtpDealSum>();
        List listInfo = this.dealSumHisQueryApi.queryHisDealsSum(queryPage, Integer.valueOf(0));
        for (PAssetService.ExecutionsCollect info : listInfo) {
            Deal deal = this.fDeal.create(info);
            deal.update((Object)info);
            if (!(deal instanceof CtpDealSum)) continue;
            CtpDealSum ctpDeal = (CtpDealSum)CtpDealSum.class.cast(deal);
            this.model.afterUpdate((CtpDeal)ctpDeal);
            list.add(ctpDeal);
        }
        queryPage.updateData(list);
    }

    @Override
    public HisQueryPage<CtpDeal> getAllCtpData(HisQueryPage<CtpDeal> pageCtp) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCtp.getBeginDate());
        page.setEndDate(pageCtp.getEndDate());
        page.setExtAccntIdList(pageCtp.getExtAccntIdList());
        page.setMarketGrp(pageCtp.getMarketGrp());
        page.setDimension(pageCtp.getDimension());
        page.setSubAccntIdList(pageCtp.getSubAccntIdList());
        page.setSecurityId(pageCtp.getSecurityId());
        this.query((HisQueryPage<CtpDeal>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<CtpDeal>)page);
        }
        return page;
    }

    @Override
    public HisQueryPage<CtpDealSum> getAllCtpSumData(HisQueryPage<CtpDealSum> pageCtp) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCtp.getBeginDate());
        page.setEndDate(pageCtp.getEndDate());
        page.setExtAccntIdList(pageCtp.getExtAccntIdList());
        page.setMarketGrp(pageCtp.getMarketGrp());
        page.setDimension(pageCtp.getDimension());
        page.setSubAccntIdList(pageCtp.getSubAccntIdList());
        page.setSecurityId(pageCtp.getSecurityId());
        this.queryDealSum((HisQueryPage<CtpDealSum>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.queryDealSum((HisQueryPage<CtpDealSum>)page);
        }
        return page;
    }
}

