/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IClearRecordHisQueryApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.entity.Account;
import cms.tmx.entity.factory.ClearRecordFactory;
import cms.tmx.entity.trade.ClearRecord;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.manage.IAccountService;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.IClearRecordHisService;
import cms.tmx.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ClearRecordHisServiceImpl
implements IClearRecordHisService {
    @Inject
    protected IClearRecordHisQueryApi<ClearRecord> clearHisQueryApi;
    @Inject
    private ClearRecordFactory factory;
    @Inject
    private PortfolioAccountModel portfModel;
    @Inject
    private IAccountService accntService;
    @Inject
    private IBaseApi iba;
    private Map<String, String> mapAcc = new HashMap<String, String>();
    private volatile boolean bInit = false;

    @Override
    public void query(HisQueryPage<ClearRecord> queryPage) throws MException {
        List listInfo;
        if (!this.bInit) {
            ArrayList listAcc = new ArrayList();
            listAcc.addAll(this.accntService.getAccountListByParty(this.iba.getPartyId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            listAcc.addAll(this.accntService.getAccountListByParty(this.iba.getPartyId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
            for (Account acc : listAcc) {
                this.mapAcc.put(acc.getInvestorId(), acc.getName());
            }
            this.bInit = true;
        }
        LinkedList<ClearRecord> list = new LinkedList<ClearRecord>();
        String dimension = queryPage.getDimension();
        if (dimension.equals("3")) {
            listInfo = this.clearHisQueryApi.queryHisRecords(queryPage, Integer.valueOf(0));
            for (PCashService.ClearRecord info : listInfo) {
                ClearRecord trade = this.factory.create();
                trade.update((Object)info);
                trade.setAccName(this.mapAcc.get(trade.getInvestorId()));
                list.add(trade);
            }
        } else if (dimension.equals("2")) {
            listInfo = this.clearHisQueryApi.querySubHisRecords(queryPage, Integer.valueOf(0));
            for (PCashService.SubClearRecord info : listInfo) {
                ClearRecord trade = this.factory.create();
                trade.update((Object)info);
                trade.setAccName(this.mapAcc.get(trade.getInvestorId()));
                if (StringUtils.isEmpty((String)trade.getPortfolioName())) {
                    if (this.isPortfolioId(trade.getPortfolioId())) {
                        trade.setPortfolioName(this.portfModel.getPortfolioNameById(trade.getPortfolioId()));
                    } else {
                        trade.setPortfolioName(String.valueOf(trade.getInvestorId()) + "\u96f6\u8d26\u53f7");
                    }
                }
                list.add(trade);
            }
        }
        queryPage.updateData(list);
    }

    private boolean isPortfolioId(String portfolioId) {
        return portfolioId != null && portfolioId.startsWith("P");
    }

    @Override
    public HisQueryPage<ClearRecord> getAllCcsData(HisQueryPage<ClearRecord> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setProductIdList(pageCcs.getProductIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setPortfolioIdList(pageCcs.getPortfolioIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        this.query((HisQueryPage<ClearRecord>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<ClearRecord>)page);
        }
        return page;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateClearRecord(List<ClearRecord> recordList) throws MException {
        block1: {
            clearRecordList = new ArrayList<E>();
            recordList.forEach((Consumer<ClearRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(java.util.List cms.tmx.entity.trade.ClearRecord ), (Lcms/tmx/entity/trade/ClearRecord;)V)(clearRecordList));
            if (clearRecordList.size() > 200) ** GOTO lbl10
            this.clearHisQueryApi.updateClearRecord(clearRecordList);
            break block1;
lbl-1000:
            // 1 sources

            {
                subList = clearRecordList.subList(0, 200);
                this.clearHisQueryApi.updateClearRecord(subList);
                clearRecordList.removeAll(subList);
lbl10:
                // 2 sources

                ** while (clearRecordList.size() > 200)
            }
lbl11:
            // 1 sources

            this.clearHisQueryApi.updateClearRecord(clearRecordList);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateSubClearRecord(List<ClearRecord> recordList) throws MException {
        block1: {
            subClearRecordList = new ArrayList<E>();
            recordList.forEach((Consumer<ClearRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$1(java.util.List cms.tmx.entity.trade.ClearRecord ), (Lcms/tmx/entity/trade/ClearRecord;)V)(subClearRecordList));
            if (subClearRecordList.size() > 200) ** GOTO lbl10
            this.clearHisQueryApi.updateSubClearRecord(subClearRecordList);
            break block1;
lbl-1000:
            // 1 sources

            {
                subList = subClearRecordList.subList(0, 200);
                this.clearHisQueryApi.updateSubClearRecord(subList);
                subClearRecordList.removeAll(subList);
lbl10:
                // 2 sources

                ** while (subClearRecordList.size() > 200)
            }
lbl11:
            // 1 sources

            this.clearHisQueryApi.updateSubClearRecord(subClearRecordList);
        }
    }

    private static /* synthetic */ void lambda$0(List list, ClearRecord item) {
        PCashService.ClearRecord.Builder builder = PCashService.ClearRecord.newBuilder();
        builder.setTransId(item.getRecordId());
        builder.setTransDate(item.getRecordDate());
        if (item.getRecordTime() != null) {
            builder.setTransTime(item.getRecordTime());
        }
        builder.setSourceFlag(item.getSourceFlag());
        builder.setPreSecQty(item.getBeginSecQty());
        builder.setSecDeltaAmt(item.getQty());
        builder.setPreBalance(item.getBeginAmt());
        builder.setSecDeltaAmt(item.getSecOccurQty());
        builder.setDeltaAmt(item.getOccurAmt());
        builder.setBalance(item.getBalance());
        builder.setPrice(item.getPrice());
        builder.setCumQty(item.getQty());
        builder.setTradeAmt(item.getAmount());
        if (item.getExecId() != null) {
            builder.setExecId(item.getExecId());
        }
        builder.setRealFee(item.getRealFee());
        builder.setCommission(item.getCommision());
        builder.setChgOwnerFee(item.getChgFee());
        builder.setStampTax(item.getStampTax());
        builder.setHandleFee(item.getHandleFee());
        builder.setSecAdminFee(item.getSecAdminFee());
        builder.setOtherFee(item.getOtherFee());
        if (item.getUserName() != null) {
            builder.setOperateUser(item.getUserName());
        }
        if (item.getOperateTime() != null) {
            builder.setOperateTime(item.getOperateTime());
        }
        builder.setSecQty(item.getSecBalance());
        builder.setOrderVolume(item.getOrderVol());
        builder.setOrderPrice(item.getOrderPrice());
        if (item.getTradeTime() != null) {
            builder.setTradeTime(item.getTradeTime());
        }
        if (item.getProductName() != null) {
            builder.setProductName(item.getProductName());
        }
        if (item.getProductId() != null) {
            builder.setProductId(item.getProductId());
        }
        if (item.getBusinessCode() != null) {
            builder.setBusinessCode(item.getBusinessCode());
        }
        if (item.getSide() != null) {
            builder.setSide(item.getSide());
        }
        if (item.getRecordId() != null) {
            builder.setTransId(item.getRecordId());
        }
        builder.setInvestorId(item.getInvestorId());
        builder.setExtAccntId(item.getInverstorSecId());
        builder.setInvestorSecId(item.getInverstorSecId());
        PCashService.Instrument.Builder iBuilder = PCashService.Instrument.newBuilder();
        if (item.getInstrument().getSymbol() != null) {
            iBuilder.setSymbol(item.getInstrument().getSymbol());
        }
        if (item.getInstrument().getMarket().getRaw() != null) {
            iBuilder.setMarket(item.getInstrument().getMarket().getRaw());
        }
        iBuilder.setApplId(item.getInstrument().getApplId());
        iBuilder.setSecurityType(item.getInstrument().getSecType());
        iBuilder.setSecurityId(item.getInstrument().getSecId());
        builder.setInstrument(iBuilder.build());
        list.add(builder.build());
    }

    private static /* synthetic */ void lambda$1(List list, ClearRecord item) {
        PCashService.SubClearRecord.Builder builder = PCashService.SubClearRecord.newBuilder();
        builder.setTransId(item.getRecordId());
        builder.setTransDate(item.getRecordDate());
        if (item.getRecordTime() != null) {
            builder.setTransTime(item.getRecordTime());
        }
        builder.setSourceFlag(item.getSourceFlag());
        builder.setSecQty(item.getSecBalance());
        builder.setPreSecQty(item.getBeginSecQty());
        builder.setSecDeltaAmt(item.getQty());
        builder.setPreBalance(item.getBeginAmt());
        builder.setSecDeltaAmt(item.getSecOccurQty());
        builder.setDeltaAmt(item.getOccurAmt());
        builder.setBalance(item.getBalance());
        builder.setPrice(item.getPrice());
        builder.setCumQty(item.getQty());
        builder.setTradeAmt(item.getAmount());
        if (item.getExecId() != null) {
            builder.setExecId(item.getExecId());
        }
        builder.setRealFee(item.getRealFee());
        builder.setCommission(item.getCommision());
        builder.setChgOwnerFee(item.getChgFee());
        builder.setStampTax(item.getStampTax());
        builder.setHandleFee(item.getHandleFee());
        builder.setSecAdminFee(item.getSecAdminFee());
        builder.setOtherFee(item.getOtherFee());
        if (item.getUserName() != null) {
            builder.setOperateUser(item.getUserName());
        }
        builder.setOrderVolume(item.getOrderVol());
        builder.setOrderPrice(item.getOrderPrice());
        if (item.getTradeTime() != null) {
            builder.setTradeTime(item.getTradeTime());
        }
        if (item.getPortfolioId() != null) {
            builder.setPortfolioId(item.getPortfolioId());
        }
        if (item.getPortfolioName() != null) {
            builder.setPortfolioName(item.getPortfolioName());
        }
        if (item.getBusinessCode() != null) {
            builder.setBusinessCode(item.getBusinessCode());
        }
        builder.setInvestorId(item.getInvestorId());
        builder.setExtAccntId(item.getInverstorSecId());
        builder.setInvestorSecId(item.getInverstorSecId());
        PCashService.Instrument.Builder iBuilder = PCashService.Instrument.newBuilder();
        if (item.getInstrument().getSymbol() != null) {
            iBuilder.setSymbol(item.getInstrument().getSymbol());
        }
        if (item.getInstrument().getMarket().getRaw() != null) {
            iBuilder.setMarket(item.getInstrument().getMarket().getRaw());
        }
        iBuilder.setApplId(item.getInstrument().getApplId());
        iBuilder.setSecurityType(item.getInstrument().getSecType());
        iBuilder.setSecurityId(item.getInstrument().getSecId());
        builder.setInstrument(iBuilder.build());
        if (!item.getPortfolioName().isEmpty() && !item.getPortfolioId().isEmpty()) {
            list.add(builder.build());
        }
    }
}

