/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.ExtPositionsHisResp;
import cms.tmx.api.SubPositionsHisResp;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.trade.CcsRepoPortfPosition;
import cms.tmx.entity.trade.CcsRepoPosition;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.Position;
import cms.tmx.query.history.ICcsRepoPositionHisService;
import cms.tmx.query.history.models.PositionHisModel;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsRepoPositionHisServiceImpl
extends PositionHisModel<CcsRepoPosition>
implements ICcsRepoPositionHisService {
    @Inject
    protected PositionFactory factory;

    @Override
    public synchronized void query(HisQueryPage<CcsRepoPosition> queryPage) throws MException {
        LinkedList<Object> list = new LinkedList<Object>();
        queryPage.getDataList().clear();
        if (queryPage.getDimension().equals("1")) {
            ExtPositionsHisResp hisResp = this.positionHisQueryApi.queryHisPositions(queryPage);
            List listInfo = hisResp.getList();
            for (PPositionService.ExtPosition info : listInfo) {
                Position posi = this.factory.create(info, queryPage.getPositionType());
                this.model.afterUpdate(posi);
                if (!(posi instanceof CcsRepoPosition)) continue;
                list.add((CcsRepoPosition)CcsRepoPosition.class.cast(posi));
            }
        } else {
            SubPositionsHisResp hisResp = this.positionHisQueryApi.queryHisPosiPort(queryPage);
            List listInfo = hisResp.getList();
            for (PPositionService.SubPosition info : listInfo) {
                CcsRepoPortfPosition posi = this.factory.createRepo(info);
                this.model.afterUpdate((Position)posi);
                list.add(posi);
            }
        }
        queryPage.updateData(list);
    }

    @Override
    public HisQueryPage<CcsRepoPosition> getAllCcsRepoData(HisQueryPage<CcsRepoPosition> pageCtp) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCtp.getBeginDate());
        page.setEndDate(pageCtp.getEndDate());
        page.setExtAccntIdList(pageCtp.getExtAccntIdList());
        page.setMarketGrp(pageCtp.getMarketGrp());
        page.setDimension(pageCtp.getDimension());
        page.setSubAccntIdList(pageCtp.getSubAccntIdList());
        page.setSecurityId(pageCtp.getSecurityId());
        page.setPositionType("REPO");
        this.query((HisQueryPage<CcsRepoPosition>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<CcsRepoPosition>)page);
        }
        return page;
    }
}

