/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.data.impl.HkwolunDataMng;
import cms.tmx.data.utils.Gears;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.trade.ExtAccntDetail;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.PortfolioDetailNew;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.PositionNewServiceApi;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.AssetGroupType;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetPositionsReq;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.http.api.strategy.dto.PositionNew;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.query.Condition;
import cms.tmx.http.query.QueryFilter;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.ICcsPositionNewHisService;
import cms.tmx.query.history.models.AccountDetailServiceImpl;
import cms.tmx.query.history.models.IndustryNameMap;
import cms.tmx.query.history.models.PortfolioDetailServiceImpl;
import cms.tmx.query.utils.QueryByPage;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.INewRefMng;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsPositionNewHisServiceImpl
implements ICcsPositionNewHisService {
    @Inject
    protected PositionFactory factory;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private INewRefMng newRefMng;
    @Inject
    private IMarketDataMng marketMng;
    @Inject
    protected MarketDataModel newMarketMng;
    @Inject
    private HkwolunDataMng hkDataMng;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    protected QueryModel model;
    private Set<String> pledgeSet;
    private Date date = new Date();
    private SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    private String dateString = "";
    private List<ObPosition> list = new ArrayList<ObPosition>();
    @Inject
    private PositionNewServiceApi api;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    private HttpBaseApi httpApi;
    @Inject
    private IFundAccountService fundApi;
    @Inject
    private CcsAccountMap accountMap;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private FundAccountMngServiceImpl accntMngService;
    private static final int FULL_QUERY_INTERVAL = 200;
    private Map<String, Set<String>> assetIdMap = new HashMap<String, Set<String>>();
    private int todaySum;
    private int hisSum;
    private int hisStart;
    private int hisSize;
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private Map<String, ExtAccntDetail> accntMap = new HashMap<String, ExtAccntDetail>();
    private Map<String, PortfolioDetailNew> portMap = new HashMap<String, PortfolioDetailNew>();
    private Map<String, Double> hkRateMap = new HashMap<String, Double>();
    private Set<String> ids = new HashSet<String>();
    private String dimension;
    private String endDate;
    private static final Logger logger = LogManager.getLogger(CcsPositionNewHisServiceImpl.class);
    @Inject
    private MObjFactory of;
    @Inject
    private AccountDetailServiceImpl accountDetailService;
    @Inject
    private PortfolioDetailServiceImpl portfDetailService;
    @Inject
    private IndustryNameMap industryName;
    private int amB = 9;
    private int pmE = 16;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(200);
    }

    private void queryNet(Set<String> dateSet) {
        block15: {
            block16: {
                block14: {
                    try {
                        if ("1".equals(this.dimension)) {
                            this.accntMap.clear();
                            for (String da : dateSet) {
                                this.queryAccDetail(da, da);
                            }
                        } else if ("2".equals(this.dimension) || "7".equals(this.dimension)) {
                            this.portMap.clear();
                            for (String da : dateSet) {
                                this.queryPortfDetail(da, da);
                            }
                        }
                    }
                    catch (MException | Exception e) {
                        logger.error("\u67e5\u8be2\u51c0\u503c\u5931\u8d25" + e.getMessage(), e);
                    }
                    if (!"1".equals(this.dimension)) break block14;
                    for (ObPosition po : this.list) {
                        po.setType(this.industryName.getIndustryNameMap().get(this.getKey(po)));
                        this.calculateRate(po);
                        String key = String.valueOf(po.getInvestorId()) + "," + po.getTrdDate();
                        if (this.accntMap.get(key) == null || 0.0 == this.accntMap.get(key).getNetAsset()) continue;
                        double precent = (double)Math.round(po.getMarketValue() * 10000.0 / this.accntMap.get(key).getNetAsset()) / 100.0;
                        if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                            precent = (double)Math.round(po.getMarketValue() * 10000.0 * po.getHkRate() / this.accntMap.get(key).getNetAsset()) / 100.0;
                        }
                        po.setNet(precent);
                    }
                    break block15;
                }
                if (!"2".equals(this.dimension)) break block16;
                for (ObPosition po : this.list) {
                    po.setType(this.industryName.getIndustryNameMap().get(this.getKey(po)));
                    this.calculateRate(po);
                    String key = String.valueOf(po.getPortfolioId()) + "," + po.getTrdDate();
                    if (StringUtils.isEmpty((String)po.getPortfolioId()) || this.portMap.get(key) == null || 0.0 == this.portMap.get(key).getNetAsset()) continue;
                    double precent = (double)Math.round(po.getMarketValue() * 10000.0 / this.portMap.get(key).getNetAsset()) / 100.0;
                    if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                        precent = (double)Math.round(po.getMarketValue() * 10000.0 * po.getHkRate() / this.portMap.get(key).getNetAsset()) / 100.0;
                    }
                    po.setNet(precent);
                }
                break block15;
            }
            if (!"7".equals(this.dimension)) break block15;
            for (ObPosition po : this.list) {
                po.setType(this.industryName.getIndustryNameMap().get(this.getKey(po)));
                this.calculateRate(po);
                Set<String> portSet = this.assetIdMap.get(po.getAssetGroupId());
                double netAsset = 0.0;
                StringBuilder key = new StringBuilder();
                for (String portId : portSet) {
                    key = new StringBuilder(portId).append(",").append(po.getTrdDate());
                    PortfolioDetailNew detail = this.portMap.get(key.toString());
                    if (detail == null) continue;
                    netAsset += detail.getNetAsset().doubleValue();
                }
                if (StringUtils.isEmpty((String)po.getAssetGroupId()) || this.assetIdMap.get(po.getAssetGroupId()) == null || this.assetIdMap.get(po.getAssetGroupId()).size() <= 0 || 0.0 == netAsset) continue;
                double precent = (double)Math.round(po.getMarketValue() * 10000.0 / netAsset) / 100.0;
                if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                    precent = (double)Math.round(po.getMarketValue() * 10000.0 * po.getHkRate() / netAsset) / 100.0;
                }
                po.setNet(precent);
            }
        }
    }

    private void calculateRate(ObPosition po) {
        if (this.dateString.compareTo(po.getTrdDate()) > 0 && ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw()))) {
            po.setHkRate(1.0);
            if (!this.hkRateMap.isEmpty()) {
                po.setHkRate(this.hkRateMap.get(po.getMarket().getRaw() + po.getTrdDate()).doubleValue());
            }
            po.setMarketValue((double)Math.round(po.getMarketValue() / po.getHkRate() * 1000.0) / 1000.0);
        } else if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
            po.setHkRate(RefItem.getMediumRate());
        }
        if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
            po.setCost((double)Math.round(po.getCost() / po.getHkRate() * 10000.0) / 10000.0);
            po.setBuyCost((double)Math.round(po.getBuyCost() / po.getHkRate() * 10000.0) / 10000.0);
            po.setBuyCostAmt((double)Math.round(po.getBuyCostAmt() / po.getHkRate() * 1000.0) / 1000.0);
            po.setHoldCostAmt((double)Math.round(po.getHoldCostAmt() / po.getHkRate() * 1000.0) / 1000.0);
            po.setRealPnl((double)Math.round(po.getRealPnl() / po.getHkRate() * 1000.0) / 1000.0);
            po.setTodayRealizedPl((double)Math.round(po.getTodayRealizedPl() / po.getHkRate() * 1000.0) / 1000.0);
            po.setFloatPnl((double)Math.round((po.getMarketValue() - po.getBuyCostAmt()) * 1000.0) / 1000.0);
            po.setTotalProfit((double)Math.round((po.getFloatPnl() + po.getRealPnl()) * 1000.0) / 1000.0);
        }
    }

    private void queryHisRate(Set<String> dateSet) {
        for (String da : dateSet) {
            double mediumrate;
            if (this.dateString.compareTo(da) <= 0 || this.hkRateMap.containsKey("SHSC" + da)) continue;
            PCcsRefdata.HKStockRefRate rate = this.hkDataMng.loadRefRate(da, null);
            if (rate != null) {
                mediumrate = (double)Math.round((rate.getBidSettleRate() + rate.getAskSettleRate()) / 2.0 * 10000.0) / 10000.0;
                this.hkRateMap.put("SHSC" + da, mediumrate);
            }
            if ((rate = this.hkDataMng.loadRefRate(da, "SZSC")) == null) continue;
            mediumrate = (double)Math.round((rate.getBidSettleRate() + rate.getAskSettleRate()) / 2.0 * 10000.0) / 10000.0;
            this.hkRateMap.put("SZSC" + da, mediumrate);
        }
    }

    private List<PositionNew> queryData(HisQueryPage<ObPosition> queryPage, GetPositionsReq reqHis) throws IOException, MException {
        GetExtPositionsResp res = null;
        this.list.clear();
        LinkedList<PositionNew> respList = new LinkedList<PositionNew>();
        this.date = new Date();
        this.dateString = this.format.format(this.date);
        this.endDate = queryPage.getEndDate();
        if (!this.dimension.equals("7") && queryPage.getEndDate().equals(this.dateString)) {
            queryPage.initParam();
            Page pageReq = this.httpApi.getHttpDefPage();
            reqHis.setStartDate("");
            reqHis.setEndDate("");
            queryPage.updatePage(pageReq);
            reqHis.setPage(pageReq);
            res = this.api.getPositions(reqHis);
            this.todaySum = res.getTotal();
            LocalDate da = null;
            this.hisSum = 0;
            if (!queryPage.getBeginDate().equals(this.dateString)) {
                queryPage.initParam();
                pageReq = this.httpApi.getHttpDefPage();
                reqHis.setStartDate(queryPage.getBeginDate());
                StringBuilder s = new StringBuilder(queryPage.getEndDate());
                s.insert(6, "-").insert(4, "-");
                da = LocalDate.parse(s.toString());
                reqHis.setEndDate(da.minusDays(1L).format(this.formatter));
                queryPage.updatePage(pageReq);
                reqHis.setPage(pageReq);
                res = this.api.getHisPositions(reqHis);
                this.hisSum = res.getTotal();
            }
            queryPage.initParam();
            pageReq = this.httpApi.getHttpDefPage();
            boolean queryToday = true;
            if (this.todaySum < queryPage.getStart()) {
                this.hisStart = queryPage.getStart() - this.todaySum;
                this.hisSize = queryPage.getPageSize();
                queryToday = false;
            }
            if (this.todaySum == queryPage.getStart()) {
                this.hisStart = 1;
                this.hisSize = queryPage.getPageSize() - 1;
            }
            if (this.todaySum > queryPage.getStart() && this.todaySum < queryPage.getEnd() - 1) {
                this.hisStart = 1;
                this.hisSize = queryPage.getEnd() - 1 - this.todaySum;
            }
            if (this.todaySum >= queryPage.getEnd() - 1) {
                this.hisSize = 0;
            }
            if (queryToday) {
                do {
                    reqHis.setStartDate("");
                    reqHis.setEndDate("");
                    queryPage.updatePage(pageReq);
                    reqHis.setPage(pageReq);
                    res = this.api.getPositions(reqHis);
                    respList.addAll(res.getPosData());
                } while (queryPage.hasNext(res.getTotal()));
            }
            if (this.hisSize != 0 && !queryPage.getBeginDate().equals(this.dateString)) {
                HisQueryPage hisQueryPage = new HisQueryPage();
                hisQueryPage.setPageSize(Integer.valueOf(this.hisSize));
                hisQueryPage.setStart(this.hisStart);
                hisQueryPage.setEnd(this.hisStart + this.hisSize);
                hisQueryPage.setMod(this.hisSize);
                reqHis.setStartDate(queryPage.getBeginDate());
                reqHis.setEndDate(da.minusDays(1L).format(this.formatter));
                do {
                    hisQueryPage.updatePage(pageReq);
                    reqHis.setPage(pageReq);
                    res = this.api.getHisPositions(reqHis);
                    respList.addAll(res.getPosData());
                } while (hisQueryPage.hasNext(res.getTotal()));
                queryPage.setTotalCount(Integer.valueOf(this.todaySum + res.getTotal()));
            } else {
                queryPage.setTotalCount(Integer.valueOf(this.todaySum + this.hisSum));
            }
        } else {
            queryPage.initParam();
            Page pageReq = this.httpApi.getHttpDefPage();
            do {
                queryPage.updatePage(pageReq);
                reqHis.setPage(pageReq);
                res = this.api.getHisPositions(reqHis);
                respList.addAll(res.getPosData());
            } while (queryPage.hasNext(res.getTotal()));
        }
        return respList;
    }

    @Override
    public synchronized void query(HisQueryPage<ObPosition> queryPage) throws MException, Exception {
        GetPositionsReq reqHis = new GetPositionsReq();
        reqHis.setOpUser(this.httpApi.getHttpOpUser());
        reqHis.setMarketGroup("CCS");
        reqHis.setAccntType(AccntType.ACCNT_TYPE_SEC);
        reqHis.setIncludeZero(Boolean.valueOf(queryPage.isContainsClose()));
        if (!StringUtils.isEmpty((String)queryPage.getSecurityId())) {
            QueryFilter filter = new QueryFilter();
            HashMap<String, Condition> arg = new HashMap<String, Condition>();
            Condition securityId = new Condition();
            securityId.setStringVal(queryPage.getSecurityId());
            securityId.setOp(Condition.OP.EQ);
            arg.put("security_id", securityId);
            filter.setArg(arg);
            reqHis.setFilter(filter);
        }
        this.dimension = queryPage.getDimension();
        if (this.dimension.equals("1")) {
            reqHis.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
            reqHis.setAccntId(queryPage.getAccountIdList());
        } else if (this.dimension.equals("2")) {
            reqHis.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
            reqHis.setAccntId(queryPage.getSubAccntIdList());
        } else if (this.dimension.equals("7")) {
            reqHis.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
            reqHis.setAssetGroupType(Integer.valueOf(AssetGroupType.kPortfolio.getValue()));
            reqHis.setAccntId(queryPage.getSubAccntIdList());
            reqHis.setAssetGroupId(queryPage.getAssetsGrpIdList());
        }
        reqHis.setStartDate(queryPage.getBeginDate());
        reqHis.setEndDate(queryPage.getEndDate());
        List<PositionNew> respList = this.queryData(queryPage, reqHis);
        HashSet<String> dateSet = new HashSet<String>();
        HashSet<PComponent.Instrument> setInstrument = new HashSet<PComponent.Instrument>();
        this.ids.clear();
        for (PositionNew position : respList) {
            if ("1".equals(this.dimension)) {
                if (position.getAccntId() != null) {
                    position.setInvestorId(this.accntMngService.getCcsInvesId(position.getAccntId()));
                    this.ids.add(position.getInvestorId());
                }
                if (position.getSecAccntId() != null) {
                    position.setInvestorSecId(this.accountMap.getAllCcsInverstorSecId(position.getSecAccntId()));
                }
            } else if ("2".equals(this.dimension) || "7".equals(this.dimension)) {
                CcsSubSecAccount sec;
                if (position.getAccntId() != null) {
                    position.setInvestorId(this.subAccMng.getNewSubFundAccountById(position.getAccntId()));
                }
                if (position.getSecAccntId() != null && (sec = this.subAccMng.getSubSecAccountByIdAndMarket(position.getSecAccntId(), position.getInstrument().getMarket())) != null) {
                    position.setInvestorSecId(sec.getInverstorSecId());
                    position.setPortfolioId(sec.getPortfolioId());
                    position.setPortfolioName(sec.getPortfolioName());
                    this.ids.add(sec.getPortfolioId());
                }
                if (!StringUtils.isEmpty((String)position.getAssetGroupId())) {
                    Set<String> portSet = this.assetIdMap.get(position.getAssetGroupId());
                    this.ids.addAll(portSet);
                }
            }
            ObPosition ob = new ObPosition();
            ob.update((Object)position);
            this.calculateStockPercent(ob);
            ob.setUnit(QueryUtils.getUnit(ob.getSecType(), ob.getMarket().getRaw()));
            dateSet.add(ob.getTrdDate());
            PComponent.Instrument instrument = this.industryName.getInstrument(ob.getSecType(), ob.getSecurityId(), ob.getMarket().getRaw());
            if (instrument != null) {
                setInstrument.add(instrument);
            }
            this.list.add(ob);
        }
        this.industryName.queryRefData(new ArrayList<PComponent.Instrument>(setInstrument));
        this.queryHisRate(dateSet);
        this.queryNet(dateSet);
        this.sdFullQuery.schedule(event -> this.queryMarketItem(this.list));
        queryPage.updateData(this.list);
    }

    private String getKey(ObPosition po) {
        StringBuilder key = new StringBuilder(String.join((CharSequence)",", po.getSecurityId(), po.getMarket().getRaw()));
        return key.toString();
    }

    private boolean timeIsValid(int time) {
        return time >= this.amB && time <= this.pmE;
    }

    @Override
    public void queryNewMarketItem(List<ObPosition> posList) {
        if (this.dateString.compareTo(this.endDate) > 0 || !this.timeIsValid(LocalDateTime.now().getHour())) {
            return;
        }
        this.queryMarketItem(posList);
    }

    public synchronized void queryMarketItem(List<ObPosition> posList) {
        if (this.dateString.compareTo(this.endDate) <= 0) {
            LinkedList<RefItem> listItem = new LinkedList<RefItem>();
            LinkedList<RefItem> listItemNew = new LinkedList<RefItem>();
            for (ObPosition t : posList) {
                if (this.dateString.compareTo(t.getTrdDate()) > 0) continue;
                RefItem item = null;
                if ("SHSC".equals(t.getMarket().getRaw()) || "SZSC".equals(t.getMarket().getRaw())) {
                    item = this.refMng.getItem(String.valueOf(t.getSecType()) + t.getMarket().getRaw(), t.getMarket().getRaw(), t.getSecurityId());
                } else if ("NEEQ".equals(t.getMarket().getRaw())) {
                    item = this.newRefMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecurityId());
                    if (item != null) {
                        listItemNew.add(item);
                        continue;
                    }
                } else {
                    item = this.refMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecurityId());
                }
                if (item == null) continue;
                listItem.add(item);
            }
            Gears gears = new Gears();
            gears.setBuy(new int[]{0});
            if (!listItem.isEmpty()) {
                this.marketMng.queryNewPriceIn5Seconds(listItem, gears);
            }
            if (!listItemNew.isEmpty()) {
                this.newMarketMng.query(listItemNew);
            }
            try {
                if ("1".equals(this.dimension)) {
                    this.queryAccDetail(this.dateString, this.dateString);
                } else if ("2".equals(this.dimension) || "7".equals(this.dimension)) {
                    this.queryPortfDetail(this.dateString, this.dateString);
                }
            }
            catch (MException | Exception e) {
                logger.error("\u67e5\u8be2\u51c0\u503c\u5931\u8d25" + e.getMessage(), e);
            }
        }
        for (ObPosition po : posList) {
            if (po.getSecType().equals("STD_BOND") || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                po.setNowPrice(100.0);
                po.setClosePrice(100.0);
            }
            if (this.dateString.compareTo(po.getTrdDate()) <= 0) {
                double precent;
                String key;
                RefItem refItem = this.refMng.getItem(po.getSecType(), po.getMarket().getRaw(), po.getSecurityId());
                if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                    refItem = this.refMng.getItem(String.valueOf(po.getSecType()) + po.getMarket().getRaw(), po.getMarket().getRaw(), po.getSecurityId());
                } else if ("NEEQ".equals(po.getMarket().getRaw())) {
                    refItem = this.newRefMng.getItem(po.getSecType(), po.getMarket().getRaw(), po.getSecurityId());
                }
                if (refItem != null) {
                    MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
                    if ("NEEQ".equals(po.getMarket().getRaw())) {
                        marketItem = this.newMarketMng.getItem(refItem);
                    }
                    if (marketItem != null) {
                        if (marketItem.getClosePrice() == 0.0) {
                            po.setOpenPrice(marketItem.getOpenPrice());
                        } else {
                            po.setOpenPrice(marketItem.getClosePrice());
                        }
                        if (marketItem.getNowPrice() == 0.0) {
                            po.setNowPrice(marketItem.getClosePrice());
                            po.setClosePrice(marketItem.getClosePrice());
                        } else {
                            po.setNowPrice(marketItem.getNowPrice());
                            po.setClosePrice(marketItem.getNowPrice());
                        }
                    }
                }
                double capitalization = QueryUtils.calAmountByMarketAndSecType(po.getMarket().getRaw(), po.getSecType(), po.getSecBalance(), po.getNowPrice());
                if (po.getSecType().equals("STD_BOND") || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                    capitalization = po.getSecBalance() * (double)("XSHG".equals(po.getMarket().getRaw()) ? 1000 : 100);
                }
                po.setMarketValue((double)Math.round(capitalization * 1000.0) / 1000.0);
                po.setCapitalCNY((double)Math.round(po.getMarketValue() * 100.0) / 100.0);
                if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                    po.setCapitalCNY((double)Math.round(po.getMarketValue() * po.getHkRate() * 100.0) / 100.0);
                }
                po.updateProfit();
                if ("1".equals(this.dimension)) {
                    key = String.valueOf(po.getInvestorId()) + "," + po.getTrdDate();
                    if (this.accntMap.get(key) != null && 0.0 != this.accntMap.get(key).getNetAsset()) {
                        precent = (double)Math.round(po.getMarketValue() * 10000.0 / this.accntMap.get(key).getNetAsset()) / 100.0;
                        if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                            precent = (double)Math.round(po.getMarketValue() * 10000.0 * po.getHkRate() / this.accntMap.get(key).getNetAsset()) / 100.0;
                        }
                        po.setNet(precent);
                    }
                } else if ("2".equals(this.dimension)) {
                    key = String.valueOf(po.getPortfolioId()) + "," + po.getTrdDate();
                    if (!StringUtils.isEmpty((String)po.getPortfolioId()) && this.portMap.get(key) != null && 0.0 != this.portMap.get(key).getNetAsset()) {
                        precent = (double)Math.round(po.getMarketValue() * 10000.0 / this.portMap.get(key).getNetAsset()) / 100.0;
                        if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                            precent = (double)Math.round(po.getMarketValue() * 10000.0 * po.getHkRate() / this.portMap.get(key).getNetAsset()) / 100.0;
                        }
                        po.setNet(precent);
                    }
                } else if ("7".equals(this.dimension)) {
                    Set<String> portSet = this.assetIdMap.get(po.getAssetGroupId());
                    double netAsset = 0.0;
                    StringBuilder key2 = new StringBuilder();
                    for (String portId : portSet) {
                        key2 = new StringBuilder(portId).append(",").append(po.getTrdDate());
                        netAsset += this.portMap.get(key2.toString()).getNetAsset().doubleValue();
                    }
                    if (!StringUtils.isEmpty((String)po.getAssetGroupId()) && this.assetIdMap.get(po.getAssetGroupId()) != null && this.assetIdMap.get(po.getAssetGroupId()).size() > 0 && 0.0 != netAsset) {
                        double precent2 = (double)Math.round(po.getMarketValue() * 10000.0 / netAsset) / 100.0;
                        if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                            precent2 = (double)Math.round(po.getMarketValue() * 10000.0 * po.getHkRate() / netAsset) / 100.0;
                        }
                        po.setNet(precent2);
                    }
                }
            }
            BigDecimal b = new BigDecimal(po.getCost());
            double cost = b.setScale(4, 4).doubleValue();
            if (po.getSecType().equals("STD_BOND") || po.getNowPrice() == 0.0 || cost == 0.0 || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                po.setPercent(0.0);
            } else {
                double percent = (po.getNowPrice() - cost) * 100.0 / cost;
                po.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
            }
            BigDecimal buy = new BigDecimal(po.getBuyCost());
            double buyCost = buy.setScale(4, 4).doubleValue();
            if (po.getSecType().equals("STD_BOND") || po.getNowPrice() == 0.0 || buyCost == 0.0 || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                po.setYield(0.0);
            } else {
                double yield = (po.getNowPrice() - buyCost) * 100.0 / buyCost;
                po.setYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
            }
            BigDecimal open = new BigDecimal(po.getOpenPrice());
            double openPrice = open.setScale(4, 4).doubleValue();
            if (po.getSecType().equals("STD_BOND") || po.getNowPrice() == 0.0 || openPrice == 0.0 || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) continue;
            double rate = (double)Math.round((po.getNowPrice() - openPrice) * 10000.0 / openPrice) / 100.0;
            po.setRate(rate);
        }
    }

    private void calculateStockPercent(ObPosition posi) {
        RefItem item = null;
        item = "SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw()) ? this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecurityId()) : ("NEEQ".equals(posi.getMarket().getRaw()) ? this.newRefMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecurityId()) : this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecurityId()));
        posi.setTotalStockPercent("0.00");
        if (item != null && item.getTotalCapitalStock() > 0L) {
            double precent = (double)Math.round(posi.getSecBalance() * 10000.0 / (double)item.getTotalCapitalStock()) / 100.0;
            posi.setTotalStockPercent(StringUtils.toStr((double)precent, (int)2).replaceAll(",", ""));
        }
    }

    @Override
    public HisQueryPage<ObPosition> getAllCcsData(HisQueryPage<ObPosition> pageCcs) throws MException, Exception {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setAccountIdList(pageCcs.getAccountIdList());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setAssetsGrpIdList(pageCcs.getAssetsGrpIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        page.setContainsClose(pageCcs.isContainsClose());
        this.query((HisQueryPage<ObPosition>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(150);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<ObPosition>)page);
        }
        return page;
    }

    private void queryAccDetail(String beginDate, String endDate) throws MException {
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            this.accountDetailService.queryNewNetsInTurn((IPageInTurn<String, String, ExtAccntDetail>)page, beginDate, endDate, this.ids);
            this.transferAccNet(this.accntMap, (IPageInTurn<String, String, ExtAccntDetail>)page);
        });
    }

    private void transferAccNet(Map<String, ExtAccntDetail> accntMap, IPageInTurn<String, String, ExtAccntDetail> page) throws MException {
        for (ExtAccntDetail detail : page.getResList()) {
            if (StringUtils.isEmpty((String)detail.getInvestorId())) continue;
            String key = String.valueOf(detail.getInvestorId()) + "," + detail.getTradDate();
            accntMap.put(key, detail);
        }
    }

    private void queryPortfDetail(String beginDate, String endDate) throws MException {
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            this.portfDetailService.queryNewNetsInTurn((IPageInTurn<String, String, PortfolioDetailNew>)page, beginDate, endDate, this.ids);
            this.transferPortfNet(this.portMap, (IPageInTurn<String, String, PortfolioDetailNew>)page);
        });
    }

    private void transferPortfNet(Map<String, PortfolioDetailNew> portMap, IPageInTurn<String, String, PortfolioDetailNew> page) throws MException {
        for (PortfolioDetailNew detail : page.getResList()) {
            if (StringUtils.isEmpty((String)detail.getPortfolioId())) continue;
            String key = String.valueOf(detail.getPortfolioId()) + "," + detail.getTradDate();
            portMap.put(key, detail);
        }
    }

    @Override
    public Map<String, ExtAccntDetail> getAccntMap() {
        return this.accntMap;
    }

    @Override
    public Map<String, PortfolioDetailNew> getPortMap() {
        return this.portMap;
    }

    @Override
    public Map<String, Set<String>> getAssetIdMap() {
        return this.assetIdMap;
    }

    @Override
    public void setAssetIdMap(Map<String, Set<String>> assetIdMap) {
        this.assetIdMap = assetIdMap;
    }
}

