/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.ExtPositionsHisResp;
import cms.tmx.api.SubPositionsHisResp;
import cms.tmx.api.data.IRefItem;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.data.utils.Gears;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.ExtAccntDetail;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.PledgeInfo;
import cms.tmx.entity.trade.PortfolioDetail;
import cms.tmx.entity.trade.Position;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.query.history.ICcsPositionHisService;
import cms.tmx.query.history.models.AccountDetailServiceImpl;
import cms.tmx.query.history.models.PortfolioDetailServiceImpl;
import cms.tmx.query.history.models.PositionHisModel;
import cms.tmx.query.utils.QueryByPage;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsPositionHisServiceImpl
extends PositionHisModel<CcsPosition>
implements ICcsPositionHisService {
    @Inject
    protected PositionFactory factory;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IMarketDataMng marketMng;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    private Set<String> pledgeSet;
    private Date date = new Date();
    private SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    private String dateString;
    private PPositionService.PositionCollect collect;
    private boolean firstQuery;
    @Inject
    protected MScheduler sdFullQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private AccountDetailServiceImpl accountDetailService;
    @Inject
    private PortfolioDetailServiceImpl portfDetailService;
    private Map<String, ExtAccntDetail> accntMap = new HashMap<String, ExtAccntDetail>();
    private Map<String, PortfolioDetail> portMap = new HashMap<String, PortfolioDetail>();
    private String dimension;
    private String endDate;
    private int amB = 9;
    private int pmE = 16;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
    }

    @Override
    public synchronized void query(HisQueryPage<CcsPosition> queryPage) throws MException {
        Position posi;
        List listInfo;
        LinkedList<Object> list = new LinkedList<Object>();
        queryPage.getDataList().clear();
        this.dateString = this.format.format(this.date);
        this.dimension = queryPage.getDimension();
        this.endDate = queryPage.getEndDate();
        HashSet<String> dateSet = new HashSet<String>();
        if ("1".equals(queryPage.getDimension()) || "6".equals(queryPage.getDimension())) {
            ExtPositionsHisResp extPositionsHisResp = this.positionHisQueryApi.queryHisPositions(queryPage);
            listInfo = extPositionsHisResp.getList();
            this.collect = extPositionsHisResp.getCollect();
            for (PPositionService.ExtPosition info : listInfo) {
                posi = this.factory.create(info);
                this.model.afterUpdate(posi);
                if (!(posi instanceof CcsPosition)) continue;
                CcsPosition ccs = (CcsPosition)CcsPosition.class.cast(posi);
                this.calculateStockPercent(ccs);
                this.model.getPositionPrice(ccs);
                if (!StringUtils.isEmpty((String)ccs.getAccntGrpName())) {
                    ccs.setAccntGrpName(this.assetGrpMng.getCacheAsset(ccs.getAccntGrpName()));
                }
                dateSet.add(ccs.getTradingDay());
                list.add((CcsPosition)CcsPosition.class.cast(posi));
            }
        } else if ("7".equals(queryPage.getDimension())) {
            SubPositionsHisResp subPositionsHisResp = this.positionHisQueryApi.queryHisPosiPort(queryPage);
            listInfo = subPositionsHisResp.getList();
            this.collect = subPositionsHisResp.getCollect();
            for (PPositionService.ExtPosition info : listInfo) {
                posi = this.factory.create((PPositionService.SubPosition)info);
                this.calculateStockPercent((CcsPosition)posi);
                this.model.afterUpdate(posi);
                this.model.getPositionPrice((CcsPosition)posi);
                posi.setAccntGrpName(this.assetGrpMng.getCacheAsset(posi.getSubAccntId().split("_")[0]));
                list.add(posi);
            }
        } else {
            SubPositionsHisResp subPositionsHisResp = this.positionHisQueryApi.queryHisPosiPort(queryPage);
            listInfo = subPositionsHisResp.getList();
            this.collect = subPositionsHisResp.getCollect();
            for (PPositionService.ExtPosition info : listInfo) {
                posi = this.factory.create((PPositionService.SubPosition)info);
                this.calculateStockPercent((CcsPosition)posi);
                this.model.afterUpdate(posi);
                this.model.getPositionPrice((CcsPosition)posi);
                dateSet.add(posi.getTradingDay());
                list.add(posi);
            }
        }
        try {
            if ("1".equals(queryPage.getDimension())) {
                this.accntMap.clear();
                for (String string : dateSet) {
                    if (string.equals(this.dateString)) {
                        this.queryAccDetail("", "");
                        continue;
                    }
                    this.queryAccDetail(string, string);
                }
                for (CcsPosition ccsPosition : list) {
                    String key = String.valueOf(ccsPosition.getInvestorId()) + "," + ccsPosition.getTradingDay();
                    if (this.accntMap.get(key) == null || 0.0 == this.accntMap.get(key).getNetValue()) continue;
                    double precent = (double)Math.round(ccsPosition.getCapitalization() * ccsPosition.getExchangeRate() * 10000.0 / this.accntMap.get(key).getNetValue()) / 100.0;
                    ccsPosition.setNet(precent);
                }
            } else if ("2".equals(queryPage.getDimension())) {
                this.portMap.clear();
                for (String string : dateSet) {
                    if (string.equals(this.dateString)) {
                        this.queryPortfDetail("", "");
                        continue;
                    }
                    this.queryPortfDetail(string, string);
                }
                for (CcsPosition ccsPosition : list) {
                    CcsPortfPosition posi2;
                    String key;
                    if (!(ccsPosition instanceof CcsPortfPosition) || this.portMap.get(key = String.valueOf((posi2 = (CcsPortfPosition)CcsPortfPosition.class.cast(ccsPosition)).getPortfolioId()) + "," + posi2.getTradingDay()) == null || 0.0 == this.portMap.get(key).getNetAsset()) continue;
                    double precent = (double)Math.round(posi2.getCapitalization() * posi2.getExchangeRate() * 10000.0 / this.portMap.get(key).getNetAsset()) / 100.0;
                    posi2.setNet(precent);
                }
            }
        }
        catch (MException | Exception throwable) {
            this.logger.error("\u67e5\u8be2\u51c0\u503c\u5931\u8d25" + throwable.getMessage(), throwable);
        }
        this.firstQuery = true;
        this.sdFullQuery.schedule(event -> this.queryMarketItem(list));
        queryPage.updateData(list);
    }

    private boolean timeIsValid(int time) {
        return time >= this.amB && time <= this.pmE;
    }

    @Override
    public void queryNewMarketItem(List<CcsPosition> posList) {
        if (this.dateString.compareTo(this.endDate) > 0 || !this.timeIsValid(LocalDateTime.now().getHour())) {
            return;
        }
        this.queryMarketItem(posList);
    }

    public Set<String> getPledgeCode() {
        if (this.pledgeSet == null) {
            this.pledgeSet = new HashSet<String>();
            List list = (List)this.refMng.getItems(new String[]{"PLEDGE"});
            for (RefItem item : list) {
                PledgeInfo info = (PledgeInfo)item;
                this.pledgeSet.add(info.getStdCode());
            }
        }
        return this.pledgeSet;
    }

    public synchronized void queryMarketItem(List<CcsPosition> posList) {
        if (!this.firstQuery && this.endDate.equals(this.dateString)) {
            LinkedList<RefItem> listItem = new LinkedList<RefItem>();
            for (CcsPosition t : posList) {
                if (!this.dateString.equals(t.getTradingDay())) continue;
                RefItem item = this.refMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecId());
                if ("SHSC".equals(t.getMarket().getRaw()) || "SZSC".equals(t.getMarket().getRaw())) {
                    item = this.refMng.getItem(String.valueOf(t.getSecType()) + t.getMarket().getRaw(), t.getMarket().getRaw(), t.getSecId());
                }
                if (item == null) continue;
                listItem.add(item);
            }
            Gears gears = new Gears();
            gears.setBuy(new int[]{0});
            if (!listItem.isEmpty()) {
                this.marketMng.queryNewPriceIn5Seconds(listItem, gears);
            }
            try {
                if ("1".equals(this.dimension)) {
                    this.queryAccDetail("", "");
                } else if ("2".equals(this.dimension)) {
                    this.queryPortfDetail("", "");
                }
            }
            catch (MException e) {
                this.logger.error("\u67e5\u8be2\u51c0\u503c\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
        for (CcsPosition posi : posList) {
            double yield;
            if (!this.firstQuery && this.dateString.equals(posi.getTradingDay())) {
                double precent;
                String key;
                RefItem refItem = null;
                refItem = "SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw()) ? this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecId()) : this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
                if (refItem == null) {
                    if ("STD_BOND".equals(posi.getSecType())) {
                        posi.setNowPrice(100.0);
                        posi.setClosePrice(100.0);
                    }
                } else {
                    MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
                    if (marketItem != null) {
                        if (marketItem.getNowPrice() == 0.0) {
                            posi.setNowPrice(marketItem.getClosePrice());
                        } else {
                            posi.setNowPrice(marketItem.getNowPrice());
                        }
                    }
                }
                double capitalization = QueryUtils.calAmountByMarketAndSecType(posi.getMarket().getRaw(), posi.getSecType(), posi.getTotalVol(), posi.getNowPrice());
                posi.setCapitalization((double)Math.round(capitalization * 10000.0) / 10000.0);
                posi.updateProfit();
                if ("1".equals(this.dimension)) {
                    key = String.valueOf(posi.getInvestorId()) + "," + posi.getTradingDay();
                    if (this.accntMap.get(key) != null && 0.0 != this.accntMap.get(key).getNetValue()) {
                        precent = (double)Math.round(posi.getCapitalization() * posi.getExchangeRate() * 10000.0 / this.accntMap.get(key).getNetValue()) / 100.0;
                        posi.setNet(precent);
                    }
                } else if ("2".equals(this.dimension) && this.portMap.get(key = String.valueOf(posi.getPortfolioId()) + "," + posi.getTradingDay()) != null && 0.0 != this.portMap.get(key).getNetAsset()) {
                    precent = (double)Math.round(posi.getCapitalization() * posi.getExchangeRate() * 10000.0 / this.portMap.get(key).getNetAsset()) / 100.0;
                    posi.setNet(precent);
                }
            }
            BigDecimal b = new BigDecimal(posi.getCost());
            double cost = b.setScale(4, 4).doubleValue();
            if (posi.getNowPrice() == 0.0 || cost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setPercent(0.0);
            } else {
                double percent = (posi.getNowPrice() - cost) * 100.0 / cost;
                posi.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
            }
            BigDecimal buy = new BigDecimal(posi.getBuyCost());
            double buyCost = buy.setScale(4, 4).doubleValue();
            if (posi.getNowPrice() == 0.0 || buyCost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setYield(0.0);
            } else {
                yield = (posi.getNowPrice() - buyCost) * 100.0 / buyCost;
                posi.setYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
            }
            if (posi.getNowPrice() == 0.0 || posi.getCarryBuyCost() == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setCarryYield(0.0);
                continue;
            }
            yield = (posi.getNowPrice() - posi.getCarryBuyCost()) * 100.0 / posi.getCarryBuyCost();
            posi.setCarryYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
        }
        this.firstQuery = false;
    }

    private void calculateStockPercent(CcsPosition posi) {
        RefItem item = null;
        item = "SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw()) ? this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecId()) : this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
        posi.setTotalStockPercent("0.00");
        if (item != null && item.getTotalCapitalStock() > 0L) {
            double precent = (double)posi.getTotalVol() * 100.0 / (double)item.getTotalCapitalStock();
            posi.setTotalStockPercent(StringUtils.toStr((double)precent, (int)2).replaceAll(",", ""));
        }
    }

    @Override
    public HisQueryPage<CcsPosition> getAllCcsData(HisQueryPage<CcsPosition> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setExtAccntIdList(pageCcs.getExtAccntIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setAssetGrpIdList(pageCcs.getAssetGrpIdList());
        page.setAssetsGrpIdList(pageCcs.getAssetsGrpIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        page.setContainsClose(pageCcs.isContainsClose());
        this.query((HisQueryPage<CcsPosition>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(150);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<CcsPosition>)page);
        }
        return page;
    }

    private void queryAccDetail(String beginDate, String endDate) throws MException {
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            this.accountDetailService.queryNetsInTurn((IPageInTurn<String, String, ExtAccntDetail>)page, this.baseApi.getPartyId(), beginDate, endDate);
            this.transferAccNet(this.accntMap, (IPageInTurn<String, String, ExtAccntDetail>)page);
        });
    }

    private void transferAccNet(Map<String, ExtAccntDetail> accntMap, IPageInTurn<String, String, ExtAccntDetail> page) throws MException {
        for (ExtAccntDetail detail : page.getResList()) {
            if (StringUtils.isEmpty((String)detail.getInvestorId())) continue;
            String key = String.valueOf(detail.getInvestorId()) + "," + detail.getTradingDate();
            accntMap.put(key, detail);
        }
    }

    private void queryPortfDetail(String beginDate, String endDate) throws MException {
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            this.portfDetailService.queryNetsInTurn((IPageInTurn<String, String, PortfolioDetail>)page, this.baseApi.getPartyId(), beginDate, endDate);
            this.transferPortfNet(this.portMap, (IPageInTurn<String, String, PortfolioDetail>)page);
        });
    }

    private void transferPortfNet(Map<String, PortfolioDetail> portMap, IPageInTurn<String, String, PortfolioDetail> page) throws MException {
        for (PortfolioDetail detail : page.getResList()) {
            if (StringUtils.isEmpty((String)detail.getPortfolioId())) continue;
            String key = String.valueOf(detail.getPortfolioId()) + "," + detail.getTradingDate();
            portMap.put(key, detail);
        }
    }

    @Override
    public PPositionService.PositionCollect getCollect() {
        return this.collect;
    }
}

