/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.query.history.ICcsOrderHisService;
import cms.tmx.query.history.models.OrderHisModel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsOrderHisServiceImpl
extends OrderHisModel<CcsOrder>
implements ICcsOrderHisService {
    @Inject
    private OrderFactory factory;

    @Override
    public void query(HisQueryPage<CcsOrder> orderPage) throws MException {
        LinkedList<CcsOrder> list = new LinkedList<CcsOrder>();
        List listInfo = this.orderHisQuery.queryHisOrders(orderPage, Integer.valueOf(0));
        for (POrderService.SingleOrder pOrder : listInfo) {
            CcsOrder order = this.factory.createCcsOrder();
            order.update((Object)pOrder);
            order.setWthUserName(this.getWthUserName(pOrder));
            order.setErrInfo(order.transferErrInfo());
            this.model.afterUpdate(order);
            this.model.getOrderPrice((Order)order);
            list.add((CcsOrder)CcsOrder.class.cast(order));
        }
        orderPage.updateData(list);
    }

    @Override
    public Set<Order> queryInstuctionOrder(List<String> accId, String dimension, Instruction instr, String beginDate, String endDate) throws MException {
        HashSet<Order> setOrder = new HashSet<Order>();
        List orderList = this.orderHisQuery.queryHisInstructionOrders(accId, dimension, instr.getMarketGrp(), instr.getResource().getId(), instr.getId(), beginDate, endDate);
        for (POrderService.SingleOrder pOrder : orderList) {
            Order order = this.factory.create(pOrder);
            order.update((Object)pOrder);
            order.setWthUserName(this.getWthUserName(pOrder));
            order.setErrInfo(order.transferErrInfo());
            setOrder.add(order);
        }
        return setOrder;
    }

    @Override
    public void queryAlgoOrder(HisQueryPage<CcsOrder> orderPage) throws MException {
        LinkedList<CcsOrder> list = new LinkedList<CcsOrder>();
        List listInfo = this.orderHisQuery.queryAlgoOrders(orderPage);
        for (POrderService.SingleOrder info : listInfo) {
            CcsOrder order = this.factory.createCcsOrder();
            order.update((Object)info);
            this.model.afterUpdate(order);
            list.add((CcsOrder)CcsOrder.class.cast(order));
        }
        orderPage.updateData(list);
    }

    @Override
    public void queryOneCcsOrder(HisQueryPage<CcsOrder> orderPage, String parentId) throws MException {
        orderPage.getDataList().clear();
        List orderList = this.orderHisQuery.queryOneHisOrders(orderPage, parentId);
        orderList.forEach(item -> {
            Order order = this.factory.create(item);
            if (order instanceof CcsOrder) {
                CcsOrder ccsOrder = (CcsOrder)order;
                this.model.afterUpdate(ccsOrder);
                orderPage.getDetailList().add((Object)ccsOrder);
            }
        });
    }

    @Override
    public HisQueryPage<CcsOrder> getAllCcsData(HisQueryPage<CcsOrder> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setExtAccntIdList(pageCcs.getExtAccntIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setAssetGrpIdList(pageCcs.getAssetGrpIdList());
        page.setAssetsGrpIdList(pageCcs.getAssetsGrpIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        this.query((HisQueryPage<CcsOrder>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<CcsOrder>)page);
        }
        return page;
    }
}

