/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.trade.ConvertibleBond;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.dto.GetOrdersReq;
import cms.tmx.http.api.strategy.dto.GetOrdersResp;
import cms.tmx.http.api.strategy.dto.ObOrder;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.javafx.MxPageList;
import cms.tmx.query.history.ICcsNewOrderHisService;
import cms.tmx.query.history.models.OrderHisModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsNewOrderHisServiceImpl
extends OrderHisModel<ObOrder>
implements ICcsNewOrderHisService {
    @Inject
    private OrderFactory factory;
    @Inject
    private HttpBaseApi baseApi;
    protected boolean isUnfinishedOrder = false;
    @Inject
    private OrderServiceNewApi api;
    @Inject
    private IRefDataMng refMng;
    protected List<ObOrder> list = new ArrayList<ObOrder>();
    protected MxPageList<Order, ObOrder> mxlist = new MxPageList(500, ObOrder.class);
    private List<Order> otcList = new ArrayList<Order>();
    private List<ObOrder> obOtcList = new ArrayList<ObOrder>();

    @Override
    public void query(HisQueryPage<ObOrder> page) throws MException, IOException {
        GetOrdersReq req = new GetOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup(page.getMarketGrp());
        Instrument instrument = new Instrument();
        instrument.setSecurityId(page.getSecurityId());
        req.setInstrument(instrument);
        ArrayList extCashAccntIdList = new ArrayList();
        ArrayList portfolioIdList = new ArrayList();
        if (page.getDimension().equals("1")) {
            extCashAccntIdList.addAll(page.getNewAccntIdList());
        } else if (page.getDimension().equals("2")) {
            portfolioIdList.addAll(page.getPortfolioIdList());
            extCashAccntIdList.addAll(page.getNewAccntIdList());
            req.setPortfolioId(portfolioIdList);
            req.setExtCashAccntId(extCashAccntIdList);
        } else if (page.getDimension().equals("7")) {
            extCashAccntIdList.addAll(page.getNewAccntIdList());
            req.setPortfolioId(page.getPortfolioIdList());
        }
        req.setExtCashAccntId(extCashAccntIdList);
        req.setBeginDate(page.getBeginDate());
        req.setEndDate(page.getEndDate());
        page.initParam();
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        GetOrdersResp resp = null;
        this.mxlist.clear();
        do {
            page.updatePage(fragment);
            req.setFragment(fragment);
            resp = this.api.getOrders(req);
            this.mxlist.addAll(resp.getData());
        } while (page.hasNext(resp.getTotal()));
        ArrayList<ObOrder> arrayList = new ArrayList<ObOrder>();
        for (Order order : this.mxlist.getList()) {
            order.setExtraFields();
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            order.setMarket(MarketUtils.getMarketNameById((String)order.getInstrument().getMarket()));
            order.setDonePercent(order.getDonePercent());
            order.setUnit(this.getUnit(order.getInstrument()));
            order.setCxlErrInfo(this.transfersErrInfo(order));
            ObOrder obOrder = new ObOrder();
            obOrder.update((Object)order);
            arrayList.add(obOrder);
        }
        this.mxlist.updatePageList();
        page.updateData(arrayList);
    }

    public String getUnit(Instrument inst) {
        RefItem refItem;
        String type = inst.getSecurityType();
        if (inst.getSecurityType().equals("OIS") && (refItem = this.refMng.getItem(inst.getSecurityType(), inst.getMarket(), inst.getSecurityId())) instanceof ConvertibleBond) {
            ConvertibleBond bond = (ConvertibleBond)refItem;
            type = "\u65b0\u80a1\u7533\u8d2d".equals(bond.getSubType()) ? "STOCK" : ("\u53ef\u8f6c\u503a\u7533\u8d2d".equals(bond.getSubType()) ? "BOND" : "FUND");
        }
        String market = inst.getMarket();
        String unit = QueryUtils.getUnit(type, market);
        return unit;
    }

    @Override
    public void queryOtc(HisQueryPage<ObOrder> page) throws MException, IOException {
        this.otcList.clear();
        this.obOtcList.clear();
        GetOrdersReq req = new GetOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup(page.getMarketGrp());
        Instrument instrument = new Instrument();
        instrument.setSecurityId(page.getSecurityId());
        req.setInstrument(instrument);
        if (page.getDimension().equals("1")) {
            req.setExtCashAccntId(page.getNewAccntIdList());
        } else if (page.getDimension().equals("2")) {
            req.setExtCashAccntId(page.getNewAccntIdList());
            req.setPortfolioId(page.getPortfolioIdList());
        } else if (page.getDimension().equals("7")) {
            req.setExtCashAccntId(page.getNewAccntIdList());
            req.setPortfolioId(page.getPortfolioIdList());
        }
        req.setBeginDate(page.getBeginDate());
        req.setEndDate(page.getEndDate());
        page.initParam();
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        GetOrdersResp resp = null;
        do {
            page.updatePage(fragment);
            req.setFragment(fragment);
            resp = this.api.getOrders(req);
            this.otcList.addAll(resp.getData());
        } while (page.hasNext(resp.getTotal()));
        for (Order order : this.otcList) {
            order.setExtraFields();
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            order.setMarket(MarketUtils.getMarketNameById((String)order.getInstrument().getMarket()));
            order.setDonePercent(order.getDonePercent());
            order.setUnit(CcsNewOrderHisServiceImpl.getUnit(order.getInstrument().getSecurityType(), order.getInstrument().getMarket()));
            order.setCxlErrInfo(this.transfersErrInfo(order));
            ObOrder ob = new ObOrder();
            ob.update((Object)order);
            this.obOtcList.add(ob);
        }
        page.updateData(this.obOtcList);
    }

    public static String getUnit(String secType, String market) {
        if ("STOCK".equals(secType) || "OIS".equals(secType)) {
            return "\u80a1";
        }
        if ("BOND".equals(secType) && "XSHG".equals(market) || "STD_BOND".equals(secType) && "XSHG".equals(market) || "REPO".equals(secType) && "XSHG".equals(market) || "PLEDGE".equals(secType) && "XSHG".equals(market)) {
            return "\u624b";
        }
        if ("BOND".equals(secType) && "XSHE".equals(market) || "STD_BOND".equals(secType) && "XSHE".equals(market) || "REPO".equals(secType) && "XSHE".equals(market) || "PLEDGE".equals(secType) && "XSHE".equals(market)) {
            return "\u5f20";
        }
        if ("FUND".equals(secType)) {
            return "\u4efd";
        }
        return "";
    }

    @Override
    public Set<ObOrder> queryInstuctionOrder(List<String> accId, String dimension, Instruction instr, String beginDate, String endDate) throws MException {
        HashSet<ObOrder> setOrder = new HashSet<ObOrder>();
        return setOrder;
    }

    @Override
    public void queryAlgoOrder(HisQueryPage<ObOrder> orderPage) throws MException {
    }

    @Override
    public void queryOneCcsOrder(HisQueryPage<ObOrder> orderPage, String parentId) throws MException {
    }

    @Override
    public HisQueryPage<ObOrder> getAllCcsData(HisQueryPage<ObOrder> pageCcs) throws MException, IOException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setNewAccntIdList(pageCcs.getNewAccntIdList());
        page.setPortfolioIdList(pageCcs.getPortfolioIdList());
        page.setExtAccntIdList(pageCcs.getExtAccntIdList());
        page.setNewCashAccntId(pageCcs.getNewCashAccntId());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setAssetGrpIdList(pageCcs.getAssetGrpIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        if ("OTC".equals(pageCcs.getMarketGrp())) {
            this.queryOtc((HisQueryPage<ObOrder>)page);
        } else {
            this.query((HisQueryPage<ObOrder>)page);
        }
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            if ("OTC".equals(pageCcs.getMarketGrp())) {
                this.queryOtc((HisQueryPage<ObOrder>)page);
            } else {
                this.query((HisQueryPage<ObOrder>)page);
            }
        }
        return page;
    }
}

