/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.trade.IDealHisQueryApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.CcsDealSum;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.ObExecution;
import cms.tmx.http.data.GetExecutionsReq;
import cms.tmx.http.data.GetExecutionsResp;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.query.history.ICcsNewDealHisService;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsNewDealHisServiceImpl
implements ICcsNewDealHisService {
    @Inject
    protected IDealHisQueryApi<CcsDeal> dealHisQueryApi;
    @Inject
    protected IDealHisQueryApi<CcsDealSum> dealSumHisQueryApi;
    @Inject
    protected MObjFactory of;
    @Inject
    protected QueryModel model;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private OrderServiceNewApi api;
    private List<Execution> list = new ArrayList<Execution>();
    private List<ObExecution> obList = new ArrayList<ObExecution>();

    @Override
    public void query(HisQueryPage<ObExecution> page) throws MException, IOException {
        this.list.clear();
        this.obList.clear();
        GetExecutionsReq req = new GetExecutionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup(page.getMarketGrp());
        Instrument instrument = new Instrument();
        instrument.setSecurityId(page.getSecurityId());
        req.setInstrument(instrument);
        if (page.getDimension().equals("1")) {
            req.setExtCashAccntId(page.getNewAccntIdList());
        } else if (page.getDimension().equals("2")) {
            req.setExtCashAccntId(page.getNewAccntIdList());
            req.setPortfolioId(page.getPortfolioIdList());
        } else if (page.getDimension().equals("7")) {
            req.setExtCashAccntId(page.getNewAccntIdList());
            req.setPortfolioId(page.getPortfolioIdList());
        }
        req.setBeginDate(page.getBeginDate());
        req.setEndDate(page.getEndDate());
        page.initParam();
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(page.getPageSize().intValue());
        req.setFragment(fragment);
        GetExecutionsResp resp = null;
        do {
            page.updatePage(fragment);
            req.setFragment(fragment);
            resp = this.api.getNewDeals(req);
            this.list.addAll(resp.getData());
        } while (page.hasNext(resp.getTotal()));
        for (Execution exe : this.list) {
            exe.setExtraFields();
            exe.setUnit(CcsNewDealHisServiceImpl.getUnit(exe.getInstrument().getSecurityType(), exe.getInstrument().getMarket()));
            ObExecution obDeal = new ObExecution();
            obDeal.update((Object)exe);
            this.obList.add(obDeal);
        }
        page.updateData(this.obList);
    }

    public static String getUnit(String secType, String market) {
        if ("STOCK".equals(secType) || "OIS".equals(secType)) {
            return "\u80a1";
        }
        if ("BOND".equals(secType) && "XSHG".equals(market) || "STD_BOND".equals(secType) && "XSHG".equals(market) || "REPO".equals(secType) && "XSHG".equals(market) || "PLEDGE".equals(secType) && "XSHG".equals(market)) {
            return "\u624b";
        }
        if ("BOND".equals(secType) && "XSHE".equals(market) || "STD_BOND".equals(secType) && "XSHE".equals(market) || "REPO".equals(secType) && "XSHE".equals(market) || "PLEDGE".equals(secType) && "XSHE".equals(market)) {
            return "\u5f20";
        }
        if ("FUND".equals(secType)) {
            return "\u4efd";
        }
        return "";
    }

    private double getIncurredAmt(CcsDealSum ccsDeal) {
        double amt = 0.0;
        int side = StringUtils.parseInt((String)ccsDeal.getSide().getRaw());
        switch (side) {
            case 49: 
            case 71: 
            case 80: 
            case 83: 
            case 201: {
                amt = ccsDeal.getDoneAmount() + ccsDeal.getRealFee();
                break;
            }
            default: {
                amt = ccsDeal.getDoneAmount() - ccsDeal.getRealFee();
            }
        }
        return amt;
    }

    @Override
    public HisQueryPage<ObExecution> getAllCcsData(HisQueryPage<ObExecution> pageCcs) throws MException, IOException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setNewAccntIdList(pageCcs.getNewAccntIdList());
        page.setPortfolioIdList(pageCcs.getPortfolioIdList());
        page.setExtAccntIdList(pageCcs.getExtAccntIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setAssetGrpIdList(pageCcs.getAssetGrpIdList());
        page.setAssetsGrpIdList(pageCcs.getAssetsGrpIdList());
        page.setNewCashAccntId(pageCcs.getNewCashAccntId());
        page.setSecurityId(pageCcs.getSecurityId());
        this.query((HisQueryPage<ObExecution>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<ObExecution>)page);
        }
        return page;
    }

    public List<Execution> getList() {
        return this.list;
    }

    public void setList(List<Execution> list) {
        this.list = list;
    }
}

