/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.trade.IDealHisQueryApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.CcsDealSum;
import cms.tmx.entity.trade.Deal;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.query.history.ICcsDealHisService;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsDealHisServiceImpl
implements ICcsDealHisService {
    @Inject
    protected IDealHisQueryApi<CcsDeal> dealHisQueryApi;
    @Inject
    protected IDealHisQueryApi<CcsDealSum> dealSumHisQueryApi;
    @Inject
    protected MObjFactory of;
    @Inject
    protected QueryModel model;
    @Inject
    private DealFactory factory;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;

    @Override
    public void query(HisQueryPage<CcsDeal> queryPage) throws MException {
        LinkedList<CcsDeal> list = new LinkedList<CcsDeal>();
        List listInfo = this.dealHisQueryApi.queryHisDeals(queryPage, Integer.valueOf(0));
        for (POrderService.Execution info : listInfo) {
            Deal deal = this.factory.create(info);
            deal.update((Object)info);
            if (!(deal instanceof CcsDeal)) continue;
            CcsDeal ccsDeal = (CcsDeal)CcsDeal.class.cast(deal);
            this.model.afterUpdate(ccsDeal);
            this.model.getDealPrice((Deal)ccsDeal);
            list.add(ccsDeal);
        }
        queryPage.updateData(list);
    }

    @Override
    public void queryDealSum(HisQueryPage<CcsDealSum> queryPage) throws MException {
        LinkedList<CcsDealSum> list = new LinkedList<CcsDealSum>();
        List listInfo = this.dealSumHisQueryApi.queryHisDealsSum(queryPage, Integer.valueOf(0));
        for (PAssetService.ExecutionsCollect info : listInfo) {
            Deal deal = this.factory.create(info);
            deal.update((Object)info);
            if (!queryPage.isInverval()) {
                deal.setSumDate(String.valueOf(queryPage.getBeginDate()) + "-" + queryPage.getEndDate());
            }
            if (!(deal instanceof CcsDealSum)) continue;
            CcsDealSum ccsDeal = (CcsDealSum)CcsDealSum.class.cast(deal);
            this.model.afterUpdateSum((CcsDeal)ccsDeal);
            ccsDeal.setIncurredAmt(this.getIncurredAmt(ccsDeal));
            ccsDeal.setAccntGrpName(this.assetGrpMng.getCacheAsset(ccsDeal.getAccntGrpName()));
            ccsDeal.setPortGrpName(this.assetGrpMng.getCacheAsset(ccsDeal.getPortGrpName().split("_")[0]));
            list.add(ccsDeal);
        }
        queryPage.updateData(list);
    }

    private double getIncurredAmt(CcsDealSum ccsDeal) {
        double amt = 0.0;
        int side = StringUtils.parseInt((String)ccsDeal.getSide().getRaw());
        switch (side) {
            case 49: 
            case 71: 
            case 80: 
            case 83: 
            case 201: {
                amt = ccsDeal.getDoneAmount() + ccsDeal.getRealFee();
                break;
            }
            default: {
                amt = ccsDeal.getDoneAmount() - ccsDeal.getRealFee();
            }
        }
        return amt;
    }

    @Override
    public void queryAlgoDeal(HisQueryPage<CcsDeal> param) throws MException {
        LinkedList<CcsDeal> list = new LinkedList<CcsDeal>();
        List listInfo = this.dealHisQueryApi.queryAlgoDeals(param);
        for (POrderService.Execution info : listInfo) {
            Deal deal = this.factory.create(info);
            deal.update((Object)info);
            if (!(deal instanceof CcsDeal)) continue;
            CcsDeal ccsDeal = (CcsDeal)CcsDeal.class.cast(deal);
            this.model.afterUpdate(ccsDeal);
            list.add(ccsDeal);
        }
        param.updateData(list);
    }

    @Override
    public HisQueryPage<CcsDeal> getAllCcsData(HisQueryPage<CcsDeal> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setExtAccntIdList(pageCcs.getExtAccntIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setAssetGrpIdList(pageCcs.getAssetGrpIdList());
        page.setAssetsGrpIdList(pageCcs.getAssetsGrpIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        this.query((HisQueryPage<CcsDeal>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(100);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<CcsDeal>)page);
        }
        return page;
    }

    @Override
    public HisQueryPage<CcsDealSum> getAllCcsSumData(HisQueryPage<CcsDealSum> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setExtAccntIdList(pageCcs.getExtAccntIdList());
        page.setPortfolioIdList(pageCcs.getPortfolioIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setAssetGrpIdList(pageCcs.getAssetGrpIdList());
        page.setAssetsGrpIdList(pageCcs.getAssetsGrpIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        page.setInverval(pageCcs.isInverval());
        this.queryDealSum((HisQueryPage<CcsDealSum>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.queryDealSum((HisQueryPage<CcsDealSum>)page);
        }
        return page;
    }
}

