/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.trade.IBasketHisQueryApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.factory.BasketCcsOrderFactory;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.query.history.ICcsBasketHisService;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsBasketHisServiceImpl
implements ICcsBasketHisService {
    @Inject
    protected BasketCcsOrderFactory bskOrderFactory;
    @Inject
    private QueryModel updateModel;
    @Inject
    private IBasketHisQueryApi<BasketCcsOrder> basketHisQuery;

    @Override
    public void query(HisQueryPage<BasketCcsOrder> orderPage) throws MException {
        LinkedList<BasketCcsOrder> list = new LinkedList<BasketCcsOrder>();
        List listInfo = this.basketHisQuery.queryHisListOrders(orderPage, Integer.valueOf(0));
        for (POrderService.ListOrder info : listInfo) {
            BasketCcsOrder order = this.bskOrderFactory.create();
            order.update(info);
            this.transferBatchField(order);
            list.add((BasketCcsOrder)BasketCcsOrder.class.cast(order));
        }
        orderPage.updateData(list);
    }

    private void transferBatchField(BasketCcsOrder batchOrder) {
        this.afterUpdateAcc(batchOrder);
        this.updateModel.afterUpdatePort(batchOrder);
    }

    private void transferLegField(BasketCcsOrder legOrder) {
        this.afterUpdateSec(legOrder);
        String errorInfo = "";
        if (!StringUtils.isEmpty((String)legOrder.getErrorInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u4e0b\u5355\u9519\u8bef\uff08" + legOrder.getErrorInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)legOrder.getWthErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u64a4\u5355\u9519\u8bef\uff08" + legOrder.getWthErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)legOrder.getRiskDetail())) {
            errorInfo = String.valueOf(errorInfo) + "\u98ce\u63a7\u4fe1\u606f\uff08" + legOrder.getRiskDetail() + "\uff09";
        }
        legOrder.setErrorInfo(errorInfo);
    }

    private synchronized void afterUpdateAcc(BasketCcsOrder order) {
        this.updateModel.afterUpdateAcc(order);
        this.updateModel.getBasketPrice(order);
    }

    private synchronized void afterUpdateSec(BasketCcsOrder order) {
        this.updateModel.afterUpdateSec(order);
        this.updateModel.getBasketPrice(order);
    }

    @Override
    public void queryDetail(HisQueryPage<BasketCcsOrder> orderPage) throws MException {
        List detailList = (List)orderPage.getMapDetailList().get(orderPage.getQuery());
        if (detailList != null && !detailList.isEmpty()) {
            orderPage.updateDetail(detailList);
            return;
        }
        LinkedList<BasketCcsOrder> list = new LinkedList<BasketCcsOrder>();
        List listInfo = this.basketHisQuery.queryHisLegOrders(((BasketCcsOrder)orderPage.getQuery()).getListId(), ((BasketCcsOrder)orderPage.getQuery()).getOrdDate(), null);
        for (POrderService.ListOrderLeg info : listInfo) {
            BasketCcsOrder order = this.bskOrderFactory.create();
            order.update((Object)info);
            this.transferLegField(order);
            list.add((BasketCcsOrder)BasketCcsOrder.class.cast(order));
        }
        orderPage.getMapDetailList().put((BasketCcsOrder)orderPage.getQuery(), list);
        orderPage.updateDetail(list);
    }

    @Override
    public HisQueryPage<BasketCcsOrder> getAllCcsData(HisQueryPage<BasketCcsOrder> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setExtAccntIdList(pageCcs.getExtAccntIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        this.query((HisQueryPage<BasketCcsOrder>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<BasketCcsOrder>)page);
        }
        return page;
    }
}

