/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.futures.dto.ArbitrageContract;
import cms.tmx.query.history.IArbitrageService;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ArbitrageServiceImpl
extends HttpService
implements IArbitrageService {
    private Gson gson = new Gson();

    @PostConstruct
    protected void init() {
        super.init();
    }

    @Override
    public List<ArbitrageContract> getArbitrageContracts(String userId, String pageNum, String pageSize) throws MException {
        LinkedList<ArbitrageContract> contractList = new LinkedList<ArbitrageContract>();
        try {
            JsonArray dataList = null;
            String respBody = this.doGet(String.valueOf(this.url) + "/v1/strategy/arbitrage/list?userId=" + userId);
            if (StringUtils.isEmpty((String)respBody)) {
                return contractList;
            }
            JsonObject jsonObject = new JsonParser().parse(respBody).getAsJsonObject();
            JsonObject jsonData = jsonObject.getAsJsonObject("res");
            if (jsonData == null) {
                return contractList;
            }
            dataList = jsonData.getAsJsonArray("list");
            for (JsonElement item : dataList) {
                ArbitrageContract detail = (ArbitrageContract)this.gson.fromJson(item.toString(), ArbitrageContract.class);
                contractList.add(detail);
            }
            if (!"200".equals(jsonObject.getAsJsonPrimitive("code").getAsString())) {
                throw new MException(-1, "\u67e5\u8be2\u5957\u5229\u5408\u7ea6\u6570\u636e\u5f02\u5e38");
            }
        }
        catch (MException e) {
            e.printStackTrace();
        }
        return contractList;
    }
}

