/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.basket.AlgoStrategyDetails;
import cms.tmx.entity.trade.basket.BasketAlgoStrategy;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.models.AlgoHisQueryModel;
import cms.tmx.query.history.models.PageModel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AlgoStrategyHisQueryModel
extends AlgoHisQueryModel {
    private PageModel<BasketAlgoStrategy> pageModel;
    private ObservableList<AlgoStrategyDetails> listDetails = FxUtils.newList();
    public BooleanProperty changedDetails = new SimpleBooleanProperty();
    private BasketAlgoStrategy strategy;
    @Inject
    private AlgoMiseMng miseMng;
    @Inject
    protected ExecutorService exe;
    @Inject
    private PortfolioAccountModel portfMng;

    public void query(List<String> list, String start, String end) {
        CountDownLatch latch = new CountDownLatch(list.size());
        LinkedList buffer = new LinkedList();
        for (String id : list) {
            this.exe.execute(() -> {
                try {
                    try {
                        List<BasketAlgoStrategy> resp = this.miseMng.queryAlgo(id, start, end);
                        buffer.addAll(resp);
                    }
                    catch (MException e) {
                        this.logger.error((Object)e);
                        latch.countDown();
                    }
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e);
        }
        buffer.sort((o1, o2) -> o2.getId().compareTo(o1.getId()));
        for (BasketAlgoStrategy data : buffer) {
            if (data.getBizAcct().startsWith("SF")) {
                String name = this.portfMng.getFundAccount(data.getBizAcct(), "CCS").getPortfolioName();
                data.setBeLong(name);
                continue;
            }
            data.setBeLong((String)data.bizAcctProperty().get());
        }
        this.pageModel.getList().setAll(buffer);
        this.changed();
    }

    public void setHisBase(BasketAlgoStrategy hisBase) {
        this.strategy = hisBase;
        String date = "";
        String id = "";
        if (hisBase != null) {
            date = hisBase.getOrderDate();
            id = hisBase.getId();
        }
        this.setBeginDate(this.hisOrder, date, id);
        this.setBeginDate(this.hisDeal, date, id);
    }

    public BasketAlgoStrategy getHisBase() {
        return this.strategy;
    }

    @Override
    public void setHisBase(AlgoBaseOrder hisBase) {
    }

    public void queryDeatail() {
        this.exe.execute(() -> {
            try {
                String accnt = this.strategy.getBizAcct();
                String data = this.strategy.getOrderDate();
                String id = this.strategy.getId();
                List<AlgoStrategyDetails> list = this.miseMng.queryAlgoDetail(accnt, data, data, id);
                ObservableList<AlgoStrategyDetails> observableList = this.listDetails;
                synchronized (observableList) {
                    this.listDetails.setAll(list);
                    this.changedDetails();
                }
            }
            catch (MException e) {
                this.logger.error((Object)e, (Throwable)e);
            }
        });
    }

    public PageModel<BasketAlgoStrategy> initPageModel() {
        this.pageModel = new PageModel();
        return this.pageModel;
    }

    public ObservableList<AlgoStrategyDetails> getListDeatils() {
        return this.listDetails;
    }

    public BooleanProperty changedDetailsProperty() {
        return this.changedDetails;
    }

    public void changedDetails() {
        this.changedDetails.set(!this.changedDetails.get());
    }
}

