/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.trade.IAlgorithmTradeApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.utils.QueryModel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoHisService
extends MxModel {
    private static final Logger logger = LogManager.getLogger(AlgoHisService.class);
    @Inject
    private IAlgorithmTradeApi algoApi;
    @Inject
    private QueryModel queryModel;
    @Inject
    private AlgoMiseMng miseMng;
    @Inject
    @Named(value="fixed.query.pool")
    private ExecutorService exe;
    public List<AlgoBaseOrder> bskList = new ArrayList<AlgoBaseOrder>();

    public void query(HisQueryPage<AlgoBaseOrder> pageInfo) throws MException {
        List listInfo = this.algoApi.queryHisAlgo(pageInfo);
        LinkedList list = new LinkedList();
        listInfo.forEach(info -> {
            AlgoBaseOrder algo = new AlgoBaseOrder();
            algo.update(info);
            this.queryModel.afterUpdate(algo);
            list.add(algo);
        });
        pageInfo.updateData(list);
    }

    public void queryHisBskAlgo(HisQueryPage<AlgoBaseOrder> param, String bskName) {
        this.exe.execute(() -> {
            int size = 0;
            size = param.getDimension().equals("1") ? param.getExtAccntIdList().size() : param.getSubAccntIdList().size();
            CountDownLatch latch = new CountDownLatch(size);
            CopyOnWriteArrayList listEvent = new CopyOnWriteArrayList();
            if (param.getDimension().equals("1")) {
                for (String item2 : param.getExtAccntIdList()) {
                    this.exe.execute(() -> {
                        try {
                            try {
                                List<MEvent> re = this.miseMng.queryAlgoMevent(item2.substring(0, item2.indexOf("_")), param.getBeginDate(), param.getEndDate());
                                listEvent.addAll(re);
                            }
                            catch (MException e) {
                                logger.error((Object)e, (Throwable)e);
                                latch.countDown();
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
            } else {
                for (String item2 : param.getSubAccntIdList()) {
                    this.exe.execute(() -> {
                        try {
                            try {
                                List<MEvent> re = this.miseMng.queryAlgoMevent(item2, param.getBeginDate(), param.getEndDate());
                                listEvent.addAll(re);
                            }
                            catch (MException e) {
                                logger.error((Object)e, (Throwable)e);
                                latch.countDown();
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error((Object)e, (Throwable)e);
            }
            ArrayList<AlgoBaseOrder> tempList = new ArrayList<AlgoBaseOrder>();
            tempList.clear();
            for (MEvent event : listEvent) {
                AlgoBaseOrder baseOrder = new AlgoBaseOrder();
                try {
                    baseOrder.update((Object)event);
                }
                catch (Exception exception) {}
                if (baseOrder.getType().getRaw().isEmpty()) continue;
                tempList.add(baseOrder);
                this.miseMng.afterUpdate(baseOrder);
            }
            Stream<AlgoBaseOrder> filter = tempList.stream().filter(item -> item.getName().contains(bskName));
            this.bskList = filter.collect(Collectors.toList());
            this.changed();
        });
    }

    public List<AlgoBaseOrder> getAllCcsData(HisQueryPage<AlgoBaseOrder> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setExtAccntIdList(pageCcs.getExtAccntIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setSubAccntIdList(pageCcs.getSubAccntIdList());
        page.setSecurityId(pageCcs.getSecurityId());
        this.query((HisQueryPage<AlgoBaseOrder>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<AlgoBaseOrder>)page);
        }
        return page.getDataList();
    }
}

