/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.history.ICcsDealHisService;
import cms.tmx.query.history.ICcsOrderHisService;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AlgoHisQueryModel
extends MxModel {
    protected HisQueryPage<CcsOrder> hisOrder = new HisQueryPage();
    protected HisQueryPage<CcsDeal> hisDeal = new HisQueryPage();
    public BooleanProperty changedOrder = new SimpleBooleanProperty();
    public BooleanProperty changedDeal = new SimpleBooleanProperty();
    private ObjectProperty<AlgoBaseOrder> hisBase = new SimpleObjectProperty();
    @Inject
    private ICcsOrderHisService hisOrderService;
    @Inject
    private ICcsDealHisService hisDealService;

    @PostConstruct
    public void init() {
        this.hisOrder.setMarketGrp("CCS");
        this.hisOrder.setDimension("1");
        this.hisDeal.setMarketGrp("CCS");
        this.hisDeal.setDimension("1");
    }

    public synchronized void queryHisOrder() throws MException {
        this.hisOrderService.queryAlgoOrder(this.hisOrder);
        this.changedOrder();
    }

    public synchronized void queryHisDeal() throws MException {
        this.hisDealService.queryAlgoDeal(this.hisDeal);
        this.changedDeal();
    }

    public HisQueryPage<CcsOrder> getHisOrder() {
        return this.hisOrder;
    }

    public HisQueryPage<CcsDeal> getHisDeal() {
        return this.hisDeal;
    }

    public void setHisBase(AlgoBaseOrder hisBase) {
        String date = "";
        String id = "";
        this.hisBase.set(null);
        if (hisBase != null) {
            this.hisBase.set((Object)hisBase);
            date = hisBase.getOrderDate();
            id = AlgoMiseMng.isMise(hisBase.getType().getRaw()) ? hisBase.getBaseId() : String.valueOf(hisBase.getBaseId()) + "_" + hisBase.getId();
        }
        this.setBeginDate(this.hisOrder, date, id);
        this.setBeginDate(this.hisDeal, date, id);
    }

    public void setBeginDate(HisQueryPage<?> page, String date, String id) {
        page.setBeginDate(date);
        page.setEndDate(date);
        page.setId(id);
    }

    public void setEndDate(String end) {
        this.hisOrder.setEndDate(end);
        this.hisDeal.setEndDate(end);
    }

    public List<CcsOrder> getListOrder() {
        return this.hisOrder.getDataList();
    }

    public List<CcsDeal> getListDeal() {
        return this.hisDeal.getDataList();
    }

    public BooleanProperty changedOrderProperty() {
        return this.changedOrder;
    }

    public void changedOrder() {
        this.changedOrder.set(!this.changedOrder.get());
    }

    public BooleanProperty changedDealProperty() {
        return this.changedDeal;
    }

    public void changedDeal() {
        this.changedDeal.set(!this.changedDeal.get());
    }

    public AlgoBaseOrder getBaseOrder() {
        return (AlgoBaseOrder)this.hisBase.get();
    }

    public final ObjectProperty<AlgoBaseOrder> hisBaseProperty() {
        return this.hisBase;
    }
}

