/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ReconcileInfo;
import cms.tmx.query.history.IAccountStatService;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AccountStatServiceImpl
implements IAccountStatService {
    @Inject
    private static HttpClientService httpClient;
    @Inject
    private IBaseApi bmi;
    private Gson gson = new Gson();

    @Override
    public List<ReconcileInfo> query(String id, String date, String pageNum, String pageSize) throws MException {
        LinkedList<ReconcileInfo> infoList = new LinkedList<ReconcileInfo>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("beginDate", date);
        param.put("endDate", date);
        param.put("pageNum", pageNum);
        param.put("pageSize", pageSize);
        param.put("type", "1");
        param.put("id", id);
        param.put("cms_s_token", this.bmi.getToken());
        String url = "/accountStat/info";
        try {
            String respUrl = httpClient.doGet(url, param, true);
            JsonArray dataList = null;
            JsonObject jsonObject = new JsonParser().parse(respUrl).getAsJsonObject();
            JsonObject jsonData = jsonObject.getAsJsonObject("res");
            dataList = jsonData.getAsJsonArray("list");
            for (JsonElement item : dataList) {
                ReconcileInfo reInfo = (ReconcileInfo)this.gson.fromJson(item.toString(), ReconcileInfo.class);
                infoList.add(reInfo);
            }
            if (!"200".equals(jsonObject.getAsJsonPrimitive("code").getAsString())) {
                throw new MException(-1, "\u67e5\u8be2\u5bf9\u8d26\u5355\u6570\u636e\u5f02\u5e38");
            }
        }
        catch (MException e) {
            e.printStackTrace();
        }
        return infoList;
    }
}

