/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.query.mail.AccntEmail;
import cms.tmx.http.query.mail.GetAccntEmailReq;
import cms.tmx.http.query.mail.GetAccntEmailUploadReq;
import cms.tmx.query.history.IAccntEmailService;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AccntEmailServiceImpl
implements IAccntEmailService {
    @Inject
    private static HttpClientService httpClient;
    @Inject
    private IBaseApi bmi;
    private Gson gson = new Gson();
    @Inject
    private MConfService ms;
    StringBuffer stringBuffer = null;

    @Override
    public void querySendListInTurn(IPageInTurn<String, String, AccntEmail> page) throws MException {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        LinkedList<AccntEmail> detailList = new LinkedList<AccntEmail>();
        String url = "/send/list";
        this.stringBuffer = new StringBuffer(this.ms.getValue("web.domain"));
        this.stringBuffer.append("api").append(url).append("?cms_s_token=" + this.bmi.getToken());
        String respUrl = httpClient.doGetWithUrl(this.stringBuffer.toString(), null);
        JsonArray dataList = null;
        if (respUrl == null) {
            throw new MException(-1, "\u67e5\u8be2\u90ae\u7bb1\u5931\u8d25");
        }
        JsonObject jsonObject = new JsonParser().parse(respUrl).getAsJsonObject();
        dataList = jsonObject.getAsJsonArray("res");
        for (JsonElement item : dataList) {
            AccntEmail detail = (AccntEmail)this.gson.fromJson(item.toString(), AccntEmail.class);
            detailList.add(detail);
        }
        if (!"200".equals(jsonObject.getAsJsonPrimitive("code").getAsString())) {
            throw new MException(-1, "\u67e5\u8be2\u90ae\u7bb1\u5931\u8d25");
        }
        page.getResList().addAll(detailList);
        int size = detailList.size();
        if (size == 0) {
            return;
        }
    }

    @Override
    public void updateSendListInTurn(List<AccntEmail> list) throws MException {
        GetAccntEmailReq request = new GetAccntEmailReq();
        request.setAccntEmailList(list);
        String body = this.gson.toJson((Object)request);
        String url = "/send/saveOrUpdate";
        this.stringBuffer = new StringBuffer(this.ms.getValue("web.domain"));
        this.stringBuffer.append("api").append(url).append("?cms_s_token=" + this.bmi.getToken());
        String respUrl = httpClient.doPostJson2(this.stringBuffer.toString(), body);
        if (respUrl == null) {
            throw new MException(-1, "\u66f4\u65b0\u90ae\u7bb1\u5931\u8d25");
        }
        JsonObject jsonObject = new JsonParser().parse(respUrl).getAsJsonObject();
        if (!"200".equals(jsonObject.getAsJsonPrimitive("code").getAsString())) {
            throw new MException(-1, "\u66f4\u65b0\u90ae\u7bb1\u5931\u8d25");
        }
    }

    @Override
    public void uploadSendListInTurn(byte[] data, FundAccount fund) throws MException {
        GetAccntEmailUploadReq request = new GetAccntEmailUploadReq();
        request.setInvestorId(fund.getInvestId());
        request.setMailAddress(fund.getEmail());
        request.setData(data);
        String body = this.gson.toJson((Object)request);
        String url = "/mail/upload";
        this.stringBuffer = new StringBuffer(this.ms.getValue("web.domain"));
        this.stringBuffer.append("api").append(url).append("?cms_s_token=" + this.bmi.getToken());
        String respUrl = httpClient.doPostJson2(this.stringBuffer.toString(), body);
        if (respUrl == null) {
            throw new MException(-1, "\u53d1\u9001\u90ae\u7bb1\u5931\u8d25");
        }
        JsonObject jsonObject = new JsonParser().parse(respUrl).getAsJsonObject();
        if (!"200".equals(jsonObject.getAsJsonPrimitive("code").getAsString())) {
            throw new MException(-1, "\u53d1\u9001\u90ae\u7bb1\u5931\u8d25");
        }
    }
}

