/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.sge;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.query.sge.ObSgeStorage;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.sge.SgeStorageModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SgeStoragePart
extends MxPart {
    @FXML
    private TableView<ObSgeStorage> tableStorage;
    @FXML
    private TableColumn<ObSgeStorage, String> investorId;
    @FXML
    private TableColumn<ObSgeStorage, String> secId;
    @FXML
    private TableColumn<ObSgeStorage, String> secName;
    @FXML
    private TableColumn<ObSgeStorage, Number> balance;
    @FXML
    private TableColumn<ObSgeStorage, Number> available;
    @FXML
    private TableColumn<ObSgeStorage, Number> frozenQty;
    @FXML
    private TableColumn<ObSgeStorage, Number> impawnIn;
    @FXML
    private TableColumn<ObSgeStorage, Number> takeOut;
    @FXML
    private TableColumn<ObSgeStorage, Number> lawFrozen;
    @FXML
    private TableColumn<ObSgeStorage, Number> pledge;
    @FXML
    private TableColumn<ObSgeStorage, Number> transOut;
    @FXML
    private TextField searchText;
    @Inject
    private SgeStorageModel model;
    private static final Logger logger = LogManager.getLogger(SgeStoragePart.class);
    @Inject
    private MxAlert alert;
    private MxList<ObSgeStorage> mxList = new MxList();
    private Predicate<ObSgeStorage> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObSgeStorage)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text) || en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        return this.extend((ObSgeStorage)en);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener lstnSearch = ob -> {
        ObservableList<ObSgeStorage> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
    };

    public boolean premise(ObSgeStorage cash) {
        return true;
    }

    public boolean extend(ObSgeStorage cash) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<ObSgeStorage> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObSgeStorage> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObSgeStorage>)this.model.getList());
        }
        this.mxList.update(newList, this.pd);
        Platform.runLater(() -> this.tableStorage.sort());
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableStorage);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableStorage, (String)"\u8d35\u91d1\u5c5e\u5e93\u5b58\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTable() {
        this.investorId.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).investorIdProperty());
        this.secId.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).getInstrument().secIdProperty());
        this.secName.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).getInstrument().symbolProperty());
        this.balance.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).balanceProperty());
        this.balance.setCellFactory(data -> new DoubleTableCell());
        this.available.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).availableProperty());
        this.available.setCellFactory(data -> new DoubleTableCell());
        this.frozenQty.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).frozenQtyProperty());
        this.impawnIn.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).impawnInProperty());
        this.takeOut.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).takeOutProperty());
        this.lawFrozen.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).lawFrozenProperty());
        this.pledge.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).pledgeProperty());
        this.transOut.setCellValueFactory(data -> ((ObSgeStorage)data.getValue()).transOutProperty());
        this.tableStorage.setItems(this.mxList.getList());
        this.tableStorage.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableStorage);
    }
}

