/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.sge;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.http.query.sge.ObSgePosition;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.FutureCancelEntrust;
import cms.tmx.query.current.models.FutureCancelFactory;
import cms.tmx.query.current.models.sge.SgePositionModel;
import cms.tmx.query.current.views.FutureReplaceConfirmDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class SgePositionPart
extends MxPart {
    @FXML
    private TableView<ObSgePosition> tablePosition;
    @FXML
    private TableColumn<ObSgePosition, String> investorId;
    @FXML
    private TableColumn<ObSgePosition, String> secId;
    @FXML
    private TableColumn<ObSgePosition, String> secName;
    @FXML
    private TableColumn<ObSgePosition, Number> holdCostAmount;
    @FXML
    private TableColumn<ObSgePosition, Number> balance;
    @FXML
    private TableColumn<ObSgePosition, Number> available;
    @FXML
    private TableColumn<ObSgePosition, String> dire;
    @FXML
    private TableColumn<ObSgePosition, Number> lastPx;
    @FXML
    private TableColumn<ObSgePosition, Number> realizedPnl;
    @FXML
    private TableColumn<ObSgePosition, Number> cost;
    @FXML
    private TableColumn<ObSgePosition, Number> profit;
    @FXML
    private TableColumn<ObSgePosition, Number> margin;
    @FXML
    private TableColumn<ObSgePosition, Number> tdBalance;
    @FXML
    private TableColumn<ObSgePosition, Number> ydBalance;
    @FXML
    private TextField searchText;
    @Inject
    private SgePositionModel model;
    private static final Logger logger = LogManager.getLogger(SgePositionPart.class);
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private FutureCancelFactory cf;
    @Inject
    private DialogFactory df;
    private MxList<ObSgePosition> mxList = new MxList();
    private Predicate<ObSgePosition> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObSgePosition)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        return this.extend((ObSgePosition)en);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener listenerSearch = ob -> {
        ObservableList<ObSgePosition> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
    };

    public boolean premise(ObSgePosition ob) {
        return true;
    }

    public boolean extend(ObSgePosition obj) {
        return false;
    }

    @Focus
    public void onFocus() {
        this.tablePosition.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<ObSgePosition> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObSgePosition> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObSgePosition>)this.model.getList());
        }
        this.mxList.update(newList, this.pd);
        Platform.runLater(() -> this.tablePosition.sort());
    }

    @FXML
    public void initialize() {
        this.listener();
        this.click();
        this.createTable();
        this.refresh();
        this.onFocus();
    }

    private void click() {
        this.tablePosition.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            ObSgePosition pos;
            if (event.getClickCount() == 2 && (pos = (ObSgePosition)this.tablePosition.getSelectionModel().getSelectedItem()) != null) {
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)pos.getInstrument().getSecId());
                eCall.putStr("sec_type", (Object)pos.getInstrument().getSecType());
                eCall.put((Object)"count", (Object)Math.round(pos.getAvailable()));
                eCall.put((Object)"parent_id", (Object)this.p.getParent().getParent().getId());
                eCall.put((Object)"side_sell", (Object)pos.getDirection());
                eCall.put((Object)"secAccount", (Object)pos.getSecAccntId());
                eCall.put((Object)"tMarket", (Object)pos.getInstrument().getMarket().getRaw());
                this.es.sendEvent("ctpTradePanelSetCode", eCall);
            }
        });
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.listenerSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.listenerSearch);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u8d35\u91d1\u5c5e\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTable() {
        this.investorId.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).investorIdProperty());
        this.secId.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).getInstrument().secIdProperty());
        this.secName.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).getInstrument().symbolProperty());
        this.holdCostAmount.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).holdCostAmountProperty());
        this.holdCostAmount.setCellFactory(data -> new DoubleTableCell());
        this.balance.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).balanceProperty());
        this.balance.setCellFactory(data -> new DoubleTableCell());
        this.available.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).availableProperty());
        this.available.setCellFactory(data -> new DoubleTableCell());
        this.dire.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).direProperty());
        this.dire.setCellFactory(cell -> new SideCell());
        this.lastPx.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).lastPxProperty());
        this.lastPx.setCellFactory(data -> new DoubleTableCell(3));
        this.realizedPnl.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).realizedPnlProperty());
        this.realizedPnl.setCellFactory(data -> new DoubleTableCell());
        this.cost.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).costProperty());
        this.cost.setCellFactory(data -> new DoubleTableCell(3));
        this.profit.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).profitProperty());
        this.profit.setCellFactory(data -> new DoubleTableCell());
        this.margin.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).marginProperty());
        this.margin.setCellFactory(data -> new DoubleTableCell());
        this.tdBalance.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).tdBalanceProperty());
        this.tdBalance.setCellFactory(data -> new DoubleTableCell());
        this.ydBalance.setCellValueFactory(data -> ((ObSgePosition)data.getValue()).ydBalanceProperty());
        this.ydBalance.setCellFactory(data -> new DoubleTableCell());
        this.tablePosition.setItems(this.mxList.getList());
        this.tablePosition.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    @FXML
    public void closePosi() {
        ObSgePosition position = (ObSgePosition)this.tablePosition.getSelectionModel().getSelectedItem();
        if (position == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u5e73\u4ed3");
            return;
        }
        if (position.getAvailable() == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u53ef\u5e73\u6570\u91cf\u4e3a0\uff0c\u65e0\u6cd5\u5e73\u4ed3");
            return;
        }
        LinkedList<ObSgePosition> posList = new LinkedList<ObSgePosition>();
        posList.add(position);
        if (this.createDialog(posList)) {
            return;
        }
        MEvent event = this.model.close(position);
        int countSuc = event.getInt("suc.count");
        if (countSuc == 1) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5e73\u4ed3\u63d0\u4ea4\u6210\u529f");
        } else {
            this.alert.alert(Alert.AlertType.ERROR, event.getDesc());
        }
    }

    @FXML
    public void clearPosi() {
        if (this.tablePosition.getItems().size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6e05\u4ed3\u5931\u8d25\uff1a\n\u8868\u683c\u4e2d\u6ca1\u6709\u6570\u636e\uff01");
            return;
        }
        FilteredList posList = this.tablePosition.getItems().filtered(pos -> pos.getAvailable() > 0.0);
        if (posList.size() == 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u65e0\u53ef\u6e05\u4ed3\u6570\u636e");
            return;
        }
        if (this.createDialog((List<ObSgePosition>)posList)) {
            return;
        }
        this.exe.execute(() -> this.lambda$31((ObservableList)posList));
    }

    private boolean createDialog(List<ObSgePosition> posList) {
        FutureReplaceConfirmDialog obj = (FutureReplaceConfirmDialog)((Object)this.of.create(FutureReplaceConfirmDialog.class));
        LinkedList<FutureCancelEntrust> enList = new LinkedList<FutureCancelEntrust>();
        this.model.queryMarketItem(posList);
        for (ObSgePosition po : posList) {
            FutureCancelEntrust en = this.cf.createSingle(po.getInvestorId(), po.getInvestorSecId());
            en.setSec(po.getInstrument().getSecId());
            en.setSecName(po.getInstrument().getSymbol());
            en.setAcc(po.getInvestorId());
            en.setSecAcc(po.getInvestorSecId());
            en.setSecType(po.getInstrument().getSecType());
            en.setMarket(po.getInstrument().getMarket().getRaw());
            en.setOrderType(50);
            en.setQuantity(Math.round(po.getAvailable()));
            if ("1".equals(Integer.toString(po.getDirection()))) {
                en.setSide(MxNodeFactory.create((String)"side", (String)Integer.toString(50)));
            } else if ("2".equals(Integer.toString(po.getDirection()))) {
                en.setSide(MxNodeFactory.create((String)"side", (String)Integer.toString(49)));
            }
            try {
                en.setPrice(this.model.getNewPrice(po));
                po.setNewPrice(en.getPrice());
            }
            catch (MException e) {
                en.setTip("\u884c\u60c5\u83b7\u53d6\u5931\u8d25\uff0c\u4e0d\u4e0b\u5355");
                logger.error("\u5e73\u4ed3\u83b7\u53d6\u884c\u60c5\u5931\u8d25", (Throwable)e);
            }
            enList.add(en);
        }
        obj.setSge(true);
        obj.setList(enList);
        obj.setDialogType("\u5e73\u4ed3");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64cd\u4f5c\u786e\u8ba4");
        return dialog.launch() != ButtonType.OK;
    }

    private void clear(List<ObSgePosition> list) {
        MEvent event = this.model.clear(list);
        Platform.runLater(() -> this.alert.alert(Alert.AlertType.INFORMATION, "\u6e05\u4ed3\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14"));
    }

    private /* synthetic */ void lambda$31(ObservableList observableList) {
        this.clear((List<ObSgePosition>)observableList);
    }

    private class SideCell
    extends TableCell<ObSgePosition, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            switch (value) {
                case "\u4e70": {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                case "\u5356": {
                    this.label.setText("    " + value);
                    CssUtils.makeFall((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

