/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.sge;

import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.SgeRefItem;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.current.models.sge.SgeContractModel;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class SgeContractPart
extends MxPagePart<RefItem, SgeRefItem> {
    @FXML
    private TableColumn<SgeRefItem, String> code;
    @FXML
    private TableColumn<SgeRefItem, String> name;
    @FXML
    private TableColumn<SgeRefItem, String> market;
    @FXML
    private TableColumn<SgeRefItem, String> currency;
    @FXML
    private TableColumn<SgeRefItem, String> deliveryMethod;
    @FXML
    private TableColumn<SgeRefItem, Number> tradeUnit;
    @FXML
    private TableColumn<SgeRefItem, String> quoteUnit;
    @FXML
    private TableColumn<SgeRefItem, String> deliveryVarity;
    @FXML
    private TableColumn<SgeRefItem, Number> priceTick;
    @FXML
    private TableColumn<SgeRefItem, Number> maxOrderAmt;
    @FXML
    private TableColumn<SgeRefItem, Number> minOrderAmt;
    @FXML
    private TableColumn<SgeRefItem, Number> limitUpPrice;
    @FXML
    private TableColumn<SgeRefItem, Number> limitDownPrice;
    @FXML
    protected TextField searchText;
    @Inject
    private SgeContractModel model;
    protected InvalidationListener lstnSearch = ob -> {
        List<RefItem> list = this.getModel().getList();
        synchronized (list) {
            this.mxList.filter(this.getModel().getList(), this.pd);
        }
        this.sort();
        this.mxList.updatePageList();
        this.tableView.refresh();
    };

    protected void initialize() {
        super.initialize();
        this.initListener();
    }

    private void initListener() {
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void removeListener() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    protected boolean predicate(RefItem data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getCode().toUpperCase();
        String name = data.getName().toUpperCase();
        return code.contains(text) || name.contains(text);
    }

    protected List<RefItem> getList() {
        return this.model.getList();
    }

    protected SgeContractModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        this.code.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).securityIdProperty());
        this.name.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).symbolProperty());
        this.market.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).marketProperty());
        this.currency.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).currencyProperty());
        this.deliveryMethod.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).deliveryMethodProperty());
        this.tradeUnit.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).tradeUnitProperty());
        this.quoteUnit.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).quoteUnitProperty());
        this.deliveryVarity.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).deliveryVarityProperty());
        this.deliveryVarity.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).deliveryVarityProperty());
        this.priceTick.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).priceTickProperty());
        this.maxOrderAmt.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).maxOrderAmtProperty());
        this.minOrderAmt.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).minOrderAmtProperty());
        this.limitUpPrice.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).highLimitPxProperty());
        this.limitDownPrice.setCellValueFactory(data -> ((SgeRefItem)data.getValue()).lowLimitPxProperty());
        this.priceTick.setCellFactory(cell -> new DoubleTableCell());
        this.maxOrderAmt.setCellFactory(cell -> new DoubleTableCell());
        this.minOrderAmt.setCellFactory(cell -> new DoubleTableCell());
        this.limitUpPrice.setCellFactory(cell -> new DoubleTableCell());
        this.limitDownPrice.setCellFactory(cell -> new DoubleTableCell());
        this.tableView.setItems(this.mxList.getPageList());
    }

    @FXML
    protected void refresh() {
        this.getModel().query();
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel((TableView)this.tableView, (List)this.mxList.getPageList(), (String)"\u5408\u7ea6\u67e5\u8be2");
            this.logger.info("\u5408\u7ea6\u67e5\u8be2\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception exception) {
            this.logger.error("\u5408\u7ea6\u67e5\u8be2\u5bfc\u51fa\u5931\u8d25");
        }
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getPageList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getCode().compareTo(o1.getCode()));
    }
}

