/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.sge;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.query.sge.ObSgeCash;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.sge.SgeCashModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SgeCashPart
extends MxPart {
    @FXML
    private TableView<ObSgeCash> tableCash;
    @FXML
    private TableColumn<ObSgeCash, Number> available;
    @FXML
    private TableColumn<ObSgeCash, Number> frozenAmount;
    @FXML
    private TextField searchText;
    @Inject
    private SgeCashModel model;
    private static final Logger logger = LogManager.getLogger(SgeCashPart.class);
    @Inject
    private MxAlert alert;
    private MxList<ObSgeCash> mxList = new MxList();
    private Predicate<ObSgeCash> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObSgeCash)en)) {
            return false;
        }
        if (en.getInvestorId().contains(text)) {
            return true;
        }
        return this.extend((ObSgeCash)en);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener lstnSearch = ob -> {
        ObservableList<ObSgeCash> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
    };

    public boolean premise(ObSgeCash cash) {
        return true;
    }

    public boolean extend(ObSgeCash cash) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<ObSgeCash> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObSgeCash> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObSgeCash>)this.model.getList());
        }
        this.mxList.update(newList, this.pd);
        Platform.runLater(() -> this.tableCash.sort());
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCash);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableCash, (String)"\u8d35\u91d1\u5c5e\u8d26\u6237\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tableCash);
        this.available.setCellFactory(data -> new DoubleTableCell());
        this.frozenAmount.setCellFactory(data -> new DoubleTableCell());
        this.tableCash.setItems(this.mxList.getList());
        this.tableCash.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableCash);
    }
}

