/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.query.current.views.portfolio.AlgoQueryPart;
import java.io.IOException;
import java.util.List;
import javafx.fxml.FXML;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionAlgoQueryPart
extends AlgoQueryPart {
    private static final Logger logger = LogManager.getLogger(InstructionAlgoQueryPart.class);
    public Instruction instruction = null;

    public InstructionAlgoQueryPart() {
        this.path = String.valueOf(AlgoQueryPart.class.getSimpleName()) + ".fxml";
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException iOException) {}
    }

    @Override
    @FXML
    public void initialize() {
        this.checkRight();
        this.createTable();
        this.refresh();
    }

    @Override
    @FXML
    public void refresh() {
        try {
            if (this.instruction == null) {
                return;
            }
            switch (this.instruction.getStatus().getRaw()) {
                case "5": 
                case "6": 
                case "8": {
                    return;
                }
            }
            List<AlgoBaseOrder> list = this.tradeModel.queryBaseOrder(this.instruction);
            this.tradeModel.summarizingDealsInst(list);
            this.mxList.update(list, order -> this.predicate((AlgoBaseOrder)order));
            this.mxList.getList().sort((a, b) -> b.getBaseId().compareTo(a.getBaseId()));
            this.tableBase.sort();
            this.tableBase.refresh();
        }
        catch (MException e) {
            logger.error("query algo faild", (Throwable)e);
        }
    }

    @Override
    protected boolean predicate(AlgoBaseOrder order) {
        if (this.instruction.getId() == null) {
            return false;
        }
        return order.getAlgoParam().getReference().equals(this.instruction.getId());
    }
}

