/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.query.current.views.portfolio.AlgoHisQueryDialog;
import cms.tmx.query.current.views.portfolio.AlgoQueryPart;
import java.io.IOException;
import java.util.List;
import javafx.fxml.FXML;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionAlgoHisQueryPart
extends AlgoQueryPart {
    public Instruction instruction = null;

    public InstructionAlgoHisQueryPart() {
        this.path = String.valueOf(AlgoQueryPart.class.getSimpleName()) + ".fxml";
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException iOException) {}
    }

    @Override
    @FXML
    public void initialize() {
        this.createTable();
        this.refresh();
    }

    @Override
    @FXML
    public void refresh() {
        try {
            if (this.instruction == null) {
                return;
            }
            switch (this.instruction.getStatus().getRaw()) {
                case "5": 
                case "6": 
                case "8": {
                    return;
                }
            }
            List<AlgoBaseOrder> list = this.tradeModel.queryBaseOrder(this.instruction);
            this.tradeModel.summarizingDealsInst(list);
            this.mxList.update(list, order -> this.predicate((AlgoBaseOrder)order));
            this.mxList.getList().sort((a, b) -> b.getBaseId().compareTo(a.getBaseId()));
            this.tableBase.sort();
            this.tableBase.refresh();
        }
        catch (MException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void algoDetail(AlgoBaseOrder order) {
        this.tableBase.getSelectionModel().select((Object)order);
        AlgoHisQueryDialog query = (AlgoHisQueryDialog)((Object)this.of.create(AlgoHisQueryDialog.class));
        query.setOrder(order);
        MxDialog dialog = this.df.create((DialogObj)query, "\u7b97\u6cd5\u8be6\u60c5");
        dialog.launch();
    }

    @Override
    protected boolean predicate(AlgoBaseOrder order) {
        if (this.instruction.getId() == null) {
            return false;
        }
        return order.getAlgoParam().getReference().equals(this.instruction.getId());
    }
}

