/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.models.portfolio.HkwolunPortfPositionModel;
import cms.tmx.query.current.views.CcsReplaceConfirmDialog;
import cms.tmx.query.current.views.portfolio.CcsPortfPositionPart;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class HkwolunPortfPositionPart
extends MxPart {
    @FXML
    protected TextField searchText;
    @FXML
    private TableView<CcsPortfPosition> tablePosition;
    @FXML
    private TableColumn<CcsPortfPosition, String> colSecId;
    @FXML
    private TableColumn<CcsPortfPosition, String> colSecName;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colTotalVol;
    @FXML
    private TableColumn<CcsPortfPosition, String> colUnit;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colCanVol;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colCost;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colCostAmt;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colProfit;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colTotalProfit;
    @FXML
    private TableColumn<CcsPortfPosition, MxNode> colMarket;
    @FXML
    private TableColumn<CcsPortfPosition, String> colAcc;
    @FXML
    private TableColumn<CcsPortfPosition, String> colSecAcc;
    @FXML
    private TableColumn<CcsPortfPosition, String> colPortfName;
    @FXML
    private TableColumn<CcsPortfPosition, String> colPortfId;
    @FXML
    private TableColumn<CcsPortfPosition, String> colRemark;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colCapital;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colBuyCost;
    @FXML
    private TableColumn<CcsPosition, Number> colRealizedPl;
    @FXML
    private TableColumn<CcsPosition, Number> colTodayRealizedPl;
    @FXML
    private TableColumn<CcsPosition, Number> colNewPrice;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colYield;
    @FXML
    private TableColumn<CcsPortfPosition, Number> colPercent;
    @FXML
    protected MenuItem miClose;
    @FXML
    protected MenuItem miClear;
    @Inject
    private HkwolunPortfPositionModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IUiRightService rightModel;
    @Inject
    private ExecutorService exe;
    @Inject
    private MObjFactory of;
    @Inject
    private CcsCancelFactory ccf;
    @Inject
    private DialogFactory df;
    @Inject
    private ScheduledExecutorService executorService;
    private static final int DEFAULT_SECONDS = 5;
    private MxList<CcsPortfPosition> mxList = new MxList();
    private static final Logger logger = LogManager.getLogger(CcsPortfPositionPart.class);
    private Predicate<CcsPortfPosition> pd = p -> {
        String txt = this.searchText.getText().trim();
        if (p.getSecId().contains(txt)) {
            return true;
        }
        if (p.getSecName().contains(txt)) {
            return true;
        }
        return this.extend((Position)p);
    };
    protected InvalidationListener lstnModel = ob -> {
        List newList = Collections.synchronizedList(new ArrayList());
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o1.getSecId().compareTo(o2.getSecId()));
            this.tablePosition.sort();
        });
    };
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.model.getList(), this.pd);
    @Inject
    private MEventService es;

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.onFocus();
        this.check();
        this.fxmlDone = true;
        this.model.initQuery();
    }

    private void listener() {
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
    }

    @PreDestroy
    private void close() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    private void check() {
        String parentId = this.p.getParent().getParent().getId().toUpperCase();
        String unClear = "";
        String unClose = "";
        switch (parentId) {
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-BASKET-POSITION-QUERY": {
                unClose = "cms.tmx.instructions.part.portfolio.basket.position.query_close";
                unClear = "cms.tmx.instructions.part.portfolio.basket.position.query_clear";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-POSITION-QUERY": {
                unClear = "cms.tmx.instructions.part.portfolio.position.query_clear";
                unClose = "cms.tmx.instructions.part.portfolio.position.query_close";
                break;
            }
            case "CMS-TMX-INSTRUCTIONS-PART-PORTFOLIO-REPO-POSITION-QUERY": {
                unClear = "cms.tmx.instructions.part.portfolio.repo.position.query_clear";
                unClose = "cms.tmx.instructions.part.portfolio.repo.position.query_close";
                break;
            }
        }
        if (!this.rightModel.registerCheck(new String[]{unClear})) {
            this.miClear.setVisible(false);
        }
        if (!this.rightModel.registerCheck(new String[]{unClose})) {
            this.miClose.setVisible(false);
        }
    }

    @Focus
    public void onFocus() {
        this.tablePosition.refresh();
    }

    private void createTable() {
        this.tablePosition.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CcsPortfPosition pos;
            if (event.getClickCount() == 2 && (pos = (CcsPortfPosition)this.tablePosition.getSelectionModel().getSelectedItem()) != null) {
                String code = pos.getSecId();
                MEvent eCall = new MEvent();
                eCall.put((Object)"sec_code", (Object)code);
                eCall.put((Object)"count", (Object)pos.getCanVol());
                eCall.put((Object)"side_sell", (Object)(pos.getCanVol() >= 0L ? 1 : 0));
                eCall.put((Object)"portfolioId", (Object)pos.getPortfolioId());
                eCall.put((Object)"accntId", (Object)pos.getExtAccId());
                eCall.put((Object)"secAccount", (Object)pos.getExtSecAccId());
                eCall.put((Object)"tMarket", (Object)pos.getMarket().getRaw());
                this.es.sendEvent("trade.panel.set.code.portfoilio", eCall);
            }
        });
        this.colSecId.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).secNameProperty());
        this.colTotalVol.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).totalVolProperty());
        this.colTotalVol.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).unitProperty());
        this.colCanVol.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).canVolProperty());
        this.colCanVol.setCellFactory(cell -> new NumberTableCell());
        this.colCost.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).costProperty());
        this.colCost.setCellFactory(p -> new PriceCell());
        this.colCostAmt.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).costAmtProperty());
        this.colCostAmt.setCellFactory(p -> new PriceCell());
        this.colCapital.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).capitalizationProperty());
        this.colCapital.setCellFactory(p -> new PriceCell());
        this.colBuyCost.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).buyCostProperty());
        this.colBuyCost.setCellFactory(data -> new BuyCostCell());
        this.colRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).realizedPlProperty());
        this.colRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.colTodayRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).todayRealizedPlProperty());
        this.colTodayRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.colYield.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).yieldProperty());
        this.colYield.setCellFactory(data -> new DoubleTableCell());
        this.colPercent.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).percentProperty());
        this.colPercent.setCellFactory(data -> new DoubleTableCell());
        this.colNewPrice.setCellValueFactory(data -> ((CcsPosition)data.getValue()).nowPriceProperty());
        this.colNewPrice.setCellFactory(data -> new DoubleTableCell());
        this.colMarket.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).marketProperty());
        this.colAcc.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).inverstorSecIdProperty());
        this.colPortfName.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).portfolioNameProperty());
        this.colPortfId.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).portfolioIdProperty());
        this.colRemark.setCellValueFactory(data -> ((CcsPortfPosition)data.getValue()).remarkProperty());
        this.tablePosition.setPlaceholder((Node)new Label());
        this.tablePosition.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u6295\u7ec4\u6e2f\u80a1\u901a\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void closePosi() {
        CcsPortfPosition position = (CcsPortfPosition)this.tablePosition.getSelectionModel().getSelectedItem();
        if (position == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u5e73\u4ed3");
            return;
        }
        if (position.getCanVol() == 0L) {
            this.alert.alert(Alert.AlertType.ERROR, "\u53ef\u5356\u6570\u91cf\u4e3a0\uff0c\u65e0\u6cd5\u5e73\u4ed3");
            return;
        }
        if (this.model.getPledgeCode().contains(position.getSecId())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u65b0\u6807\u51c6\u5238" + position.getSecId() + "\u65e0\u6cd5\u5e73\u4ed3\uff01");
            return;
        }
        LinkedList<CcsPortfPosition> posList = new LinkedList<CcsPortfPosition>();
        posList.add(position);
        if (this.createDialog(posList)) {
            return;
        }
        MEvent event = this.model.close(position);
        int countSuc = event.getInt("suc.count");
        if (countSuc == 1) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5e73\u4ed3\u63d0\u4ea4\u6210\u529f");
        } else {
            this.alert.alert(Alert.AlertType.ERROR, event.getDesc());
        }
    }

    @FXML
    public void clearPosi() {
        if (this.tablePosition.getItems().size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6e05\u4ed3\u5931\u8d25\uff1a\n\u8868\u683c\u4e2d\u6ca1\u6709\u6570\u636e\uff01");
            return;
        }
        FilteredList posList = this.tablePosition.getItems().filtered(pos -> !this.model.getPledgeCode().contains(pos.getSecId()) && pos.getCanVol() > 0L);
        int zeroNum = this.tablePosition.getItems().size() - posList.size();
        if (posList.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u6e05\u4ed3\u5931\u8d25\uff1a\n\u672a\u5904\u7406\uff1a" + zeroNum + "\u7b14");
            return;
        }
        if (this.createDialog((List<CcsPortfPosition>)posList)) {
            return;
        }
        this.exe.execute(() -> this.lambda$36((ObservableList)posList));
    }

    private void clear(List<CcsPortfPosition> list) {
        MEvent event = this.model.clear(list);
        Platform.runLater(() -> this.alert.alert(Alert.AlertType.INFORMATION, "\u6e05\u4ed3\u63d0\u4ea4\u6210\u529f\uff1a" + event.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + event.getInt("fail.count") + "\u7b14"));
    }

    public boolean extend(Position posi) {
        return false;
    }

    private boolean createDialog(List<CcsPortfPosition> posList) {
        CcsReplaceConfirmDialog obj = (CcsReplaceConfirmDialog)((Object)this.of.create(CcsReplaceConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        this.model.queryMarketItem(posList);
        for (CcsPortfPosition po : posList) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(po.getExtAccId(), po.getExtSecAccId());
            en.setSec(po.getSecId());
            en.setSecName(po.getSecName());
            en.setAcc(po.getInvestorId());
            en.setSecAcc(po.getInverstorSecId());
            en.setSecType(po.getSecType());
            en.setMarket(po.getMarket().getRaw());
            en.setOrderType(50);
            en.setQuantity(po.getCanVol());
            en.setPortfolioName(po.getPortfolioName());
            en.setSide(MxNodeFactory.create((String)"side", (String)Integer.toString(50)));
            try {
                en.setPrice(this.model.getNewPrice(po.getSecType(), po.getMarket().getRaw(), po.getSecId()));
                po.setNewPrice(en.getPrice());
                en.setAmt((double)en.getQuantity() * en.getPrice());
            }
            catch (MException e) {
                en.setTip("\u884c\u60c5\u83b7\u53d6\u5931\u8d25\uff0c\u4e0d\u4e0b\u5355");
                logger.error("\u5e73\u4ed3\u83b7\u53d6\u884c\u60c5\u5931\u8d25", (Throwable)e);
            }
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u5e73\u4ed3");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64cd\u4f5c\u786e\u8ba4");
        return dialog.launch() != ButtonType.OK;
    }

    private /* synthetic */ void lambda$36(ObservableList observableList) {
        this.clear((List<CcsPortfPosition>)observableList);
    }

    private class BuyCostCell
    extends DoubleTableCell<CcsPortfPosition> {
        int scale = 3;

        private BuyCostCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CcsPortfPosition> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsPortfPosition posi = (CcsPortfPosition)CcsPortfPosition.class.cast(this.getTableRow().getItem());
                RefItem refItem = HkwolunPortfPositionPart.this.refMng.getItem(posi.getMarket().getRaw(), posi.getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

