/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.core.MEvent;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.ObCcsOrder;
import cms.tmx.query.current.models.OrderQueryModel;
import cms.tmx.query.current.models.portfolio.HkwolunPortfOrderModel;
import cms.tmx.query.current.views.HkwolunOrderPagePart;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class HkwolunPortfOrderPagePart
extends HkwolunOrderPagePart {
    @FXML
    private TableColumn<ObCcsOrder, String> portfolioId;
    @FXML
    private TableColumn<ObCcsOrder, String> portfolioName;
    @Inject
    private HkwolunPortfOrderModel model;
    protected InvalidationListener lstnModel = ob -> this.refreshList();

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    protected void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.queryingProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            if (newV.booleanValue()) {
                this.lbQuerying.setVisible(true);
            } else {
                this.lbQuerying.setVisible(false);
            }
        }));
    }

    @Override
    @PreDestroy
    protected void close() {
        this.getModel().changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @Override
    protected void createTable() {
        this.portfolioId.setCellValueFactory(data -> new SimpleStringProperty(((ObCcsOrder)data.getValue()).getPortfolioId()));
        this.portfolioName.setCellValueFactory(data -> new SimpleStringProperty(((ObCcsOrder)data.getValue()).getPortfolioName()));
        super.createTable();
        this.tableOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            ObCcsOrder order;
            if (event.getClickCount() == 1 && (order = (ObCcsOrder)this.tableOrder.getSelectionModel().getSelectedItem()) != null) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)order.getSecId());
                e.put((Object)"tMarket", (Object)order.getInstrument().getMarket().getRaw());
                this.es.sendEvent("input_portfoilio_trade", e);
            }
        });
    }

    @Override
    public void onVisit() {
        this.lstnModel.invalidated(null);
    }

    @Override
    @FXML
    public void refresh() {
        this.mxList.setBeginIndex(0);
        this.getModel().query();
    }

    @Override
    protected OrderQueryModel<CcsOrder> getModel() {
        return this.model;
    }
}

