/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.core.MEvent;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.query.current.models.DealQueryModel;
import cms.tmx.query.current.models.portfolio.HkwolunPortfDealModel;
import cms.tmx.query.current.views.CcsDealPart;
import cms.tmx.utils.StringUtils;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;

public class HkwolunPortfDealPart
extends CcsDealPart {
    @FXML
    protected TableColumn<CcsDeal, String> colPortfolioId;
    @FXML
    protected TableColumn<CcsDeal, String> colPortfolioName;
    @FXML
    private TableColumn<CcsDeal, String> colCountPortfolioId;
    @FXML
    private TableColumn<CcsDeal, String> colCountPortfolioName;
    @FXML
    private TableColumn<CcsDeal, Number> colRate;
    @Inject
    protected HkwolunPortfDealModel modelP;
    @FXML
    protected TextField searchText;

    @Override
    @FXML
    public void initialize() {
        super.initialize();
    }

    @Override
    protected void createTable() {
        super.createTable();
        this.afterCreateTable();
        this.tableDoubleClick();
    }

    protected void tableDoubleClick() {
        this.tableDeal.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            CcsDeal deal;
            if (event.getClickCount() == 1 && (deal = (CcsDeal)this.tableDeal.getSelectionModel().getSelectedItem()) != null) {
                MEvent e = new MEvent();
                e.put((Object)"sec_code", (Object)deal.getSecId());
                e.put((Object)"tMarket", (Object)deal.getMarket().getRaw());
                this.es.sendEvent("input_portfoilio_trade", e);
            }
        });
        if (this.tableDealCount != null) {
            this.tableDealCount.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                CcsDeal deal;
                if (event.getClickCount() == 1 && (deal = (CcsDeal)this.tableDealCount.getSelectionModel().getSelectedItem()) != null) {
                    MEvent e = new MEvent();
                    e.put((Object)"sec_code", (Object)deal.getSecId());
                    e.put((Object)"tMarket", (Object)deal.getMarket().getRaw());
                    this.es.sendEvent("input_portfoilio_trade", e);
                }
            });
        }
    }

    @Override
    protected String getKey(CcsDeal deal) {
        String key = String.valueOf(deal.getExtAccntId()) + deal.getPortfolioId() + deal.getInstrument().getSecId() + deal.getSide().getRaw() + deal.getInstrument().getMarket();
        return key;
    }

    protected void afterCreateTable() {
        this.colPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioId()));
        this.colPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
        this.colCountPortfolioId.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioId()));
        this.colCountPortfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
        this.colRate.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getRate()));
        this.colRate.setCellFactory(column -> new RateCell());
    }

    @Override
    @FXML
    public void refresh() {
        this.getModel().query();
    }

    @Override
    protected DealQueryModel<CcsDeal> getModel() {
        return this.modelP;
    }

    private class RateCell
    extends DoubleTableCell<CcsDeal> {
        int scale = 4;

        private RateCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

