/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.views.portfolio;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.basket.AlgoStrategyDetails;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.views.AlgoStrategyDetailDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class EntrustDetailPart
extends MxPart {
    @FXML
    private TableView<AlgoStrategyDetails> tableAlgoDetail;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colIndex;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colsecId;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colSecName;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colSide;
    @FXML
    private TableColumn<AlgoStrategyDetails, Number> colOrderVol;
    @FXML
    private TableColumn<AlgoStrategyDetails, Number> colDeal;
    @FXML
    private TableColumn<AlgoStrategyDetails, Number> colPriceLmt;
    @FXML
    private TableColumn<AlgoStrategyDetails, MxNode> colStatus;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colExeDeal;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colInvestorId;
    @FXML
    private TableColumn<AlgoStrategyDetails, Number> colAvgPrice;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colPortfolioName;
    @FXML
    private TableColumn<AlgoStrategyDetails, String> colRemark;
    @FXML
    protected RadioButton unfinishedOnly;
    @Inject
    private AlgoStrategyQueryModel model;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected MxAlert alert;
    private static final Logger logger = LogManager.getLogger(AlgoStrategyDetailDialog.class);
    private AlgoBaseOrder baseOrder;
    protected MxList<AlgoStrategyDetails> mxList = new MxList();
    private List<AlgoStrategyDetails> list = new LinkedList<AlgoStrategyDetails>();
    @Inject
    protected MEventService es;
    @Inject
    private PortfolioAccountModel portfMng;
    @Inject
    private ExecutorService exe;
    private Predicate<AlgoStrategyDetails> pd = inst -> {
        boolean b = this.unfinishedOnly.isSelected();
        return !b || !"100.00".equals(inst.getExeDeal());
    };
    protected InvalidationListener instModel = ob -> {
        ArrayList<AlgoStrategyDetails> newList = new ArrayList<AlgoStrategyDetails>();
        List<AlgoStrategyDetails> list = this.list;
        synchronized (list) {
            newList.addAll(this.list);
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.tableAlgoDetail.sort();
            this.tableAlgoDetail.refresh();
            this.tableAlgoDetail.layout();
        });
    };

    EntrustDetailPart() {
        this.path = "EntrustDetailPart.fxml";
    }

    @FXML
    public void initialize() {
        this.creatTable();
        this.unfinishedOnly.selectedProperty().addListener(this.instModel);
    }

    private void checkAlgoPriceLmt() {
        AlgoBaseOrder baseOrd = this.getBaseOrder();
        if (baseOrd == null || baseOrd.getType() == null) {
            logger.error("");
            return;
        }
        switch (baseOrd.getType().getRaw()) {
            case "19": 
            case "20": 
            case "190": 
            case "200": {
                if ("49".equals(baseOrd.getSide().getRaw()) || "71".equals(baseOrd.getSide().getRaw())) {
                    this.colPriceLmt.setText("\u4e0a\u9650\u4ef7");
                    break;
                }
                if ("50".equals(baseOrd.getSide().getRaw()) || "70".equals(baseOrd.getSide().getRaw())) {
                    this.colPriceLmt.setText("\u4e0b\u9650\u4ef7");
                    break;
                }
                this.colPriceLmt.setText("\u4e0a/\u4e0b\u9650\u4ef7");
                break;
            }
            default: {
                this.colPriceLmt.setVisible(false);
            }
        }
    }

    @PreDestroy
    public void close() {
        this.unfinishedOnly.selectedProperty().removeListener(this.instModel);
    }

    protected void creatTable() {
        TableUtils.isAuto(this.colIndex);
        this.colsecId.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).secNameProperty());
        this.colSide.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).sideProperty());
        this.colSide.setCellFactory(cell -> new SideCell());
        this.colOrderVol.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).orderVolProperty());
        this.colOrderVol.setCellFactory(data -> new NumberTableCell());
        this.colDeal.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).dealProperty());
        this.colDeal.setCellFactory(data -> new NumberTableCell());
        this.colPriceLmt.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).priceLmtProperty());
        this.colPriceLmt.setCellFactory(data -> new PriceCell());
        this.colStatus.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).statusProperty());
        this.colExeDeal.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).exeDealProperty());
        this.colAvgPrice.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).avgPriceProperty());
        this.colPortfolioName.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).portfolioNameProperty());
        this.colRemark.setCellValueFactory(data -> ((AlgoStrategyDetails)data.getValue()).remarkProperty());
        this.colInvestorId.setCellValueFactory(data -> {
            if (((AlgoStrategyDetails)data.getValue()).getInvestorId().startsWith("SF")) {
                String name = this.portfMng.getFundAccount(((AlgoStrategyDetails)data.getValue()).getInvestorId(), "CCS").getInvestId();
                return new SimpleStringProperty(name);
            }
            return ((AlgoStrategyDetails)data.getValue()).investorIdProperty();
        });
        this.tableAlgoDetail.setItems(this.mxList.getList());
        this.tableAlgoDetail.setPlaceholder((Node)new Label());
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableAlgoDetail);
    }

    @FXML
    public void refresh() {
        this.checkAlgoPriceLmt();
        this.exe.execute(() -> {
            try {
                String acct = this.getBaseOrder().getSubAcct();
                String start = this.getBaseOrder().getOrderDate();
                String end = this.getBaseOrder().getOrderDate();
                String baseId = this.getBaseOrder().getBaseId();
                List<AlgoStrategyDetails> listTemp = this.model.queryAlgoDetail(acct, start, end, baseId);
                this.list.clear();
                this.list.addAll(listTemp);
                this.instModel.invalidated(null);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    @FXML
    public void export() {
        try {
            ExcelUtils.writeExcel(this.tableAlgoDetail, (String)"\u6267\u884c\u8fdb\u5ea6");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public AlgoBaseOrder getBaseOrder() {
        return this.baseOrder;
    }

    public void setBaseOrder(AlgoBaseOrder algoBaseOrder) {
        this.baseOrder = algoBaseOrder;
    }

    private class PriceCell
    extends DoubleTableCell<AlgoStrategyDetails> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                AlgoStrategyDetails detail = (AlgoStrategyDetails)AlgoStrategyDetails.class.cast(this.getTableRow().getItem());
                RefItem refItem = EntrustDetailPart.this.refMng.getItem(detail.getSecType(), detail.getMarket(), detail.getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<AlgoStrategyDetails, String> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            switch (value) {
                case "\u4e70\u5165": {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

